/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox;

import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessage;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageType;
import org.apache.commons.lang3.Validate;

public class NegotiateMaxPayloadSize
extends UltravoxMessage {
    public NegotiateMaxPayloadSize() {
        super(UltravoxMessageType.NEGOTIATE_MAX_PAYLOAD_SIZE);
    }

    NegotiateMaxPayloadSize(byte[] data) {
        super(data);
    }

    public void setMaximumPayloadSize(int desiredMaximum, int minimum) {
        Validate.isTrue((desiredMaximum <= 16377 ? 1 : 0) != 0);
        Validate.isTrue((minimum <= 16377 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        sb.append(desiredMaximum).append(":").append(minimum);
        this.setPayload(sb.toString());
    }

    public int getMaximumPayloadSize() {
        String payload = this.getPayload();
        if (payload != null && payload.startsWith("ACK:")) {
            try {
                int maximumPayloadSize = Integer.parseInt(payload.substring(4));
                return maximumPayloadSize;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }
}

