/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v1;

import com.google.common.base.Joiner;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.IBroadcastMetadataUpdater;
import io.github.dsheirer.audio.broadcast.shoutcast.v1.ShoutcastV1Configuration;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.util.ThreadPool;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.http.HttpClientCodec;
import org.apache.mina.http.HttpRequestImpl;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpVersion;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShoutcastV1BroadcastMetadataUpdater
implements IBroadcastMetadataUpdater {
    private static final Logger mLog = LoggerFactory.getLogger(ShoutcastV1BroadcastMetadataUpdater.class);
    private static final String UTF8 = "UTF-8";
    private ShoutcastV1Configuration mShoutcastV1Configuration;
    private AliasModel mAliasModel;
    private NioSocketConnector mSocketConnector;
    private AtomicBoolean mUpdating = new AtomicBoolean();
    private Queue<String> mMetadataQueue = new LinkedTransferQueue<String>();
    private boolean mStackTraceLoggingSuppressed;

    public ShoutcastV1BroadcastMetadataUpdater(ShoutcastV1Configuration shoutcastV1Configuration, AliasModel aliasModel) {
        this.mShoutcastV1Configuration = shoutcastV1Configuration;
        this.mAliasModel = aliasModel;
    }

    private NioSocketConnector getSocketConnector() {
        if (this.mSocketConnector == null) {
            this.mSocketConnector = new NioSocketConnector();
            this.mSocketConnector.getFilterChain().addLast("http_client_codec", (IoFilter)new HttpClientCodec());
            this.mSocketConnector.setHandler((IoHandler)new IoHandlerAdapter(this){

                public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                    session.closeNow();
                }

                public void messageReceived(IoSession session, Object message) throws Exception {
                    session.closeNow();
                }
            });
        }
        return this.mSocketConnector;
    }

    @Override
    public void update(IdentifierCollection identifierCollection) {
        this.mMetadataQueue.offer(this.getSong(identifierCollection));
        if (this.mUpdating.compareAndSet(false, true)) {
            String song = this.mMetadataQueue.poll();
            while (song != null) {
                final HttpRequest updateRequest = this.createUpdateRequest(song);
                if (updateRequest != null) {
                    ThreadPool.CACHED.submit(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    ConnectFuture connectFuture = ShoutcastV1BroadcastMetadataUpdater.this.getSocketConnector().connect((SocketAddress)new InetSocketAddress(ShoutcastV1BroadcastMetadataUpdater.this.mShoutcastV1Configuration.getHost(), ShoutcastV1BroadcastMetadataUpdater.this.mShoutcastV1Configuration.getPort()));
                                    connectFuture.awaitUninterruptibly();
                                    IoSession session = connectFuture.getSession();
                                    if (session != null) {
                                        session.write((Object)updateRequest);
                                    }
                                }
                                catch (Exception e) {
                                    Throwable throwableCause = e.getCause();
                                    if (throwableCause instanceof ConnectException || ShoutcastV1BroadcastMetadataUpdater.this.mStackTraceLoggingSuppressed) break block3;
                                    mLog.error("Error sending metadata update.  Future errors will be suppressed", (Throwable)e);
                                    ShoutcastV1BroadcastMetadataUpdater.this.mStackTraceLoggingSuppressed = true;
                                }
                            }
                        }
                    });
                }
                song = this.mMetadataQueue.poll();
            }
            this.mUpdating.set(false);
        }
    }

    private String getSong(IdentifierCollection identifierCollection) {
        StringBuilder sb = new StringBuilder();
        if (identifierCollection != null) {
            List<Identifier> fromIdentifiers;
            List<Identifier> toIdentifiers;
            AliasList aliasList = this.mAliasModel.getAliasList(identifierCollection);
            Identifier to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.PATCH_GROUP, Role.TO);
            if (to == null) {
                to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO);
            }
            if (to == null && !(toIdentifiers = identifierCollection.getIdentifiers(Role.TO)).isEmpty()) {
                to = toIdentifiers.get(0);
            }
            if (to != null) {
                sb.append("TO:").append(to);
                List<Alias> aliases = aliasList.getAliases(to);
                if (!aliases.isEmpty()) {
                    sb.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                }
            } else {
                sb.append("TO:UNKNOWN");
            }
            Identifier from = identifierCollection.getIdentifier(IdentifierClass.USER, Form.RADIO, Role.FROM);
            if (from == null && !(fromIdentifiers = identifierCollection.getIdentifiers(Role.FROM)).isEmpty()) {
                from = fromIdentifiers.get(0);
            }
            if (from != null) {
                sb.append(" FROM:").append(from);
                List<Alias> aliases = aliasList.getAliases(from);
                if (!aliases.isEmpty()) {
                    sb.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                }
            } else {
                sb.append(" FROM:UNKNOWN");
            }
        } else {
            sb.append("Scanning ....");
        }
        return sb.toString();
    }

    private HttpRequest createUpdateRequest(String song) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("pass=").append(this.mShoutcastV1Configuration.getPassword());
            sb.append("&mode=updinfo");
            sb.append("&song=").append(URLEncoder.encode(song, UTF8));
            HashMap headers = new HashMap();
            HttpRequestImpl request = new HttpRequestImpl(HttpVersion.HTTP_1_0, HttpMethod.GET, "/admin.cgi", sb.toString(), headers);
            return request;
        }
        catch (UnsupportedEncodingException e) {
            mLog.error("UTF-8 encoding is not supported - can't update song metadata");
            return null;
        }
    }
}

