/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.openmhz;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.AbstractAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.openmhz.FormField;
import io.github.dsheirer.audio.broadcast.openmhz.OpenMHzBuilder;
import io.github.dsheirer.audio.broadcast.openmhz.OpenMHzConfiguration;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.ConfigurationLongIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.time.Duration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMHzBroadcaster
extends AbstractAudioBroadcaster<OpenMHzConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(OpenMHzBroadcaster.class);
    private static final String ENCODING_TYPE_MP3 = "mp3";
    private static final String MULTIPART_TYPE = "multipart";
    private static final String DEFAULT_SUBTYPE = "form-data";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private Queue<AudioRecording> mAudioRecordingQueue = new LinkedTransferQueue<AudioRecording>();
    private ScheduledFuture<?> mAudioRecordingProcessorFuture;
    private HttpClient mHttpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
    private long mLastConnectionAttempt;
    private long mConnectionAttemptInterval = 5000L;
    private AliasModel mAliasModel;

    public OpenMHzBroadcaster(OpenMHzConfiguration config, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(config);
        this.mAliasModel = aliasModel;
    }

    @Override
    public void start() {
        this.setBroadcastState(BroadcastState.CONNECTING);
        String response = OpenMHzBroadcaster.testConnection((OpenMHzConfiguration)this.getBroadcastConfiguration());
        this.mLastConnectionAttempt = System.currentTimeMillis();
        if (response == "OK") {
            this.setBroadcastState(BroadcastState.CONNECTED);
        } else {
            mLog.error("Error connecting to OpenMHz server on startup [" + response + "]");
            this.setBroadcastState(BroadcastState.ERROR);
        }
        if (this.mAudioRecordingProcessorFuture == null) {
            this.mAudioRecordingProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new AudioRecordingProcessor(), 0L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.mAudioRecordingProcessorFuture != null) {
            this.mAudioRecordingProcessorFuture.cancel(true);
            this.mAudioRecordingProcessorFuture = null;
            this.dispose();
            this.setBroadcastState(BroadcastState.DISCONNECTED);
        }
    }

    @Override
    public void dispose() {
        AudioRecording audioRecording = this.mAudioRecordingQueue.poll();
        while (audioRecording != null) {
            audioRecording.removePendingReplay();
            audioRecording = this.mAudioRecordingQueue.poll();
        }
    }

    private boolean connected() {
        if (this.getBroadcastState() != BroadcastState.CONNECTED && System.currentTimeMillis() - this.mLastConnectionAttempt > this.mConnectionAttemptInterval) {
            this.setBroadcastState(BroadcastState.CONNECTING);
            String response = OpenMHzBroadcaster.testConnection((OpenMHzConfiguration)this.getBroadcastConfiguration());
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (response != null && response == "200") {
                this.setBroadcastState(BroadcastState.CONNECTED);
            } else {
                this.setBroadcastState(BroadcastState.ERROR);
            }
        }
        return this.getBroadcastState() == BroadcastState.CONNECTED;
    }

    @Override
    public int getAudioQueueSize() {
        return this.mAudioRecordingQueue.size();
    }

    @Override
    public void receive(AudioRecording audioRecording) {
        this.mAudioRecordingQueue.offer(audioRecording);
        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
    }

    private boolean isValid(AudioRecording audioRecording) {
        return audioRecording != null && System.currentTimeMillis() - audioRecording.getStartTime() <= ((OpenMHzConfiguration)this.getBroadcastConfiguration()).getMaximumRecordingAge();
    }

    private void processRecordingQueue() {
        AudioRecording audioRecording;
        while (this.connected() && !this.mAudioRecordingQueue.isEmpty()) {
            audioRecording = this.mAudioRecordingQueue.poll();
            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_QUEUE_CHANGE));
            if (!this.isValid(audioRecording) || audioRecording.getRecordingLength() <= 0L) continue;
            int durationSeconds = (int)((float)audioRecording.getRecordingLength() / 1000.0f);
            long timestampSeconds = (int)((double)audioRecording.getStartTime() / 1000.0);
            String talkgroup = OpenMHzBroadcaster.getTo(audioRecording);
            String radioId = OpenMHzBroadcaster.getFrom(audioRecording);
            Long frequency = OpenMHzBroadcaster.getFrequency(audioRecording);
            String patches = OpenMHzBroadcaster.getPatches(audioRecording);
            String talkgroupLabel = this.getTalkgroupLabel(audioRecording);
            String talkgroupGroup = this.getTalkgroupGroup(audioRecording);
            String systemLabel = this.getSystemLabel(audioRecording);
            try {
                byte[] audioBytes = null;
                try {
                    audioBytes = Files.readAllBytes(audioRecording.getPath());
                }
                catch (IOException e) {
                    mLog.error("OpenMHz - audio recording file not found - ignoring upload");
                }
                if (audioBytes != null) {
                    String uri = ((OpenMHzConfiguration)this.getBroadcastConfiguration()).getHost() + "/" + ((OpenMHzConfiguration)this.getBroadcastConfiguration()).getSystemName() + "/upload";
                    OpenMHzBuilder bodyBuilder = new OpenMHzBuilder();
                    bodyBuilder.addFile(audioBytes).addPart(FormField.FREQ, frequency).addPart(FormField.START_TIME, timestampSeconds).addPart(FormField.STOP_TIME, timestampSeconds).addPart(FormField.CALL_LENGTH, durationSeconds).addPart(FormField.TALKGROUP_NUM, talkgroup).addPart(FormField.EMERGENCY, 0).addPart(FormField.API_KEY, ((OpenMHzConfiguration)this.getBroadcastConfiguration()).getApiKey()).addPart(FormField.SOURCE_LIST, "[{ \"pos\": 0.00, \"src\": " + radioId + "}]");
                    HttpRequest fileRequest = HttpRequest.newBuilder().uri(URI.create(uri)).header("Content-Type", "multipart/form-data; boundary=" + bodyBuilder.getBoundary()).header("User-Agent", "sdrtrunk").POST(bodyBuilder.build()).build();
                    this.mHttpClient.sendAsync(fileRequest, HttpResponse.BodyHandlers.ofString()).whenComplete((fileResponse, throwable1) -> {
                        if (throwable1 != null || fileResponse.statusCode() != 200) {
                            if (throwable1 instanceof IOException || throwable1 instanceof CompletionException) {
                                this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                                mLog.error("OpenMHz API file upload fail [" + fileResponse.statusCode() + "] response [" + (String)fileResponse.body() + "]");
                            } else {
                                this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                                mLog.error("OpenMHz API file upload fail [" + fileResponse.statusCode() + "] response [" + (String)fileResponse.body() + "]");
                            }
                            this.incrementErrorAudioCount();
                            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                        } else if (fileResponse.statusCode() == 200) {
                            this.incrementStreamedAudioCount();
                            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_STREAMED_COUNT_CHANGE));
                            audioRecording.removePendingReplay();
                        } else {
                            this.setBroadcastState(BroadcastState.TEMPORARY_BROADCAST_ERROR);
                            mLog.error("OpenMHz API file upload fail [" + fileResponse.statusCode() + "] response [" + (String)fileResponse.body() + "]");
                        }
                    });
                    continue;
                }
                mLog.error("OpenMHz API - upload file not found [" + audioRecording.getPath().toString() + "]");
                this.incrementErrorAudioCount();
                this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                audioRecording.removePendingReplay();
            }
            catch (Exception e) {
                mLog.error("Unknown Error", (Throwable)e);
                this.setBroadcastState(BroadcastState.ERROR);
                this.incrementErrorAudioCount();
                this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_ERROR_COUNT_CHANGE));
                audioRecording.removePendingReplay();
            }
        }
        audioRecording = this.mAudioRecordingQueue.peek();
        while (audioRecording != null) {
            if (this.isValid(audioRecording)) {
                return;
            }
            this.mAudioRecordingQueue.poll();
            audioRecording.removePendingReplay();
            this.incrementAgedOffAudioCount();
            this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_AGED_OFF_COUNT_CHANGE));
            audioRecording = this.mAudioRecordingQueue.peek();
        }
    }

    private static Long getFrequency(AudioRecording audioRecording) {
        Long value;
        Identifier identifier = audioRecording.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL_FREQUENCY, Role.ANY);
        if (identifier instanceof ConfigurationLongIdentifier && (value = (Long)((ConfigurationLongIdentifier)identifier).getValue()) != null) {
            return value;
        }
        return 0L;
    }

    private static String getFrom(AudioRecording audioRecording) {
        for (Identifier identifier : audioRecording.getIdentifierCollection().getIdentifiers(Role.FROM)) {
            if (!(identifier instanceof RadioIdentifier)) continue;
            return ((Integer)((RadioIdentifier)identifier).getValue()).toString();
        }
        return "0";
    }

    private static String getTo(AudioRecording audioRecording) {
        Identifier identifier = audioRecording.getIdentifierCollection().getToIdentifier();
        if (identifier instanceof PatchGroupIdentifier) {
            PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
            return ((Integer)((PatchGroup)patchGroupIdentifier.getValue()).getPatchGroup().getValue()).toString();
        }
        if (identifier instanceof TalkgroupIdentifier) {
            TalkgroupIdentifier talkgroupIdentifier = (TalkgroupIdentifier)identifier;
            return String.valueOf(RadioReferenceDecoder.convertToRadioReferenceTalkgroup((Integer)talkgroupIdentifier.getValue(), talkgroupIdentifier.getProtocol()));
        }
        if (identifier instanceof RadioIdentifier) {
            RadioIdentifier radioIdentifier = (RadioIdentifier)identifier;
            return ((Integer)radioIdentifier.getValue()).toString();
        }
        return "0";
    }

    private String getTalkgroupLabel(AudioRecording audioRecording) {
        List<Alias> aliases;
        AliasList aliasList = this.mAliasModel.getAliasList(audioRecording.getIdentifierCollection());
        Identifier identifier = audioRecording.getIdentifierCollection().getToIdentifier();
        StringBuilder sb = new StringBuilder();
        if (identifier != null && !(aliases = aliasList.getAliases(identifier)).isEmpty()) {
            sb.append(aliases.get(0));
        }
        return sb.toString();
    }

    private String getTalkgroupGroup(AudioRecording audioRecording) {
        List<Alias> aliases;
        AliasList aliasList = this.mAliasModel.getAliasList(audioRecording.getIdentifierCollection());
        Identifier identifier = audioRecording.getIdentifierCollection().getToIdentifier();
        StringBuilder sb = new StringBuilder();
        if (identifier != null && !(aliases = aliasList.getAliases(identifier)).isEmpty()) {
            sb.append(aliases.get(0).getGroup());
        }
        return sb.toString();
    }

    private String getSystemLabel(AudioRecording audioRecording) {
        List<Identifier> systems = audioRecording.getIdentifierCollection().getIdentifiers(Form.SYSTEM);
        StringBuilder sb = new StringBuilder();
        if (!systems.isEmpty()) {
            sb.append(systems.get(0));
        }
        return sb.toString();
    }

    public static String getPatches(AudioRecording audioRecording) {
        Identifier identifier = audioRecording.getIdentifierCollection().getToIdentifier();
        if (identifier instanceof PatchGroupIdentifier) {
            PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
            PatchGroup patchGroup = (PatchGroup)patchGroupIdentifier.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(((Integer)patchGroup.getPatchGroup().getValue()).toString());
            for (TalkgroupIdentifier talkgroupIdentifier : patchGroup.getPatchedTalkgroupIdentifiers()) {
                sb.append(",").append(talkgroupIdentifier.getValue());
            }
            for (RadioIdentifier radioIdentifier : patchGroup.getPatchedRadioIdentifiers()) {
                sb.append(",").append(radioIdentifier.getValue());
            }
            sb.append("]");
            return sb.toString();
        }
        return "[]";
    }

    public static String testConnection(OpenMHzConfiguration configuration) {
        String uri = configuration.getHost() + "/" + configuration.getSystemName() + "/authorize";
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(uri)).header("Content-Type", APPLICATION_FORM_URLENCODED).header("User-Agent", "sdrtrunk").POST(HttpRequest.BodyPublishers.ofString("api_key=" + configuration.getApiKey())).build();
        HttpResponse.BodyHandler<String> responseHandler = HttpResponse.BodyHandlers.ofString();
        try {
            HttpResponse<String> response = httpClient.send(request, responseHandler);
            String responseBody = response.body();
            if (response.statusCode() == 200) {
                return "OK";
            }
            if (response.statusCode() == 403) {
                return "Invalid API Key";
            }
            if (response.statusCode() == 500) {
                return "Invalid System Name";
            }
            return "No Response";
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    public static void main(String[] args) {
        mLog.debug("Starting ...");
        OpenMHzConfiguration config = new OpenMHzConfiguration();
        config.setHost("https://api.OpenMHz.com/call-upload-dev");
        config.setApiKey("c33aae37-8572-11ea-bd8b-0ecc8ab9ccec");
        config.setSystemName("systemx");
        String response = OpenMHzBroadcaster.testConnection(config);
        mLog.error("Response: " + response);
        if (response == "OK") {
            mLog.debug("Test Successful!");
        } else if (response.contains("Invalid API Key")) {
            mLog.error("Invalid API Key");
        } else if (response.contains("Invalid System Name")) {
            mLog.error("Invalid System Name");
        } else {
            mLog.debug("Response: " + response);
        }
        mLog.debug("Finished!");
    }

    public class AudioRecordingProcessor
    implements Runnable {
        @Override
        public void run() {
            OpenMHzBroadcaster.this.processRecordingQueue();
        }
    }
}

