/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.icecast.IcecastAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHeader;
import io.github.dsheirer.audio.broadcast.icecast.IcecastMetadata;
import io.github.dsheirer.audio.broadcast.icecast.IcecastTCPConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.codec.IcecastCodecFactory;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcecastTCPAudioBroadcaster
extends IcecastAudioBroadcaster {
    private static final Logger mLog = LoggerFactory.getLogger(IcecastTCPAudioBroadcaster.class);
    private static final String TERMINATOR = "\n";
    private static final String SEPARATOR = ":";
    private static final long RECONNECT_INTERVAL_MILLISECONDS = 3000L;
    private static final long CONNECTION_ATTEMPT_TIMEOUT_MILLISECONDS = 5000L;
    private static final int WRITE_TIMEOUT_SECONDS = 5;
    private NioSocketConnector mSocketConnector;
    private IoSession mStreamingSession = null;
    private long mLastConnectionAttempt = 0L;
    private AtomicBoolean mConnecting = new AtomicBoolean();

    public IcecastTCPAudioBroadcaster(IcecastTCPConfiguration configuration, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(configuration, inputAudioFormat, mp3Setting, aliasModel);
    }

    @Override
    protected void broadcastAudio(byte[] audio, IdentifierCollection identifierCollection) {
        if (audio != null && audio.length > 0 && this.connect() && this.mStreamingSession != null && this.mStreamingSession.isConnected()) {
            if (this.mInlineActive) {
                byte[] chunk;
                byte[] metadata = IcecastMetadata.formatInline(IcecastMetadata.getTitle(identifierCollection, this.mAliasModel)).getBytes();
                if (this.mInlineRemaining == -1) {
                    this.mInlineRemaining = this.mInlineInterval;
                }
                for (int audioOffset = 0; audioOffset < audio.length; audioOffset += chunk.length) {
                    chunk = Arrays.copyOfRange(audio, audioOffset, Math.min(audioOffset + this.mInlineRemaining, audio.length));
                    this.mInlineRemaining -= chunk.length;
                    this.mStreamingSession.write((Object)chunk);
                    if (this.mInlineRemaining != 0) continue;
                    this.mInlineRemaining = this.mInlineInterval;
                    this.mStreamingSession.write((Object)metadata);
                }
            } else {
                this.mStreamingSession.write((Object)audio);
            }
        }
    }

    private boolean connect() {
        if (!this.connected() && this.canConnect() && this.mLastConnectionAttempt + 3000L < System.currentTimeMillis() && this.mConnecting.compareAndSet(false, true)) {
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (this.mSocketConnector == null) {
                this.mSocketConnector = new NioSocketConnector();
                this.mSocketConnector.getSessionConfig().setWriteTimeout(5);
                this.mSocketConnector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new IcecastCodecFactory()));
                this.mSocketConnector.setHandler((IoHandler)new IcecastTCPIOHandler());
            }
            this.mStreamingSession = null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTING);
                    try {
                        ConnectFuture future = IcecastTCPAudioBroadcaster.this.mSocketConnector.connect((SocketAddress)new InetSocketAddress(((BroadcastConfiguration)IcecastTCPAudioBroadcaster.this.getBroadcastConfiguration()).getHost(), ((BroadcastConfiguration)IcecastTCPAudioBroadcaster.this.getBroadcastConfiguration()).getPort()));
                        boolean connected = future.await(5000L, TimeUnit.MILLISECONDS);
                        if (connected) {
                            IcecastTCPAudioBroadcaster.this.mStreamingSession = future.getSession();
                            IcecastTCPAudioBroadcaster.this.mConnecting.set(false);
                            return;
                        }
                    }
                    catch (RuntimeIoException rioe) {
                        if (rioe.getCause() instanceof SocketException) {
                            IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.NETWORK_UNAVAILABLE);
                            IcecastTCPAudioBroadcaster.this.mConnecting.set(false);
                            return;
                        }
                    }
                    catch (UnresolvedAddressException uae) {
                        IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.NETWORK_UNAVAILABLE);
                        IcecastTCPAudioBroadcaster.this.mConnecting.set(false);
                        return;
                    }
                    catch (Exception e) {
                        mLog.error("Error", (Throwable)e);
                    }
                    catch (Throwable t) {
                        mLog.error("Throwable error caught", t);
                    }
                    IcecastTCPAudioBroadcaster.this.disconnect();
                    IcecastTCPAudioBroadcaster.this.mConnecting.set(false);
                }
            };
            ThreadPool.CACHED.submit(runnable);
        }
        return this.connected();
    }

    @Override
    public void disconnect() {
        if (this.connected() && this.mStreamingSession != null) {
            this.mStreamingSession.closeNow();
        } else {
            if (!this.getBroadcastState().isErrorState()) {
                this.setBroadcastState(BroadcastState.DISCONNECTED);
            }
            this.mLastConnectionAttempt = System.currentTimeMillis();
        }
    }

    public class IcecastTCPIOHandler
    extends IoHandlerAdapter {
        public void sessionOpened(IoSession session) throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append("SOURCE ").append(IcecastTCPAudioBroadcaster.this.getConfiguration().getMountPoint());
            sb.append(" HTTP/1.0").append(IcecastTCPAudioBroadcaster.TERMINATOR);
            sb.append("Authorization: ").append(IcecastTCPAudioBroadcaster.this.getConfiguration().getBase64EncodedCredentials()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            sb.append(IcecastHeader.USER_AGENT.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(SystemProperties.getInstance().getApplicationName()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            sb.append(IcecastHeader.CONTENT_TYPE.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(IcecastTCPAudioBroadcaster.this.getConfiguration().getBroadcastFormat().getValue()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            sb.append(IcecastHeader.PUBLIC.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(IcecastTCPAudioBroadcaster.this.getConfiguration().isPublic() ? "1" : "0").append(IcecastTCPAudioBroadcaster.TERMINATOR);
            sb.append(IcecastHeader.AUDIO_INFO.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR);
            sb.append("samplerate=").append(IcecastTCPAudioBroadcaster.this.getConfiguration().getSampleRate()).append(";");
            sb.append("quality=").append(7).append(";");
            sb.append("channels=").append(IcecastTCPAudioBroadcaster.this.getConfiguration().getChannels()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            if (IcecastTCPAudioBroadcaster.this.getConfiguration().hasName()) {
                sb.append(IcecastHeader.NAME.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(IcecastTCPAudioBroadcaster.this.getConfiguration().getName()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            }
            if (IcecastTCPAudioBroadcaster.this.getConfiguration().hasGenre()) {
                sb.append(IcecastHeader.GENRE.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(IcecastTCPAudioBroadcaster.this.getConfiguration().getGenre()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            }
            if (IcecastTCPAudioBroadcaster.this.getConfiguration().hasDescription()) {
                sb.append(IcecastHeader.DESCRIPTION.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(IcecastTCPAudioBroadcaster.this.getConfiguration().getDescription()).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            }
            if (IcecastTCPAudioBroadcaster.this.getConfiguration().hasInline()) {
                IcecastTCPAudioBroadcaster.this.mInlineActive = true;
                IcecastTCPAudioBroadcaster.this.mInlineInterval = IcecastTCPAudioBroadcaster.this.getConfiguration().getInlineInterval();
                sb.append(IcecastHeader.METAINT.getValue()).append(IcecastTCPAudioBroadcaster.SEPARATOR).append(String.valueOf(IcecastTCPAudioBroadcaster.this.mInlineInterval)).append(IcecastTCPAudioBroadcaster.TERMINATOR);
            } else {
                IcecastTCPAudioBroadcaster.this.mInlineActive = false;
            }
            session.write((Object)sb.toString());
        }

        public void sessionClosed(IoSession session) throws Exception {
            IcecastTCPAudioBroadcaster.this.mLastConnectionAttempt = System.currentTimeMillis();
            if (!IcecastTCPAudioBroadcaster.this.getBroadcastState().isErrorState()) {
                IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
            }
            IcecastTCPAudioBroadcaster.this.mStreamingSession = null;
            IcecastTCPAudioBroadcaster.this.mConnecting.set(false);
            super.sessionClosed(session);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (!(cause instanceof IOException)) {
                mLog.error("[" + IcecastTCPAudioBroadcaster.this.getStreamName() + "] Broadcast error", cause);
            }
            IcecastTCPAudioBroadcaster.this.disconnect();
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (object instanceof String) {
                String message = (String)object;
                if (message != null && !message.trim().isEmpty()) {
                    if (message.startsWith("HTTP/1.0 200 OK")) {
                        IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTED);
                    } else if (message.startsWith("HTTP/1.0 403 Mountpoint in use")) {
                        IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.MOUNT_POINT_IN_USE);
                    } else if (!message.contains("Content-Type: text/html")) {
                        if (message.contains("Invalid Password") || message.contains("Authentication Required")) {
                            IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.INVALID_CREDENTIALS);
                        } else if (message.contains("HTTP/1.1 501")) {
                            IcecastTCPAudioBroadcaster.this.disconnect();
                        } else {
                            mLog.error("Unrecognized server response:" + message);
                            IcecastTCPAudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                        }
                    }
                }
            } else {
                mLog.error("[" + IcecastTCPAudioBroadcaster.this.getStreamName() + "]Icecast TCP broadcaster - unrecognized message [ " + String.valueOf(object.getClass()) + "] received:" + object.toString());
            }
        }
    }
}

