/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.audio.broadcast.icecast.IcecastAudioBroadcaster;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHTTPConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHeader;
import io.github.dsheirer.audio.broadcast.icecast.IcecastMetadata;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.util.ThreadPool;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.http.HttpClientCodec;
import org.apache.mina.http.HttpRequestImpl;
import org.apache.mina.http.api.DefaultHttpResponse;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpVersion;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcecastHTTPAudioBroadcaster
extends IcecastAudioBroadcaster {
    private static final Logger mLog = LoggerFactory.getLogger(IcecastHTTPAudioBroadcaster.class);
    private static final long RECONNECT_INTERVAL_MILLISECONDS = 30000L;
    private static final String HTTP_1_0_OK_HEX_DUMP = "48 54 54 50 2F 31 2E 30 20 32 30 30 20 4F 4B";
    private NioSocketConnector mSocketConnector;
    private IoSession mStreamingSession = null;
    private Map<String, String> mHTTPHeaders;
    private long mLastConnectionAttempt = 0L;
    private AtomicBoolean mConnecting = new AtomicBoolean();

    public IcecastHTTPAudioBroadcaster(IcecastHTTPConfiguration configuration, InputAudioFormat inputAudioFormat, MP3Setting mp3Setting, AliasModel aliasModel) {
        super(configuration, inputAudioFormat, mp3Setting, aliasModel);
    }

    @Override
    protected void broadcastAudio(byte[] audio, IdentifierCollection identifierCollection) {
        if (audio != null && audio.length > 0 && this.connect() && this.mStreamingSession != null && this.mStreamingSession.isConnected()) {
            IoBuffer buffer = IoBuffer.allocate((int)audio.length);
            if (this.mInlineActive) {
                byte[] chunk;
                byte[] metadata = IcecastMetadata.formatInline(IcecastMetadata.getTitle(identifierCollection, this.mAliasModel)).getBytes();
                buffer.setAutoExpand(true);
                if (this.mInlineRemaining == -1) {
                    this.mInlineRemaining = this.mInlineInterval;
                }
                for (int audioOffset = 0; audioOffset < audio.length; audioOffset += chunk.length) {
                    chunk = Arrays.copyOfRange(audio, audioOffset, Math.min(audioOffset + this.mInlineRemaining, audio.length));
                    this.mInlineRemaining -= chunk.length;
                    buffer.put(chunk);
                    if (this.mInlineRemaining != 0) continue;
                    this.mInlineRemaining = this.mInlineInterval;
                    buffer.put(metadata);
                }
                buffer.shrink();
            } else {
                buffer.put(audio);
            }
            buffer.flip();
            this.mStreamingSession.write((Object)buffer);
        }
    }

    private boolean connect() {
        if (!this.connected() && this.canConnect() && this.mLastConnectionAttempt + 30000L < System.currentTimeMillis() && this.mConnecting.compareAndSet(false, true)) {
            this.mLastConnectionAttempt = System.currentTimeMillis();
            if (this.mSocketConnector == null) {
                this.mSocketConnector = new NioSocketConnector();
                this.mSocketConnector.setConnectTimeoutCheckInterval(10000L);
                this.mSocketConnector.getFilterChain().addLast("codec", (IoFilter)new HttpClientCodec());
                this.mSocketConnector.setHandler((IoHandler)new IcecastHTTPIOHandler());
            }
            this.mStreamingSession = null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTING);
                    try {
                        ConnectFuture future = IcecastHTTPAudioBroadcaster.this.mSocketConnector.connect((SocketAddress)new InetSocketAddress(((BroadcastConfiguration)IcecastHTTPAudioBroadcaster.this.getBroadcastConfiguration()).getHost(), ((BroadcastConfiguration)IcecastHTTPAudioBroadcaster.this.getBroadcastConfiguration()).getPort()));
                        future.awaitUninterruptibly();
                        IcecastHTTPAudioBroadcaster.this.mStreamingSession = future.getSession();
                    }
                    catch (RuntimeIoException rie) {
                        Throwable throwableCause = rie.getCause();
                        if (throwableCause instanceof ConnectException) {
                            IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.NO_SERVER);
                        } else if (throwableCause != null) {
                            IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                            mLog.debug("Failed to connect", (Throwable)rie);
                        } else {
                            IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                            mLog.debug("Failed to connect - no exception is available");
                        }
                        IcecastHTTPAudioBroadcaster.this.disconnect();
                    }
                    IcecastHTTPAudioBroadcaster.this.mConnecting.set(false);
                }
            };
            ThreadPool.CACHED.submit(runnable);
        }
        return this.connected();
    }

    @Override
    public void disconnect() {
        if (this.mStreamingSession != null) {
            this.mStreamingSession.closeNow();
        }
    }

    public static void main(String[] args) {
        String text = "HTTP/1.0 403 Forbidden";
        Pattern pattern = Pattern.compile("HTTP/1.0 (\\d{3})");
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            mLog.info("Matching Group Count: " + m.groupCount());
            mLog.info("Match 0: " + m.group(0));
            mLog.info("Match 1: " + m.group(1));
        } else {
            mLog.info("No Match");
        }
    }

    public class IcecastHTTPIOHandler
    extends IoHandlerAdapter {
        public void sessionOpened(IoSession session) throws Exception {
            HttpRequestImpl request = new HttpRequestImpl(HttpVersion.HTTP_1_1, HttpMethod.PUT, IcecastHTTPAudioBroadcaster.this.getConfiguration().getMountPoint(), "", this.getHTTPHeaders());
            session.write((Object)request);
        }

        private Map<String, String> getHTTPHeaders() {
            if (IcecastHTTPAudioBroadcaster.this.mHTTPHeaders == null) {
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders = new HashMap<String, String>();
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.ACCEPT.getValue(), "*/*");
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.CONTENT_TYPE.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getBroadcastFormat().getValue());
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.USER_AGENT.getValue(), SystemProperties.getInstance().getApplicationName());
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.AUTHORIZATION.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getBase64EncodedCredentials());
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.PUBLIC.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().isPublic() ? "1" : "0");
                StringBuilder sb = new StringBuilder();
                sb.append("samplerate=").append(IcecastHTTPAudioBroadcaster.this.getConfiguration().getSampleRate()).append(";");
                sb.append("quality=").append(7).append(";");
                sb.append("channels=").append(IcecastHTTPAudioBroadcaster.this.getConfiguration().getChannels());
                IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.AUDIO_INFO.getValue(), sb.toString());
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasName()) {
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.NAME.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getName());
                }
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasDescription()) {
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.DESCRIPTION.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getDescription());
                }
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasURL()) {
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.URL.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getURL());
                }
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasGenre()) {
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.GENRE.getValue(), IcecastHTTPAudioBroadcaster.this.getConfiguration().getGenre());
                }
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasBitRate()) {
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.BITRATE.getValue(), String.valueOf(IcecastHTTPAudioBroadcaster.this.getConfiguration().getBitRate()));
                }
                if (IcecastHTTPAudioBroadcaster.this.getConfiguration().hasInline()) {
                    IcecastHTTPAudioBroadcaster.this.mInlineActive = true;
                    IcecastHTTPAudioBroadcaster.this.mInlineInterval = IcecastHTTPAudioBroadcaster.this.getConfiguration().getInlineInterval();
                    IcecastHTTPAudioBroadcaster.this.mHTTPHeaders.put(IcecastHeader.METAINT.getValue(), String.valueOf(IcecastHTTPAudioBroadcaster.this.mInlineInterval));
                } else {
                    IcecastHTTPAudioBroadcaster.this.mInlineActive = false;
                }
            }
            return IcecastHTTPAudioBroadcaster.this.mHTTPHeaders;
        }

        public void sessionClosed(IoSession session) throws Exception {
            if (!IcecastHTTPAudioBroadcaster.this.getBroadcastState().isErrorState()) {
                IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
            }
            IcecastHTTPAudioBroadcaster.this.mSocketConnector.dispose();
            IcecastHTTPAudioBroadcaster.this.mStreamingSession = null;
            IcecastHTTPAudioBroadcaster.this.mSocketConnector = null;
            IcecastHTTPAudioBroadcaster.this.mConnecting.set(false);
            super.sessionClosed(session);
        }

        public void exceptionCaught(IoSession session, Throwable throwable) throws Exception {
            if (throwable instanceof ProtocolDecoderException) {
                Throwable cause = throwable.getCause();
                if (cause instanceof ArrayIndexOutOfBoundsException) {
                    String hexDump = ((ProtocolDecoderException)throwable).getHexdump();
                    if (hexDump.startsWith(IcecastHTTPAudioBroadcaster.HTTP_1_0_OK_HEX_DUMP)) {
                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTED);
                    } else {
                        HttpDumpMessage message = new HttpDumpMessage(IcecastHTTPAudioBroadcaster.this, hexDump);
                        if (message.hasHttpResponseCode()) {
                            switch (message.getHttpResponseCode()) {
                                case 403: {
                                    if (message.toString().contains("Mountpoint in use")) {
                                        mLog.error("Stream [" + IcecastHTTPAudioBroadcaster.this.getStreamName() + "] - unable to connect - mountpoint in use");
                                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.MOUNT_POINT_IN_USE);
                                        IcecastHTTPAudioBroadcaster.this.disconnect();
                                        break;
                                    }
                                    mLog.error("String [" + IcecastHTTPAudioBroadcaster.this.getStreamName() + "] - HTTP protocol decoder error - message:\n\n" + String.valueOf(message));
                                    IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                                    IcecastHTTPAudioBroadcaster.this.disconnect();
                                    break;
                                }
                                default: {
                                    mLog.error("String [" + IcecastHTTPAudioBroadcaster.this.getStreamName() + "] - HTTP protocol decoder error - message:\n\n" + String.valueOf(message));
                                    IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                                    IcecastHTTPAudioBroadcaster.this.disconnect();
                                    break;
                                }
                            }
                        } else {
                            mLog.error("HTTP protocol decoder error - message:\n\n" + String.valueOf(message));
                            IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                            IcecastHTTPAudioBroadcaster.this.disconnect();
                        }
                    }
                } else {
                    mLog.error("HTTP protocol decoder error", throwable);
                    IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                    IcecastHTTPAudioBroadcaster.this.disconnect();
                }
            } else {
                mLog.error("Broadcast error", throwable);
                IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.DISCONNECTED);
                IcecastHTTPAudioBroadcaster.this.disconnect();
            }
            IcecastHTTPAudioBroadcaster.this.mConnecting.set(false);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (object instanceof DefaultHttpResponse) {
                DefaultHttpResponse response = (DefaultHttpResponse)object;
                switch (response.getStatus()) {
                    case INFORMATIONAL_CONTINUE: {
                        break;
                    }
                    case SUCCESS_OK: {
                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONNECTED);
                        IcecastHTTPAudioBroadcaster.this.mConnecting.set(false);
                        break;
                    }
                    case CLIENT_ERROR_UNAUTHORIZED: {
                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.INVALID_CREDENTIALS);
                        IcecastHTTPAudioBroadcaster.this.disconnect();
                        break;
                    }
                    case CLIENT_ERROR_FORBIDDEN: {
                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.CONFIGURATION_ERROR);
                        IcecastHTTPAudioBroadcaster.this.disconnect();
                        break;
                    }
                    default: {
                        IcecastHTTPAudioBroadcaster.this.setBroadcastState(BroadcastState.ERROR);
                        IcecastHTTPAudioBroadcaster.this.disconnect();
                        mLog.debug("Unspecified error: " + response.toString() + " Class:" + String.valueOf(object.getClass()));
                        break;
                    }
                }
            } else {
                mLog.error("Icecast HTTP broadcaster - unrecognized message [ " + String.valueOf(object.getClass()) + "] received:" + object.toString());
            }
        }
    }

    public class HttpDumpMessage {
        private String mHexDump;
        private String mMessage;
        private int mHttpResponseCode = -1;

        public HttpDumpMessage(IcecastHTTPAudioBroadcaster this$0, String hexDump) {
            this.mHexDump = hexDump;
            String[] split = this.mHexDump.split(" ");
            byte[] bytes = new byte[split.length];
            int pointer = 0;
            for (String a : split) {
                try {
                    int value = Integer.parseInt(a, 16);
                    bytes[pointer++] = (byte)(value & 0xFF);
                }
                catch (Exception e) {
                    ++pointer;
                }
            }
            this.mMessage = new String(bytes);
            Pattern pattern = Pattern.compile("HTTP/1.0 (\\d{3})");
            Matcher m = pattern.matcher(this.mMessage);
            if (m.find()) {
                try {
                    this.mHttpResponseCode = Integer.parseInt(m.group(1));
                }
                catch (Exception e) {
                    mLog.error("Unable to parse HTTP response code that was matched from message: " + m.group(1));
                }
            }
        }

        public boolean hasHttpResponseCode() {
            return this.mHttpResponseCode != -1;
        }

        public int getHttpResponseCode() {
            return this.mHttpResponseCode;
        }

        public String toString() {
            return this.mMessage;
        }
    }
}

