/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.broadcastify;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.icecast.IcecastTCPConfiguration;
import io.github.dsheirer.rrapi.type.UserFeedBroadcast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastifyFeedConfiguration
extends IcecastTCPConfiguration {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastifyFeedConfiguration.class);
    private int mFeedID;

    public BroadcastifyFeedConfiguration() {
        this(BroadcastFormat.MP3);
    }

    public BroadcastifyFeedConfiguration(BroadcastFormat format) {
        super(format);
        this.setBitRate(16);
        this.setChannels(1);
        this.setSampleRate(8000);
        this.setInline(true);
    }

    public static BroadcastifyFeedConfiguration from(UserFeedBroadcast userFeedBroadcast) {
        BroadcastifyFeedConfiguration config = new BroadcastifyFeedConfiguration(BroadcastFormat.MP3);
        config.setName(userFeedBroadcast.getDescription());
        config.setHost(userFeedBroadcast.getHostname());
        config.setMountPoint(userFeedBroadcast.getMount());
        config.setFeedID(userFeedBroadcast.getFeedId());
        config.setPassword(userFeedBroadcast.getPassword());
        try {
            config.setPort(Integer.parseInt(userFeedBroadcast.getPort()));
        }
        catch (Exception e) {
            mLog.error("Error creating broadcastify configuration from radio reference user feed instance");
        }
        return config;
    }

    @Override
    public BroadcastConfiguration copyOf() {
        BroadcastifyFeedConfiguration copy = new BroadcastifyFeedConfiguration(this.getBroadcastFormat());
        copy.setName(this.getName());
        copy.setHost(this.getHost());
        copy.setPort(this.getPort());
        copy.setInline(this.getInline());
        copy.setPassword(this.getPassword());
        copy.setDelay(this.getDelay());
        copy.setEnabled(false);
        copy.setUserName(this.getUserName());
        copy.setMountPoint(this.getMountPoint());
        copy.setDescription(this.getDescription());
        copy.setGenre(this.getGenre());
        copy.setPublic(this.isPublic());
        copy.setURL(this.getURL());
        copy.setFeedID(this.getFeedID());
        return copy;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.BROADCASTIFY;
    }

    @JacksonXmlProperty(isAttribute=true, localName="feed_id")
    public int getFeedID() {
        return this.mFeedID;
    }

    public void setFeedID(int feedID) {
        this.mFeedID = feedID;
    }
}

