/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.identifier.IdentifierCollection;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioRecording
implements Comparable<AudioRecording> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioRecording.class);
    private Path mPath;
    private long mStartTime;
    private long mRecordingLength;
    private AtomicInteger mPendingReplayCount = new AtomicInteger();
    private IdentifierCollection mIdentifierCollection;
    private Collection<BroadcastChannel> mBroadcastChannels;

    public AudioRecording(Path path, Collection<BroadcastChannel> broadcastChannels, IdentifierCollection identifierCollection, long start, long recordingLength) {
        this.mPath = path;
        this.mBroadcastChannels = broadcastChannels;
        this.mIdentifierCollection = identifierCollection;
        this.mStartTime = start;
        this.mRecordingLength = recordingLength;
    }

    public Path getPath() {
        return this.mPath;
    }

    public Collection<BroadcastChannel> getBroadcastChannels() {
        return this.mBroadcastChannels;
    }

    public IdentifierCollection getIdentifierCollection() {
        return this.mIdentifierCollection;
    }

    public boolean hasIdentifierCollection() {
        return this.mIdentifierCollection != null;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getRecordingLength() {
        return this.mRecordingLength;
    }

    @Override
    public int compareTo(AudioRecording otherRecording) {
        return Long.compare(this.getStartTime(), otherRecording.getStartTime());
    }

    public void addPendingReplay() {
        this.mPendingReplayCount.incrementAndGet();
    }

    public void removePendingReplay() {
        this.mPendingReplayCount.decrementAndGet();
    }

    public boolean hasPendingReplays() {
        return this.mPendingReplayCount.get() > 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AudioRecording)) {
            return false;
        }
        return this.compareTo((AudioRecording)o) == 0;
    }
}

