/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast;

import io.github.dsheirer.audio.broadcast.AudioRecording;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastState;
import io.github.dsheirer.sample.Listener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioBroadcaster<T extends BroadcastConfiguration>
implements Listener<AudioRecording> {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractAudioBroadcaster.class);
    private Listener<BroadcastEvent> mBroadcastEventListener;
    private T mBroadcastConfiguration;
    protected ObjectProperty<BroadcastState> mBroadcastState = new SimpleObjectProperty((Object)BroadcastState.READY);
    protected int mStreamedAudioCount = 0;
    protected int mErrorAudioCount = 0;
    protected int mAgedOffAudioCount = 0;

    public AbstractAudioBroadcaster(T broadcastConfiguration) {
        this.mBroadcastConfiguration = broadcastConfiguration;
    }

    public ObjectProperty<BroadcastState> broadcastStateProperty() {
        return this.mBroadcastState;
    }

    public BroadcastState getBroadcastState() {
        return (BroadcastState)((Object)this.mBroadcastState.get());
    }

    public void setBroadcastState(BroadcastState broadcastState) {
        this.mBroadcastState.setValue((Object)broadcastState);
        this.broadcast(new BroadcastEvent(this, BroadcastEvent.Event.BROADCASTER_STATE_CHANGE));
    }

    public abstract void start();

    public abstract void stop();

    public abstract void dispose();

    public T getBroadcastConfiguration() {
        return this.mBroadcastConfiguration;
    }

    public void setListener(Listener<BroadcastEvent> listener) {
        this.mBroadcastEventListener = listener;
    }

    public void removeListener() {
        this.mBroadcastEventListener = null;
    }

    protected void broadcast(BroadcastEvent event) {
        if (this.mBroadcastEventListener != null) {
            this.mBroadcastEventListener.receive(event);
        }
    }

    public int getStreamedAudioCount() {
        return this.mStreamedAudioCount;
    }

    public void incrementStreamedAudioCount() {
        ++this.mStreamedAudioCount;
    }

    public int getAgedOffAudioCount() {
        return this.mAgedOffAudioCount;
    }

    public void incrementAgedOffAudioCount() {
        ++this.mAgedOffAudioCount;
    }

    public abstract int getAudioQueueSize();

    public int getAudioErrorCount() {
        return this.mErrorAudioCount;
    }

    public void incrementErrorAudioCount() {
        ++this.mErrorAudioCount;
    }
}

