/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.IAudioSegmentProvider;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioModule
extends Module
implements IAudioSegmentProvider,
IdentifierUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractAudioModule.class);
    public static final long DEFAULT_SEGMENT_AUDIO_SAMPLE_LENGTH = 480000L;
    public static final int DEFAULT_TIMESLOT = 0;
    private final int mMaxSegmentAudioSampleLength;
    private Listener<AudioSegment> mAudioSegmentListener;
    protected MutableIdentifierCollection mIdentifierCollection;
    private Broadcaster<IdentifierUpdateNotification> mIdentifierUpdateNotificationBroadcaster = new Broadcaster();
    private AliasList mAliasList;
    private AudioSegment mAudioSegment;
    private int mAudioSampleCount = 0;
    private boolean mRecordAudioOverride;
    private int mTimeslot;

    public AbstractAudioModule(AliasList aliasList, int timeslot, long maxSegmentAudioSampleLength) {
        this.mAliasList = aliasList;
        this.mMaxSegmentAudioSampleLength = (int)(maxSegmentAudioSampleLength * 8L);
        this.mTimeslot = timeslot;
        this.mIdentifierCollection = new MutableIdentifierCollection(this.getTimeslot());
        this.mIdentifierUpdateNotificationBroadcaster.addListener(this.mIdentifierCollection);
    }

    public AbstractAudioModule(AliasList aliasList) {
        this(aliasList, 0, 480000L);
    }

    protected int getTimeslot() {
        return this.mTimeslot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAudioSegment() {
        AbstractAudioModule abstractAudioModule = this;
        synchronized (abstractAudioModule) {
            if (this.mAudioSegment != null) {
                this.mAudioSegment.completeProperty().set(true);
                this.mIdentifierUpdateNotificationBroadcaster.removeListener(this.mAudioSegment);
                this.mAudioSegment.decrementConsumerCount();
                this.mAudioSegment = null;
            }
        }
    }

    @Override
    public void stop() {
        this.closeAudioSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioSegment getAudioSegment() {
        AbstractAudioModule abstractAudioModule = this;
        synchronized (abstractAudioModule) {
            if (this.mAudioSegment == null) {
                this.mAudioSegment = new AudioSegment(this.mAliasList, this.getTimeslot());
                this.mAudioSegment.incrementConsumerCount();
                this.mAudioSegment.addIdentifiers(this.mIdentifierCollection.getIdentifiers());
                this.mIdentifierUpdateNotificationBroadcaster.addListener(this.mAudioSegment);
                if (this.mRecordAudioOverride) {
                    this.mAudioSegment.recordAudioProperty().set(true);
                }
                if (this.mAudioSegmentListener != null) {
                    this.mAudioSegment.incrementConsumerCount();
                    this.mAudioSegmentListener.receive(this.mAudioSegment);
                }
                this.mAudioSampleCount = 0;
            }
            return this.mAudioSegment;
        }
    }

    public void addAudio(float[] audioBuffer) {
        AudioSegment audioSegment = this.getAudioSegment();
        if (this.mAudioSampleCount >= this.mMaxSegmentAudioSampleLength) {
            AudioSegment previous = this.getAudioSegment();
            this.closeAudioSegment();
            audioSegment = this.getAudioSegment();
            audioSegment.linkTo(previous);
        }
        try {
            audioSegment.addAudio(audioBuffer);
            this.mAudioSampleCount += audioBuffer.length;
        }
        catch (Exception e) {
            this.closeAudioSegment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordAudio(boolean recordAudio) {
        this.mRecordAudioOverride = recordAudio;
        if (this.mRecordAudioOverride) {
            AbstractAudioModule abstractAudioModule = this;
            synchronized (abstractAudioModule) {
                if (this.mAudioSegment != null) {
                    this.mAudioSegment.recordAudioProperty().set(true);
                }
            }
        }
    }

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return this.mIdentifierUpdateNotificationBroadcaster;
    }

    public MutableIdentifierCollection getIdentifierCollection() {
        return this.mIdentifierCollection;
    }

    @Override
    public void setAudioSegmentListener(Listener<AudioSegment> listener) {
        this.mAudioSegmentListener = listener;
    }

    @Override
    public void removeAudioSegmentListener() {
        this.mAudioSegmentListener = null;
    }
}

