/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.tone;

import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.identifier.tone.Tone;
import io.github.dsheirer.identifier.tone.ToneSequence;
import java.util.List;
import javafx.collections.ListChangeListener;

public class TonesID
extends AliasID
implements ListChangeListener<Tone> {
    private ToneSequence mToneSequence;

    public TonesID() {
        this.setToneSequence(new ToneSequence());
    }

    public TonesID(ToneSequence toneSequence) {
        this.setToneSequence(toneSequence);
    }

    @Override
    public AliasIDType getType() {
        return AliasIDType.TONES;
    }

    public ToneSequence getToneSequence() {
        return this.mToneSequence;
    }

    public void setToneSequence(ToneSequence toneSequence) {
        if (this.mToneSequence != null) {
            this.mToneSequence.tonesProperty().removeListener((ListChangeListener)this);
        }
        this.mToneSequence = toneSequence;
        this.mToneSequence.tonesProperty().addListener((ListChangeListener)this);
    }

    @Override
    public boolean matches(AliasID id) {
        boolean match = true;
        if (this.mToneSequence.getTones().isEmpty() || !(id instanceof TonesID)) {
            match = false;
        } else {
            List<Tone> otherTones = ((TonesID)id).getToneSequence().getTones();
            List<Tone> thisTones = this.mToneSequence.getTones();
            if (thisTones.size() == otherTones.size()) {
                for (int x = 0; x < thisTones.size(); ++x) {
                    if (thisTones.get(x).getAmbeTone() == otherTones.get(x).getAmbeTone()) continue;
                    match = false;
                }
            } else {
                match = false;
            }
        }
        return match;
    }

    @Override
    public boolean isValid() {
        return this.getToneSequence() != null && this.getToneSequence().hasTones();
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    public String toString() {
        if (this.getToneSequence() != null) {
            return "Tones: " + this.getToneSequence().toString();
        }
        return "Tones: (empty)";
    }

    public void onChanged(ListChangeListener.Change<? extends Tone> c) {
        this.updateValueProperty();
    }
}

