/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.talkgroup;

import io.github.dsheirer.protocol.Protocol;

public enum TalkgroupFormat {
    AM("*****", 1, 65535, "1 to 65,535", "AM valid value range is 1-65,535"),
    APCO25("********", 0, 65535, "0 to 65,535", "<html>APCO25 talkgroup valid range is 0 to 65,535"),
    DMR("********", 0, 0xFFFFFF, "0 to 16,777,215", "<html>DMR talkgroup valid range is 0 to 16,777,215"),
    FLEETSYNC("###-####", 0, 0x7FFFFF, "001-0001 to 127-8192", "<html>Fleetsync valid ranges are 1-127(prefix)<br>and 1-8192(ident) (ie. 001-0001 to 127-8192)"),
    LTR("##-###", 257, 16383, "01-001 to 20-255", "<html>LTR valid ranges are 1-20(repeater) and 1-255(talkgroup) (ie. 01-001 to 20-255)"),
    MDC1200("*****", 1, 65535, "1 to 65,535", "MDC-1200 valid value range is 1-65,535"),
    MPT1327("###-####", 1, 0x7FFFFF, "000-0001 to 127-8192", "<html>MPT-1327 valid ranges are 0-127(prefix)<br>and 1-8192(ident) (ie. 000-0001 to 127-8192)"),
    NBFM("*****", 1, 65535, "1 to 65,535", "NBFM valid value range is 1-65,535"),
    PASSPORT("*****", 1, 65535, "1 to 65,535", "Passport valid value range is 1-65,535"),
    UNKNOWN("********", 1, 0xFFFFFF, "1 to 16,777,215", "Unknown protocol valid value range is 1-16,777,215");

    private String mMask;
    private int mMinimumValue;
    private int mMaximumValue;
    private String mValidRangeDescription;
    private String mValidRangeHelpText;

    private TalkgroupFormat(String mask, int minimumValue, int maximumValue, String validRangeDescription, String validRangeHelpText) {
        this.mMask = mask;
        this.mMinimumValue = minimumValue;
        this.mMaximumValue = maximumValue;
        this.mValidRangeDescription = validRangeDescription;
        this.mValidRangeHelpText = validRangeHelpText;
    }

    public String getMask() {
        return this.mMask;
    }

    public int getMinimumValidValue() {
        return this.mMinimumValue;
    }

    public int getMaximumValidValue() {
        return this.mMaximumValue;
    }

    public boolean isValid(int value) {
        return this.getMinimumValidValue() <= value && value <= this.getMaximumValidValue();
    }

    public String getValidRangeDescription() {
        return this.mValidRangeDescription;
    }

    public String getValidRangeHelpText() {
        return this.mValidRangeHelpText;
    }

    public static TalkgroupFormat get(Protocol protocol) {
        if (protocol == null) {
            return UNKNOWN;
        }
        switch (protocol) {
            case AM: {
                return AM;
            }
            case APCO25: {
                return APCO25;
            }
            case FLEETSYNC: {
                return FLEETSYNC;
            }
            case LTR: 
            case LTR_NET: {
                return LTR;
            }
            case MDC1200: {
                return MDC1200;
            }
            case MPT1327: {
                return MPT1327;
            }
            case NBFM: {
                return NBFM;
            }
            case PASSPORT: {
                return PASSPORT;
            }
        }
        return UNKNOWN;
    }
}

