/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.priority;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;

public class Priority
extends AliasID {
    public static final int DO_NOT_MONITOR = -1;
    public static final int SELECTED_PRIORITY = 0;
    public static final int MIN_PRIORITY = 1;
    public static final int MAX_PRIORITY = 100;
    public static final int DEFAULT_PRIORITY = 100;
    private int mPriority = 100;

    public Priority() {
    }

    public Priority(int priority) {
        this.mPriority = priority;
    }

    @Override
    public boolean isAudioIdentifier() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @JsonIgnore
    public boolean isDoNotMonitor() {
        return this.mPriority == -1;
    }

    @JacksonXmlProperty(isAttribute=true, localName="priority")
    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
        this.updateValueProperty();
    }

    public String toString() {
        return "Audio Priority: " + String.valueOf(this.isDoNotMonitor() ? "Do Not Monitor" : Integer.valueOf(this.mPriority));
    }

    @Override
    public boolean matches(AliasID id) {
        return false;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.PRIORITY;
    }
}

