/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.legacy.talkgroup;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;

public class LegacyTalkgroupID
extends AliasID {
    private String mTalkgroup;

    public LegacyTalkgroupID() {
    }

    public LegacyTalkgroupID(String talkgroup) {
        this.mTalkgroup = talkgroup;
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="talkgroup")
    public String getTalkgroup() {
        return this.mTalkgroup;
    }

    public void setTalkgroup(String talkgroup) {
        this.mTalkgroup = talkgroup;
    }

    @Override
    public boolean isValid() {
        return this.mTalkgroup != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Legacy Talkgroup:").append(this.mTalkgroup).append(" *Disabled - Please use Talkgroup instead");
        return sb.toString();
    }

    @Override
    public boolean matches(AliasID id) {
        boolean retVal = false;
        if (id instanceof LegacyTalkgroupID) {
            LegacyTalkgroupID tgid = (LegacyTalkgroupID)id;
            String pattern = this.mTalkgroup.replace("*", ".?");
            retVal = tgid.getTalkgroup().matches(pattern);
        }
        return retVal;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasIDType getType() {
        return AliasIDType.LEGACY_TALKGROUP;
    }
}

