/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.id.dcs;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.module.decode.dcs.DCSCode;

public class Dcs
extends AliasID
implements Comparable<Dcs> {
    private DCSCode mDCSCode;

    @Override
    public AliasIDType getType() {
        return AliasIDType.DCS;
    }

    @Override
    public boolean matches(AliasID id) {
        if (this.isValid() && id instanceof Dcs) {
            Dcs other = (Dcs)id;
            return other.isValid() && this.getDCSCode().equals((Object)other.getDCSCode());
        }
        return false;
    }

    @JacksonXmlProperty(isAttribute=true, localName="code")
    public DCSCode getDCSCode() {
        return this.mDCSCode;
    }

    public void setDCSCode(DCSCode dcsCode) {
        this.mDCSCode = dcsCode;
        this.updateValueProperty();
    }

    @Override
    public boolean isValid() {
        return this.mDCSCode != null;
    }

    @Override
    public boolean isAudioIdentifier() {
        return false;
    }

    public String toString() {
        if (this.isValid()) {
            return this.getDCSCode().toString();
        }
        return "DCS-Invalid - No Tone Selected";
    }

    @Override
    public int compareTo(Dcs o) {
        if (this.isValid()) {
            if (o.isValid()) {
                return this.getDCSCode().compareTo(o.getDCSCode());
            }
            return 1;
        }
        return -1;
    }
}

