/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.action.clip;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.action.AliasActionType;
import io.github.dsheirer.alias.action.RecurringAction;
import io.github.dsheirer.message.IMessage;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipAction
extends RecurringAction {
    private static final Logger mLog = LoggerFactory.getLogger(ClipAction.class);
    private String mFilePath;
    @JsonIgnore
    private Clip mClip;

    public ClipAction() {
        this.updateValueProperty();
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public AliasActionType getType() {
        return AliasActionType.CLIP;
    }

    public String getPath() {
        return this.mFilePath;
    }

    public void setPath(String path) {
        this.mFilePath = path;
        this.updateValueProperty();
    }

    @Override
    public void performAction(Alias alias, IMessage message) {
        try {
            this.play();
        }
        catch (Exception e) {
            mLog.error("Couldn't play audio clip", (Throwable)e);
        }
    }

    public void play() throws Exception {
        try {
            if (this.mFilePath != null) {
                if (this.mClip == null) {
                    this.mClip = AudioSystem.getClip();
                    AudioInputStream ais = AudioSystem.getAudioInputStream(new File(this.mFilePath));
                    this.mClip.open(ais);
                }
                if (this.mClip.isRunning()) {
                    this.mClip.stop();
                }
                this.mClip.setFramePosition(0);
                this.mClip.start();
            }
        }
        catch (Exception e) {
            this.mClip = null;
            mLog.error("Error playing sound clip [" + this.mFilePath + "] - " + e.getMessage());
            throw e;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Play Audio Clip");
        if (this.getInterval() != null) {
            switch (this.getInterval()) {
                case ONCE: {
                    sb.append(" Once");
                    break;
                }
                case DELAYED_RESET: {
                    sb.append(" Once, Reset After ").append(this.getPeriod()).append(" Seconds");
                    break;
                }
                case UNTIL_DISMISSED: {
                    sb.append(" Every ").append(this.getPeriod()).append(" Seconds Until Dismissed");
                }
            }
        }
        if (this.getPath() == null) {
            sb.append(" - (audio file empty)");
        }
        return sb.toString();
    }
}

