/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.util.ThreadPool;
import java.awt.EventQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;

public abstract class RecurringAction
extends AliasAction {
    @JsonIgnore
    protected AtomicBoolean mRunning = new AtomicBoolean(false);
    @JsonIgnore
    private ScheduledFuture<?> mPerpetualAction;
    protected Interval mInterval = Interval.ONCE;
    protected int mPeriod = 5;

    public abstract void performAction(Alias var1, IMessage var2);

    @Override
    public void execute(Alias alias, IMessage message) {
        if (this.mRunning.compareAndSet(false, true)) {
            switch (this.mInterval) {
                case ONCE: {
                    this.performThreadedAction(alias, message);
                    break;
                }
                case DELAYED_RESET: {
                    this.performThreadedAction(alias, message);
                    ThreadPool.SCHEDULED.schedule(new ResetTask(), (long)this.mPeriod, TimeUnit.SECONDS);
                    break;
                }
                case UNTIL_DISMISSED: {
                    this.mPerpetualAction = ThreadPool.SCHEDULED.scheduleAtFixedRate(new PerformActionTask(alias, message), 0L, this.mPeriod, TimeUnit.SECONDS);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html><div width='250'>Alias [");
                    sb.append(alias.getName());
                    sb.append("] is active in message [");
                    sb.append(message.toString());
                    sb.append("]</div></html>");
                    String text = sb.toString();
                    EventQueue.invokeLater(() -> {
                        JOptionPane.showMessageDialog(null, text, "Alias Alert", 1);
                        this.dismiss(false);
                        ThreadPool.SCHEDULED.schedule(new ResetTask(), 15L, TimeUnit.SECONDS);
                    });
                    break;
                }
            }
        }
    }

    private void performThreadedAction(Alias alias, IMessage message) {
        ThreadPool.CACHED.execute(() -> this.performAction(alias, message));
    }

    @Override
    public void dismiss(boolean reset) {
        if (this.mPerpetualAction != null) {
            this.mPerpetualAction.cancel(true);
            this.mPerpetualAction = null;
        }
        if (reset) {
            this.mRunning.set(false);
        }
    }

    @JacksonXmlProperty(isAttribute=true, localName="period")
    public int getPeriod() {
        return this.mPeriod;
    }

    public void setPeriod(int period) {
        this.mPeriod = period;
        this.updateValueProperty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="interval")
    public Interval getInterval() {
        return this.mInterval;
    }

    public void setInterval(Interval interval) {
        this.mInterval = interval;
        this.mRunning.set(false);
        this.updateValueProperty();
    }

    public static enum Interval {
        ONCE("Once"),
        DELAYED_RESET("Once - Reset After Delay"),
        UNTIL_DISMISSED("Until Dismissed");

        private String mLabel;

        private Interval(String label) {
            this.mLabel = label;
        }

        public String toString() {
            return this.mLabel;
        }
    }

    public class ResetTask
    implements Runnable {
        @Override
        public void run() {
            RecurringAction.this.mRunning.set(false);
        }
    }

    public class PerformActionTask
    implements Runnable {
        private Alias mAlias;
        private IMessage mMessage;

        public PerformActionTask(Alias alias, IMessage message) {
            this.mAlias = alias;
            this.mMessage = message;
        }

        @Override
        public void run() {
            RecurringAction.this.performAction(this.mAlias, this.mMessage);
        }
    }
}

