/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias.action;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.sample.Listener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasActionManager
extends Module
implements IMessageListener,
Listener<IMessage> {
    private static final Logger mLog = LoggerFactory.getLogger(AliasActionManager.class);
    private AliasList mAliasList;

    public AliasActionManager(AliasList aliasList) {
        this.mAliasList = aliasList;
    }

    @Override
    public void receive(IMessage message) {
        if (this.mAliasList != null && message.isValid()) {
            List<Identifier> identifiers = message.getIdentifiers();
            for (Identifier identifier : identifiers) {
                List<Alias> aliases = this.mAliasList.getAliases(identifier);
                for (Alias alias : aliases) {
                    if (alias == null || !alias.hasActions()) continue;
                    for (AliasAction action : alias.getAliasActions()) {
                        action.execute(alias, message);
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        return this;
    }
}

