/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.alias;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasModel {
    private static final Logger mLog = LoggerFactory.getLogger(AliasModel.class);
    public static final String NO_ALIAS_LIST = "(No Alias List)";
    private ObservableList<Alias> mAliases = FXCollections.observableArrayList(Alias.extractor());
    private ObservableList<String> mAliasListNames = FXCollections.observableArrayList();
    private Map<String, AliasList> mAliasListMap = new HashMap<String, AliasList>();

    public AliasModel() {
        this.mAliases.addListener((ListChangeListener)new AliasListChangeListener());
    }

    public ObservableList<Alias> aliasList() {
        return this.mAliases;
    }

    public ObservableList<String> aliasListNames() {
        return this.mAliasListNames;
    }

    public List<Alias> getAliases() {
        return Collections.unmodifiableList(this.mAliases);
    }

    public void clear() {
        ArrayList<Alias> aliasToRemove = new ArrayList<Alias>((Collection<Alias>)this.mAliases);
        for (Alias alias : aliasToRemove) {
            this.removeAlias(alias);
        }
        this.mAliasListNames.clear();
    }

    public AliasList getAliasList(IdentifierCollection identifierCollection) {
        if (identifierCollection != null) {
            return this.getAliasList(identifierCollection.getAliasListConfiguration());
        }
        return null;
    }

    public AliasList getAliasList(AliasListConfigurationIdentifier configurationIdentifier) {
        if (configurationIdentifier != null && configurationIdentifier.isValid()) {
            return this.getAliasList((String)configurationIdentifier.getValue());
        }
        return null;
    }

    public AliasList getAliasList(String name) {
        if (name == null || name.isEmpty()) {
            return new AliasList(name);
        }
        AliasList mapValue = this.mAliasListMap.get(name);
        if (mapValue != null) {
            return mapValue;
        }
        AliasList aliasList = new AliasList(name);
        for (Alias alias : this.mAliases) {
            if (!alias.hasList() || !alias.getAliasListName().equalsIgnoreCase(name)) continue;
            aliasList.addAlias(alias);
        }
        this.mAliasListMap.put(name, aliasList);
        return aliasList;
    }

    public List<String> getListNames() {
        return this.mAliasListNames;
    }

    public List<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Alias alias : this.mAliases) {
            if (!alias.hasGroup() || groupNames.contains(alias.getGroup())) continue;
            groupNames.add(alias.getGroup());
        }
        Collections.sort(groupNames);
        return groupNames;
    }

    public void addAliases(List<Alias> aliases) {
        this.removeAliases(aliases);
        this.mAliases.addAll(aliases);
    }

    public void addAlias(Alias alias) {
        if (this.mAliases.contains((Object)alias)) {
            this.removeAlias(alias);
        }
        this.mAliases.add((Object)alias);
    }

    private boolean hasAliasList(String aliasListName) {
        return aliasListName != null && this.mAliasListMap.containsKey(aliasListName);
    }

    public void addAliasList(String aliasListName) {
        if (aliasListName != null && !aliasListName.isEmpty()) {
            if (!this.mAliasListNames.contains((Object)aliasListName)) {
                this.mAliasListNames.add((Object)aliasListName);
            }
        } else if (!this.mAliasListNames.contains((Object)NO_ALIAS_LIST)) {
            this.mAliasListNames.add((Object)NO_ALIAS_LIST);
        }
    }

    public void removeAlias(Alias alias) {
        if (alias != null) {
            this.mAliases.remove((Object)alias);
            if (this.hasAliasList(alias.getAliasListName())) {
                this.getAliasList(alias.getAliasListName()).removeAlias(alias);
            }
        }
    }

    public void removeAliases(List<Alias> aliases) {
        if (aliases != null && !aliases.isEmpty()) {
            this.mAliases.removeAll(aliases);
            for (Alias alias : aliases) {
                if (!this.hasAliasList(alias.getAliasListName())) continue;
                this.getAliasList(alias.getAliasListName()).removeAlias(alias);
            }
        }
    }

    public List<Alias> getAliases(String aliasListName, AliasIDType type) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        block0: for (Alias alias : this.mAliases) {
            if (!alias.hasList() || !alias.getAliasListName().equalsIgnoreCase(aliasListName)) continue;
            for (AliasID aliasID : alias.getAliasIdentifiers()) {
                if (aliasID.getType() != type) continue;
                aliases.add(alias);
                continue block0;
            }
        }
        return aliases;
    }

    public boolean hasAliasesWithBroadcastChannel(String broadcastChannel) {
        if (broadcastChannel == null || broadcastChannel.isEmpty()) {
            return false;
        }
        for (Alias alias : this.mAliases) {
            if (!alias.hasBroadcastChannel(broadcastChannel)) continue;
            return true;
        }
        return false;
    }

    public void updateBroadcastChannel(String previousStreamName, String updatedStreamName) {
        if (previousStreamName == null || previousStreamName.isEmpty() || updatedStreamName == null || updatedStreamName.isEmpty()) {
            return;
        }
        for (Alias alias : this.mAliases) {
            if (!alias.hasBroadcastChannel(previousStreamName)) continue;
            for (BroadcastChannel broadcastChannel : alias.getBroadcastChannels()) {
                if (!broadcastChannel.getChannelName().contentEquals(previousStreamName)) continue;
                alias.removeAliasID(broadcastChannel);
                if (alias.hasBroadcastChannel(updatedStreamName)) continue;
                alias.addAliasID(new BroadcastChannel(updatedStreamName));
            }
        }
    }

    public class AliasListChangeListener
    implements ListChangeListener<Alias> {
        public void onChanged(ListChangeListener.Change<? extends Alias> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Alias alias : change.getAddedSubList()) {
                        AliasModel.this.addAliasList(alias.getAliasListName());
                        if (!AliasModel.this.hasAliasList(alias.getAliasListName())) continue;
                        AliasModel.this.getAliasList(alias.getAliasListName()).addAlias(alias);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Alias alias : change.getRemoved()) {
                    if (!AliasModel.this.hasAliasList(alias.getAliasListName())) continue;
                    AliasList aliasList = AliasModel.this.getAliasList(alias.getName());
                    if (alias == null) continue;
                    aliasList.removeAlias(alias);
                }
            }
        }
    }
}

