/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.YItem;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class YChartItem
implements YItem,
Comparable<YChartItem> {
    private final ItemEvent ITEM_EVENT = new ItemEvent<YChartItem>(this);
    private CopyOnWriteArrayList<ItemEventListener> listeners;
    private double _y;
    private DoubleProperty y;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;

    public YChartItem() {
        this(0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE);
    }

    public YChartItem(double Y, String NAME) {
        this(Y, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE);
    }

    public YChartItem(double Y, String NAME, Color FILL) {
        this(Y, NAME, FILL, Color.TRANSPARENT, Symbol.NONE);
    }

    public YChartItem(double Y, String NAME, Color FILL, Color STROKE, Symbol SYMBOL) {
        this._y = Y;
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._symbol = SYMBOL;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    public double getY() {
        return null == this.y ? this._y : this.y.get();
    }

    @Override
    public void setY(double Y) {
        if (null == this.y) {
            this._y = Y;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.y.set(Y);
        }
    }

    @Override
    public DoubleProperty yProperty() {
        if (null == this.y) {
            this.y = new DoublePropertyBase(this._y){

                protected void invalidated() {
                    YChartItem.this.fireItemEvent(YChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return YChartItem.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    YChartItem.this.fireItemEvent(YChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return YChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    YChartItem.this.fireItemEvent(YChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return YChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    YChartItem.this.fireItemEvent(YChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return YChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    YChartItem.this.fireItemEvent(YChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return YChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public void setOnItemEvent(ItemEventListener LISTENER) {
        this.addItemEventListener(LISTENER);
    }

    public void addItemEventListener(ItemEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeItemEventListener(ItemEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireItemEvent(ItemEvent EVENT) {
        for (ItemEventListener listener : this.listeners) {
            listener.onItemEvent(EVENT);
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"y\":" + this.getY() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }

    @Override
    public int compareTo(YChartItem ITEM) {
        return Double.compare(this.getY(), ITEM.getY());
    }
}

