/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.PlotItem;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.tools.CtxBounds;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.geometry.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class SankeyPlot
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color DEFAULT_STREAM_COLOR = Color.rgb((int)164, (int)164, (int)164, (double)0.55);
    private static final Color DEFAULT_ITEM_COLOR = Color.rgb((int)164, (int)164, (int)164);
    private static final int DEFAULT_ITEM_WIDTH = 20;
    private static final int DEFAULT_NODE_GAP = 20;
    private static final double DEFAULT_OPACITY = 0.55;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObservableList<PlotItem> items = FXCollections.observableArrayList();
    private ItemEventListener itemListener = e -> this.redraw();
    private ListChangeListener<PlotItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
        }
        this.prepareData();
    };
    private Map<Integer, List<PlotItemData>> itemsPerLevel = new LinkedHashMap<Integer, List<PlotItemData>>();
    private int minLevel;
    private int maxLevel;
    private double scaleY;
    private StreamFillMode _streamFillMode = StreamFillMode.COLOR;
    private ObjectProperty<StreamFillMode> streamFillMode;
    private Color _streamColor = DEFAULT_STREAM_COLOR;
    private ObjectProperty<Color> streamColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private int _itemWidth = 20;
    private IntegerProperty itemWidth;
    private boolean _autoItemWidth = true;
    private BooleanProperty autoItemWidth;
    private int _itemGap = 20;
    private IntegerProperty itemGap;
    private boolean _autoItemGap = true;
    private BooleanProperty autoItemGap;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _showFlowDirection = false;
    private BooleanProperty showFlowDirection;
    private boolean _useItemColor = true;
    private BooleanProperty useItemColor;
    private Color _itemColor = DEFAULT_ITEM_COLOR;
    private ObjectProperty<Color> itemColor;
    private double _connectionOpacity = 0.55;
    private DoubleProperty connectionOpacity;
    private Locale _locale = Locale.getDefault();
    private ObjectProperty<Locale> locale;
    private String formatString = "%." + this._decimals + "f";
    private Map<Path, String> paths = new LinkedHashMap<Path, String>();
    private Tooltip tooltip;

    public SankeyPlot() {
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.tooltip = new Tooltip();
        this.tooltip.setAutoHide(true);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMouseClicked(e -> this.paths.forEach((path, tooltipText) -> {
            double eventY;
            double eventX = e.getX();
            if (path.contains(eventX, eventY = e.getY())) {
                double tooltipX = eventX + this.canvas.getScene().getX() + this.canvas.getScene().getWindow().getX();
                double tooltipY = eventY + this.canvas.getScene().getY() + this.canvas.getScene().getWindow().getY() - 25.0;
                this.tooltip.setText(tooltipText);
                this.tooltip.setX(tooltipX);
                this.tooltip.setY(tooltipY);
                this.tooltip.show(this.getScene().getWindow());
            }
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public List<PlotItem> getItems() {
        return this.items;
    }

    public void setItems(PlotItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<PlotItem> ITEMS) {
        this.items.setAll(ITEMS);
        this.prepareData();
    }

    public void addItem(PlotItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
        this.prepareData();
    }

    public void removeItem(PlotItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
        this.prepareData();
    }

    public StreamFillMode getStreamFillMode() {
        return null == this.streamFillMode ? this._streamFillMode : (StreamFillMode)((Object)this.streamFillMode.get());
    }

    public void setStreamFillMode(StreamFillMode MODE) {
        if (null == this.streamFillMode) {
            this._streamFillMode = MODE;
            this.redraw();
        } else {
            this.streamFillMode.set((Object)MODE);
        }
    }

    public ObjectProperty<StreamFillMode> streamFillModeProperty() {
        if (null == this.streamFillMode) {
            this.streamFillMode = new ObjectPropertyBase<StreamFillMode>(this._streamFillMode){

                protected void invalidated() {
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "streamFillMode";
                }
            };
            this._streamFillMode = null;
        }
        return this.streamFillMode;
    }

    public Color getStreamColor() {
        return null == this.streamColor ? this._streamColor : (Color)this.streamColor.get();
    }

    public void setStreamColor(Color COLOR) {
        if (null == this.streamColor) {
            this._streamColor = COLOR;
            this.redraw();
        } else {
            this.streamColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> streamColorProperty() {
        if (null == this.streamColor) {
            this.streamColor = new ObjectPropertyBase<Color>(this._streamColor){

                protected void invalidated() {
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "streamColor";
                }
            };
            this._streamColor = null;
        }
        return this.streamColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public int getItemWidth() {
        return null == this.itemWidth ? this._itemWidth : this.itemWidth.get();
    }

    public void setItemWidth(int WIDTH) {
        if (null == this.itemWidth) {
            this._itemWidth = Helper.clamp(2, 50, WIDTH);
            this.prepareData();
        } else {
            this.itemWidth.set(WIDTH);
        }
    }

    public IntegerProperty itemWidthProperty() {
        if (null == this.itemWidth) {
            this.itemWidth = new IntegerPropertyBase(this._itemWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(2, 50, this.get()));
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "itemWidth";
                }
            };
        }
        return this.itemWidth;
    }

    public boolean isAutoItemWidth() {
        return null == this.autoItemWidth ? this._autoItemWidth : this.autoItemWidth.get();
    }

    public void setAutoItemWidth(boolean AUTO) {
        if (null == this.autoItemWidth) {
            this._autoItemWidth = AUTO;
            this.prepareData();
        } else {
            this.autoItemWidth.set(AUTO);
        }
    }

    public BooleanProperty autoItemWidthProperty() {
        if (null == this.autoItemWidth) {
            this.autoItemWidth = new BooleanPropertyBase(this._autoItemWidth){

                protected void invalidated() {
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "autoItemWidth";
                }
            };
        }
        return this.autoItemWidth;
    }

    public int getItemGap() {
        return null == this.itemGap ? this._itemGap : this.itemGap.get();
    }

    public void setItemGap(int GAP) {
        if (null == this.itemGap) {
            this._itemGap = Helper.clamp(0, 100, GAP);
            this.prepareData();
        } else {
            this.itemGap.set(GAP);
        }
    }

    public IntegerProperty itemGapProperty() {
        if (null == this.itemGap) {
            this.itemGap = new IntegerPropertyBase(this._itemGap){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 100, this.get()));
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "itemGap";
                }
            };
        }
        return this.itemGap;
    }

    public boolean isAutoItemGap() {
        return null == this.autoItemGap ? this._autoItemGap : this.autoItemGap.get();
    }

    public void setAutoItemGap(boolean AUTO) {
        if (null == this.autoItemGap) {
            this._autoItemGap = AUTO;
            this.prepareData();
        } else {
            this.autoItemGap.set(AUTO);
        }
    }

    public BooleanProperty autoItemGapProperty() {
        if (null == this.autoItemGap) {
            this.autoItemGap = new BooleanPropertyBase(this._autoItemGap){

                protected void invalidated() {
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "autoItemGap";
                }
            };
        }
        return this.autoItemGap;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    SankeyPlot.this.formatString = "%." + this.get() + "f";
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean getShowFlowDirection() {
        return null == this.showFlowDirection ? this._showFlowDirection : this.showFlowDirection.get();
    }

    public void setShowFlowDirection(boolean SHOW) {
        if (null == this.showFlowDirection) {
            this._showFlowDirection = SHOW;
            this.redraw();
        } else {
            this.showFlowDirection.set(SHOW);
        }
    }

    public BooleanProperty showFlowDirectionProperty() {
        if (null == this.showFlowDirection) {
            this.showFlowDirection = new BooleanPropertyBase(this._showFlowDirection){

                protected void invalidated() {
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "showFlowDirection";
                }
            };
        }
        return this.showFlowDirection;
    }

    public boolean getUseItemColor() {
        return null == this.useItemColor ? this._useItemColor : this.useItemColor.get();
    }

    public void setUseItemColor(boolean USE) {
        if (null == this.useItemColor) {
            this._useItemColor = USE;
            this.redraw();
        } else {
            this.useItemColor.set(USE);
        }
    }

    public BooleanProperty useItemColorProperty() {
        if (null == this.useItemColor) {
            this.useItemColor = new BooleanPropertyBase(this._useItemColor){

                protected void invalidated() {
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "useItemColor";
                }
            };
        }
        return this.useItemColor;
    }

    public Color getItemColor() {
        return null == this.itemColor ? this._itemColor : (Color)this.itemColor.get();
    }

    public void setItemColor(Color COLOR) {
        if (null == this.itemColor) {
            this._itemColor = COLOR;
            this.redraw();
        } else {
            this.itemColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> itemColorProperty() {
        if (null == this.itemColor) {
            this.itemColor = new ObjectPropertyBase<Color>(this._itemColor){

                protected void invalidated() {
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "itemColor";
                }
            };
        }
        return this.itemColor;
    }

    public double getConnectionOpacity() {
        return null == this.connectionOpacity ? this._connectionOpacity : this.connectionOpacity.get();
    }

    public void setConnectionOpacity(double OPACITY) {
        if (null == this.connectionOpacity) {
            this._connectionOpacity = Helper.clamp(0.1, 1.0, OPACITY);
            this.redraw();
        } else {
            this.connectionOpacity.set(OPACITY);
        }
    }

    public DoubleProperty connectionOpacityProperty() {
        if (null == this.connectionOpacity) {
            this.connectionOpacity = new DoublePropertyBase(this._connectionOpacity){

                protected void invalidated() {
                    this.set(Helper.clamp(0.1, 1.0, this.get()));
                    SankeyPlot.this.redraw();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "connectionOpacity";
                }
            };
        }
        return this.connectionOpacity;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
            this.prepareData();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    SankeyPlot.this.prepareData();
                }

                public Object getBean() {
                    return SankeyPlot.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public List<PlotItem> getItemsWithOnlyOutgoing() {
        return this.getItems().stream().filter(item -> item.hasOutgoing() && !item.hasIncoming()).collect(Collectors.toList());
    }

    public List<PlotItem> getItemsWithOnlyIncoming() {
        return this.getItems().stream().filter(item -> !item.hasOutgoing() && item.hasIncoming()).collect(Collectors.toList());
    }

    public List<PlotItem> getItemsWithInAndOutgoing() {
        return this.getItems().stream().filter(PlotItem::hasOutgoing).filter(PlotItem::hasIncoming).collect(Collectors.toList());
    }

    private void sortIncomingByOutgoingOrder(List<PlotItem> INCOMING, List<PlotItem> OUTGOING) {
        Collections.sort(INCOMING, Comparator.comparing(item -> OUTGOING.indexOf(item)));
    }

    private void sortOutgoingByNextLevelIncomingOrder(List<PlotItem> OUTGOING, List<PlotItem> INCOMING) {
        Collections.sort(OUTGOING, Comparator.comparing(item -> INCOMING.indexOf(item)));
    }

    private double getSumFromDataItems(List<PlotItemData> DATA_ITEMS) {
        return DATA_ITEMS.stream().map(plotItemData -> plotItemData.getPlotItem()).mapToDouble(PlotItem::getMaxSum).sum();
    }

    private void prepareData() {
        this.itemsPerLevel.clear();
        this.items.forEach(item -> {
            int level = item.getLevel();
            if (this.itemsPerLevel.keySet().contains(level)) {
                this.itemsPerLevel.get(level).add(new PlotItemData((PlotItem)item));
            } else {
                this.itemsPerLevel.put(level, new ArrayList());
                this.itemsPerLevel.get(level).add(new PlotItemData((PlotItem)item));
            }
        });
        this.minLevel = this.itemsPerLevel.keySet().stream().mapToInt(Integer::intValue).min().getAsInt();
        this.maxLevel = this.itemsPerLevel.keySet().stream().mapToInt(Integer::intValue).max().getAsInt();
        List<PlotItemData> minLevelItems = this.itemsPerLevel.get(this.minLevel);
        LinkedHashMap<PlotItemData, Integer> itemsToMove = new LinkedHashMap<PlotItemData, Integer>();
        for (PlotItemData plotItemData2 : minLevelItems) {
            int minLevelOfOutgoingItems = this.maxLevel;
            int maxLevelOfOutgoingItems = this.minLevel;
            for (PlotItem plotItem : plotItemData2.getPlotItem().getOutgoing().keySet()) {
                int levelOfItem = plotItem.getLevel();
                minLevelOfOutgoingItems = Math.min(minLevelOfOutgoingItems, levelOfItem);
                maxLevelOfOutgoingItems = Math.max(maxLevelOfOutgoingItems, levelOfItem);
            }
            if (minLevelOfOutgoingItems <= this.minLevel + 1) continue;
            itemsToMove.put(plotItemData2, minLevelOfOutgoingItems - 1);
        }
        itemsToMove.forEach((itemData, newLevel) -> {
            minLevelItems.remove(itemData);
            this.itemsPerLevel.get(newLevel).add(0, (PlotItemData)itemData);
        });
        this.itemsPerLevel.forEach((level, items) -> Collections.reverse(items));
        for (int level2 = this.minLevel; level2 <= this.maxLevel; ++level2) {
            List<PlotItemData> itemData2 = this.itemsPerLevel.get(level2);
            if (level2 < this.maxLevel) {
                List nextLevelItems = this.itemsPerLevel.get(level2 + 1).stream().map(plotItemData -> plotItemData.getPlotItem()).collect(Collectors.toList());
                itemData2.forEach(id -> id.getPlotItem().sortOutgoingByGivenList(nextLevelItems));
            }
            if (level2 <= this.minLevel) continue;
            List formerLevelItems = this.itemsPerLevel.get(level2 - 1).stream().map(plotItemData -> plotItemData.getPlotItem()).collect(Collectors.toList());
            itemData2.forEach(id -> id.getPlotItem().sortIncomingByGivenList(formerLevelItems));
        }
        int maxNoOfItemsAtLevel = 0;
        double maxSumOfItemsAtLevel = 0.0;
        for (int i = this.minLevel; i <= this.maxLevel; ++i) {
            List<PlotItemData> items2 = this.itemsPerLevel.get(i);
            maxNoOfItemsAtLevel = Math.max(maxNoOfItemsAtLevel, items2.size());
            maxSumOfItemsAtLevel = Math.max(maxSumOfItemsAtLevel, this.getSumFromDataItems(items2));
        }
        double itemWidth = this.isAutoItemWidth() ? this.size * 0.025 : (double)this.getItemWidth();
        double verticalGap = this.isAutoItemGap() ? this.size * 0.025 : (double)this.getItemGap();
        double textGap = this.size * 0.0125;
        double maxSum = maxSumOfItemsAtLevel;
        int maxItems = maxNoOfItemsAtLevel;
        double horizontalGap = (this.width - itemWidth) / (double)this.maxLevel;
        this.scaleY = (this.height - (double)(maxItems - 1) * verticalGap) / maxSum;
        for (int level3 = this.minLevel; level3 <= this.maxLevel; ++level3) {
            double spacerY = 0.0;
            double spacerX = horizontalGap * (double)level3;
            for (PlotItemData itemData3 : this.itemsPerLevel.get(level3)) {
                PlotItem item2 = itemData3.getPlotItem();
                double itemHeight = item2.getMaxSum() * this.scaleY;
                double textOffsetX = level3 < this.maxLevel ? textGap + itemWidth : -textGap;
                itemData3.setBounds(spacerX, this.height - itemHeight - spacerY, itemWidth, itemHeight);
                itemData3.setTextPoint(spacerX + textOffsetX, this.height - itemHeight * 0.5 - spacerY);
                spacerY += itemHeight + verticalGap;
            }
        }
        this.createPaths();
        this.redraw();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setFont(Font.font((double)Helper.clamp(8.0, 24.0, this.size * 0.025)));
            this.prepareData();
        }
    }

    private void createPaths() {
        this.paths.clear();
        boolean showFlowDirection = this.getShowFlowDirection();
        double showDirectionOffsetX = this.size * 0.01875;
        double connectionOpacity = this.getConnectionOpacity();
        for (int level = this.minLevel; level <= this.maxLevel; ++level) {
            List<PlotItemData> itemDataInLevel = this.itemsPerLevel.get(level);
            int nextLevel = level + 1;
            for (PlotItemData itemData : itemDataInLevel) {
                PlotItem item = itemData.getPlotItem();
                CtxBounds bounds = itemData.getBounds();
                if (level >= this.maxLevel) continue;
                List<PlotItemData> nextLevelItemDataList = this.itemsPerLevel.get(nextLevel);
                for (PlotItem outgoingItem : item.getOutgoing().keySet()) {
                    Optional<PlotItemData> targetItemDataOptional = nextLevelItemDataList.stream().filter(id -> id.getPlotItem().equals(outgoingItem)).findFirst();
                    if (!targetItemDataOptional.isPresent()) continue;
                    PlotItemData targetItemData = targetItemDataOptional.get();
                    CtxBounds targetItemBounds = targetItemData.getBounds();
                    PlotItem targetItem = targetItemData.getPlotItem();
                    double targetIncomingOffsetY = 0.0;
                    for (PlotItem incomingItem : targetItem.getIncoming().keySet()) {
                        if (incomingItem.equals(item)) break;
                        targetIncomingOffsetY += targetItem.getIncoming().get(incomingItem) * this.scaleY;
                    }
                    double ctrlPointOffsetX = (targetItemBounds.getMinX() - bounds.getMaxX()) * 0.25;
                    double outgoingValue = item.getOutgoing().get(outgoingItem);
                    double scaledValueY = outgoingValue * this.scaleY;
                    Path path = new Path();
                    if (StreamFillMode.COLOR == this.getStreamFillMode()) {
                        path.setFill((Paint)this.getStreamColor());
                    } else {
                        path.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Helper.getColorWithOpacity(item.getFill(), connectionOpacity)), new Stop(1.0, Helper.getColorWithOpacity(outgoingItem.getFill(), connectionOpacity))}));
                    }
                    path.moveTo(bounds.getMaxX(), bounds.getMinY() + itemData.getOutgoingOffsetY());
                    if (showFlowDirection) {
                        path.bezierCurveTo(bounds.getMaxX() + ctrlPointOffsetX, bounds.getMinY() + itemData.getOutgoingOffsetY(), targetItemBounds.getMinX() - ctrlPointOffsetX, targetItemBounds.getMinY() + targetIncomingOffsetY, targetItemBounds.getMinX() - showDirectionOffsetX, targetItemBounds.getMinY() + targetIncomingOffsetY);
                        path.lineTo(targetItemBounds.getMinX(), targetItemBounds.getMinY() + targetIncomingOffsetY + scaledValueY * 0.5);
                        path.lineTo(targetItemBounds.getMinX() - showDirectionOffsetX, targetItemBounds.getMinY() + targetIncomingOffsetY + scaledValueY);
                    } else {
                        path.bezierCurveTo(bounds.getMaxX() + ctrlPointOffsetX, bounds.getMinY() + itemData.getOutgoingOffsetY(), targetItemBounds.getMinX() - ctrlPointOffsetX, targetItemBounds.getMinY() + targetIncomingOffsetY, targetItemBounds.getMinX(), targetItemBounds.getMinY() + targetIncomingOffsetY);
                        path.lineTo(targetItemBounds.getMinX(), targetItemBounds.getMinY() + targetIncomingOffsetY + scaledValueY);
                    }
                    itemData.addToOutgoingOffset(scaledValueY);
                    targetItemData.addToIncomingOffset(scaledValueY);
                    path.bezierCurveTo(targetItemBounds.getMinX() - ctrlPointOffsetX, targetItemBounds.getMinY() + targetIncomingOffsetY + scaledValueY, bounds.getMaxX() + ctrlPointOffsetX, bounds.getMinY() + itemData.getOutgoingOffsetY(), bounds.getMaxX(), bounds.getMinY() + itemData.getOutgoingOffsetY());
                    path.lineTo(bounds.getMaxX(), bounds.getMinY() + itemData.getOutgoingOffsetY());
                    path.closePath();
                    String tooltipText = item.getName() + " -> " + targetItem.getName() + " " + String.format(this.getLocale(), this.formatString, outgoingValue);
                    this.paths.put(path, tooltipText);
                }
            }
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.paths.forEach((path, plotItem) -> path.draw(this.ctx, true, false));
        boolean useItemColor = this.getUseItemColor();
        Color itemColor = this.getItemColor();
        Color textColor = this.getTextColor();
        for (int level = this.minLevel; level <= this.maxLevel; ++level) {
            List<PlotItemData> itemDataInLevel = this.itemsPerLevel.get(level);
            for (PlotItemData itemData : itemDataInLevel) {
                PlotItem item = itemData.getPlotItem();
                CtxBounds bounds = itemData.getBounds();
                this.ctx.setFill((Paint)(useItemColor ? item.getFill() : itemColor));
                this.ctx.fillRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                this.ctx.setFill((Paint)textColor);
                this.ctx.setTextAlign(level == this.maxLevel ? TextAlignment.RIGHT : TextAlignment.LEFT);
                this.ctx.fillText(item.getName(), itemData.getTextPoint().getX(), itemData.getTextPoint().getY());
            }
        }
    }

    private class PlotItemData {
        private PlotItem plotItem;
        private CtxBounds bounds;
        private Point textPoint;
        private double incomingOffsetY;
        private double outgoingOffsetY;
        private double value;

        public PlotItemData(PlotItem ITEM) {
            this.plotItem = ITEM;
            this.bounds = new CtxBounds();
            this.textPoint = new Point();
            this.incomingOffsetY = 0.0;
            this.outgoingOffsetY = 0.0;
            this.value = 0.0;
        }

        public PlotItem getPlotItem() {
            return this.plotItem;
        }

        public CtxBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(double X, double Y, double WIDTH, double HEIGHT) {
            this.bounds.set(X, Y, WIDTH, HEIGHT);
        }

        public Point getTextPoint() {
            return this.textPoint;
        }

        public void setTextPoint(double X, double Y) {
            this.textPoint.set(X, Y);
        }

        public double getIncomingOffsetY() {
            return this.incomingOffsetY;
        }

        public void setIncomingOffsetY(double OFFSET) {
            this.incomingOffsetY = OFFSET;
        }

        public void addToIncomingOffset(double ADD) {
            this.incomingOffsetY += ADD;
        }

        public void resetIncomingOffset() {
            this.incomingOffsetY = 0.0;
        }

        public double getOutgoingOffsetY() {
            return this.outgoingOffsetY;
        }

        public void setOutgoingOffsetY(double OFFSET) {
            this.outgoingOffsetY = OFFSET;
        }

        public void addToOutgoingOffset(double ADD) {
            this.outgoingOffsetY += ADD;
        }

        public void resetOutgoingOffset() {
            this.outgoingOffsetY = 0.0;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double VALUE) {
            this.value = VALUE;
        }
    }

    public static enum StreamFillMode {
        COLOR,
        GRADIENT;

    }
}

