/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.CtxDimension;
import eu.hansolo.fx.charts.tools.Helper;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class LegendItem
extends Region {
    private static final double PREFERRED_WIDTH = 100.0;
    private static final double PREFERRED_HEIGHT = 18.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 8.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private String _text;
    private StringProperty text;
    private Color _symbolFill;
    private ObjectProperty<Color> symbolFill;
    private Color _symbolStroke;
    private ObjectProperty<Color> symbolStroke;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private double symbolSize;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Font font;
    private CtxDimension textDim;
    private Pane pane;

    public LegendItem(String TEXT, Color SYMBOL_COLOR) {
        this(Symbol.CIRCLE, TEXT, SYMBOL_COLOR, Color.WHITE, Color.BLACK);
    }

    public LegendItem(Symbol SYMBOL, String TEXT, Color SYMBOL_FILL) {
        this(SYMBOL, TEXT, SYMBOL_FILL, Color.WHITE, Color.BLACK);
    }

    public LegendItem(Symbol SYMBOL, String TEXT, Color SYMBOL_FILL, Color SYMBOL_STROKE) {
        this(SYMBOL, TEXT, SYMBOL_FILL, SYMBOL_STROKE, Color.BLACK);
    }

    public LegendItem(Symbol SYMBOL, String TEXT, Color SYMBOL_FILL, Color SYMBOL_STROKE, Color TEXT_COLOR) {
        this._symbol = SYMBOL;
        this._text = TEXT;
        this._symbolFill = SYMBOL_FILL;
        this._symbolStroke = SYMBOL_STROKE;
        this._textColor = TEXT_COLOR;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(100.0, 18.0);
            }
        }
        this.canvas = new Canvas(18.0, 18.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setTextAlign(TextAlignment.LEFT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 20.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 8.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        if ("".equals(PROPERTY)) {
            // empty if block
        }
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.redraw();
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    LegendItem.this.redraw();
                }

                public Object getBean() {
                    return LegendItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
            this.resize();
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new StringPropertyBase(this._text){

                protected void invalidated() {
                    LegendItem.this.resize();
                }

                public Object getBean() {
                    return LegendItem.this;
                }

                public String getName() {
                    return "text";
                }
            };
            this._text = null;
        }
        return this.text;
    }

    public Color getSymbolFill() {
        return null == this.symbolFill ? this._symbolFill : (Color)this.symbolFill.get();
    }

    public void setSymbolFill(Color COLOR) {
        if (null == this.symbolFill) {
            this._symbolFill = COLOR;
            this.redraw();
        } else {
            this.symbolFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolFillProperty() {
        if (null == this.symbolFill) {
            this.symbolFill = new ObjectPropertyBase<Color>(this._symbolFill){

                protected void invalidated() {
                    LegendItem.this.redraw();
                }

                public Object getBean() {
                    return LegendItem.this;
                }

                public String getName() {
                    return "symbolFill";
                }
            };
            this._symbolFill = null;
        }
        return this.symbolFill;
    }

    public Color getSymbolStroke() {
        return null == this.symbolStroke ? this._symbolStroke : (Color)this.symbolStroke.get();
    }

    public void setSymbolStroke(Color COLOR) {
        if (null == this.symbolStroke) {
            this._symbolStroke = COLOR;
            this.redraw();
        } else {
            this.symbolStroke.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolStrokeProperty() {
        if (null == this.symbolStroke) {
            this.symbolStroke = new ObjectPropertyBase<Color>(this._symbolStroke){

                protected void invalidated() {
                    LegendItem.this.redraw();
                }

                public Object getBean() {
                    return LegendItem.this;
                }

                public String getName() {
                    return "symbolStroke";
                }
            };
            this._symbolStroke = null;
        }
        return this.symbolStroke;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    LegendItem.this.redraw();
                }

                public Object getBean() {
                    return LegendItem.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.font = Fonts.latoRegular(this.size * 0.8);
            this.textDim = Helper.getTextDimension(this.getText(), this.font);
            double requiredWidth = this.height + this.height * 0.22 + this.textDim.getWidth();
            this.pane.setMaxSize(requiredWidth, this.height);
            this.pane.setPrefSize(requiredWidth, this.height);
            this.pane.relocate((this.getWidth() - requiredWidth) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(requiredWidth);
            this.canvas.setHeight(this.height);
            this.symbolSize = this.height * 0.8;
            this.redraw();
            this.setMaxWidth(requiredWidth);
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.drawSymbol(this.height * 0.5, this.height * 0.5, (Paint)this.getSymbolFill(), (Paint)this.getSymbolStroke(), this.getSymbol());
        this.ctx.setFill((Paint)this.getTextColor());
        this.ctx.setFont(this.font);
        this.ctx.fillText(this.getText(), this.height + this.height * 0.22, this.height * 0.5);
    }

    private void drawSymbol(double X, double Y, Paint FILL, Paint STROKE, Symbol SYMBOL) {
        double halfSymbolSize = this.symbolSize * 0.5;
        this.ctx.save();
        switch (SYMBOL) {
            case NONE: {
                break;
            }
            case SQUARE: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.fillRect(X - halfSymbolSize, Y - halfSymbolSize, this.symbolSize, this.symbolSize);
                this.ctx.strokeRect(X - halfSymbolSize, Y - halfSymbolSize, this.symbolSize, this.symbolSize);
                break;
            }
            case TRIANGLE: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.beginPath();
                this.ctx.moveTo(X, Y - halfSymbolSize);
                this.ctx.lineTo(X + halfSymbolSize, Y + halfSymbolSize);
                this.ctx.lineTo(X - halfSymbolSize, Y + halfSymbolSize);
                this.ctx.lineTo(X, Y - halfSymbolSize);
                this.ctx.closePath();
                this.ctx.fill();
                this.ctx.stroke();
                break;
            }
            case STAR: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(null);
                this.ctx.strokeLine(X - halfSymbolSize, Y, X + halfSymbolSize, Y);
                this.ctx.strokeLine(X, Y - halfSymbolSize, X, Y + halfSymbolSize);
                this.ctx.strokeLine(X - halfSymbolSize, Y - halfSymbolSize, X + halfSymbolSize, Y + halfSymbolSize);
                this.ctx.strokeLine(X + halfSymbolSize, Y - halfSymbolSize, X - halfSymbolSize, Y + halfSymbolSize);
                break;
            }
            case CROSS: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(null);
                this.ctx.strokeLine(X - halfSymbolSize, Y, X + halfSymbolSize, Y);
                this.ctx.strokeLine(X, Y - halfSymbolSize, X, Y + halfSymbolSize);
                break;
            }
            default: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.fillOval(X - halfSymbolSize, Y - halfSymbolSize, this.symbolSize, this.symbolSize);
                this.ctx.strokeOval(X - halfSymbolSize, Y - halfSymbolSize, this.symbolSize, this.symbolSize);
            }
        }
        this.ctx.restore();
    }
}

