/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.CircularPlot;
import eu.hansolo.fx.charts.data.PlotItem;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class CircularPlotBuilder<B extends CircularPlotBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CircularPlotBuilder() {
    }

    public static final CircularPlotBuilder create() {
        return new CircularPlotBuilder();
    }

    public final B items(PlotItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<PlotItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B segmentGap(double GAP) {
        this.properties.put("segmentGap", (Property)new SimpleDoubleProperty(GAP));
        return (B)this;
    }

    public final B showFlowDirection(boolean SHOW) {
        this.properties.put("showFlowDirection", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B minorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumTickMarksVisible(boolean VISIBLE) {
        this.properties.put("mediumTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("majorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B tickLabelsVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B onlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        this.properties.put("onlyFirstAndLastTickLabelVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B connectionOpacity(double OPACITY) {
        this.properties.put("connectionOpacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CircularPlot build() {
        CircularPlot CONTROL = new CircularPlot();
        if (this.properties.keySet().contains("itemsArray")) {
            CONTROL.setItems((PlotItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            CONTROL.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarkColor".equals(key)) {
                CONTROL.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                CONTROL.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("segmentGap".equals(key)) {
                CONTROL.setSegmentGap(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showFlowDirection".equals(key)) {
                CONTROL.setShowFlowDirection(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickMarksVisible".equals(key)) {
                CONTROL.setMinorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mediumTickMarksVisible".equals(key)) {
                CONTROL.setMediumTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickMarksVisible".equals(key)) {
                CONTROL.setMajorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelsVisible".equals(key)) {
                CONTROL.setTickLabelsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onlyFirstAndLastTickLabelVisible".equals(key)) {
                CONTROL.setOnlyFirstAndLastTickLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"connectionOpactiy".equals(key)) continue;
            CONTROL.setConnectionOpacity(((DoubleProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

