/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.rrapi.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.rrapi.request.RequestBody;
import io.github.dsheirer.rrapi.request.RequestEnvelope;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.rrapi.type.StateRequestItem;
import java.util.ArrayList;
import java.util.List;

public class GetStatesByList
extends RequestBody {
    private List<StateRequestItem> mStateIdItems = new ArrayList<StateRequestItem>();

    public GetStatesByList(AuthorizationInformation authorizationInformation) {
        super(authorizationInformation);
    }

    @JacksonXmlElementWrapper(localName="request")
    @JacksonXmlProperty(localName="item")
    public List<StateRequestItem> getStateIdItems() {
        return this.mStateIdItems;
    }

    public void setStateIdItems(List<StateRequestItem> stateIdItems) {
        this.mStateIdItems = stateIdItems;
    }

    public void addState(int stateId) {
        this.mStateIdItems.add(StateRequestItem.create(stateId));
    }

    public static RequestEnvelope create(AuthorizationInformation authorizationInformation, int ... stateIds) {
        GetStatesByList body = new GetStatesByList(authorizationInformation);
        for (int stateId : stateIds) {
            body.addState(stateId);
        }
        return RequestEnvelope.create(body);
    }

    public static RequestEnvelope create(AuthorizationInformation authorizationInformation, List<Integer> stateIds) {
        GetStatesByList body = new GetStatesByList(authorizationInformation);
        for (int stateId : stateIds) {
            body.addState(stateId);
        }
        return RequestEnvelope.create(body);
    }
}

