/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.rrapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.request.FccGetCallsign;
import io.github.dsheirer.rrapi.request.FccGetProximityCallsigns;
import io.github.dsheirer.rrapi.request.FccGetRadioServiceCode;
import io.github.dsheirer.rrapi.request.GetAgencyInfo;
import io.github.dsheirer.rrapi.request.GetApco25Systems;
import io.github.dsheirer.rrapi.request.GetCountryInfo;
import io.github.dsheirer.rrapi.request.GetCountryList;
import io.github.dsheirer.rrapi.request.GetCountyFrequenciesByTag;
import io.github.dsheirer.rrapi.request.GetCountyInfo;
import io.github.dsheirer.rrapi.request.GetFlavors;
import io.github.dsheirer.rrapi.request.GetMetroInfo;
import io.github.dsheirer.rrapi.request.GetMetros;
import io.github.dsheirer.rrapi.request.GetModes;
import io.github.dsheirer.rrapi.request.GetSites;
import io.github.dsheirer.rrapi.request.GetStateInfo;
import io.github.dsheirer.rrapi.request.GetStatesByList;
import io.github.dsheirer.rrapi.request.GetSubCategoryFrequenciesRequest;
import io.github.dsheirer.rrapi.request.GetSystemInformation;
import io.github.dsheirer.rrapi.request.GetTags;
import io.github.dsheirer.rrapi.request.GetTalkgroupCategories;
import io.github.dsheirer.rrapi.request.GetTalkgroups;
import io.github.dsheirer.rrapi.request.GetTypes;
import io.github.dsheirer.rrapi.request.GetUserData;
import io.github.dsheirer.rrapi.request.GetUserFeedBroadcasts;
import io.github.dsheirer.rrapi.request.GetVoices;
import io.github.dsheirer.rrapi.request.GetZipcodeInfo;
import io.github.dsheirer.rrapi.request.RequestEnvelope;
import io.github.dsheirer.rrapi.request.SearchCountyFrequency;
import io.github.dsheirer.rrapi.request.SearchMetroFrequency;
import io.github.dsheirer.rrapi.request.SearchStateFrequency;
import io.github.dsheirer.rrapi.response.Fault;
import io.github.dsheirer.rrapi.response.FccGetCallsignResponse;
import io.github.dsheirer.rrapi.response.FccGetProximityCallsignResponse;
import io.github.dsheirer.rrapi.response.FccGetRadioServiceCodeResponse;
import io.github.dsheirer.rrapi.response.FrequenciesResponse;
import io.github.dsheirer.rrapi.response.GetAgencyInfoResponse;
import io.github.dsheirer.rrapi.response.GetApco25SystemsResponse;
import io.github.dsheirer.rrapi.response.GetCountryInfoResponse;
import io.github.dsheirer.rrapi.response.GetCountryListResponse;
import io.github.dsheirer.rrapi.response.GetCountyInfoResponse;
import io.github.dsheirer.rrapi.response.GetFlavorsResponse;
import io.github.dsheirer.rrapi.response.GetMetroInfoResponse;
import io.github.dsheirer.rrapi.response.GetMetrosResponse;
import io.github.dsheirer.rrapi.response.GetModesResponse;
import io.github.dsheirer.rrapi.response.GetSitesResponse;
import io.github.dsheirer.rrapi.response.GetStateInfoResponse;
import io.github.dsheirer.rrapi.response.GetStatesByListResponse;
import io.github.dsheirer.rrapi.response.GetSubCategoryFrequenciesResponse;
import io.github.dsheirer.rrapi.response.GetSystemInformationResponse;
import io.github.dsheirer.rrapi.response.GetTagsResponse;
import io.github.dsheirer.rrapi.response.GetTalkgroupCategoriesResponse;
import io.github.dsheirer.rrapi.response.GetTalkgroupsResponse;
import io.github.dsheirer.rrapi.response.GetTypesResponse;
import io.github.dsheirer.rrapi.response.GetUserDataResponse;
import io.github.dsheirer.rrapi.response.GetUserFeedBroadcastsResponse;
import io.github.dsheirer.rrapi.response.GetVoicesResponse;
import io.github.dsheirer.rrapi.response.GetZipcodeInfoResponse;
import io.github.dsheirer.rrapi.response.ResponseEnvelope;
import io.github.dsheirer.rrapi.response.SearchFrequencyResponse;
import io.github.dsheirer.rrapi.type.Agency;
import io.github.dsheirer.rrapi.type.AgencyInfo;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.rrapi.type.Country;
import io.github.dsheirer.rrapi.type.CountryInfo;
import io.github.dsheirer.rrapi.type.County;
import io.github.dsheirer.rrapi.type.CountyInfo;
import io.github.dsheirer.rrapi.type.FccCallsignDetails;
import io.github.dsheirer.rrapi.type.FccRadioServiceCode;
import io.github.dsheirer.rrapi.type.Flavor;
import io.github.dsheirer.rrapi.type.Frequency;
import io.github.dsheirer.rrapi.type.Metro;
import io.github.dsheirer.rrapi.type.Mode;
import io.github.dsheirer.rrapi.type.ProximityCallsignResult;
import io.github.dsheirer.rrapi.type.SearchFrequencyResult;
import io.github.dsheirer.rrapi.type.Site;
import io.github.dsheirer.rrapi.type.State;
import io.github.dsheirer.rrapi.type.StateInfo;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.rrapi.type.Tag;
import io.github.dsheirer.rrapi.type.Talkgroup;
import io.github.dsheirer.rrapi.type.TalkgroupCategory;
import io.github.dsheirer.rrapi.type.TalkgroupRequestFilter;
import io.github.dsheirer.rrapi.type.Type;
import io.github.dsheirer.rrapi.type.UserFeedBroadcast;
import io.github.dsheirer.rrapi.type.UserInfo;
import io.github.dsheirer.rrapi.type.Voice;
import io.github.dsheirer.rrapi.type.ZipInfo;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioReferenceService {
    private static final Logger mLog = LoggerFactory.getLogger(RadioReferenceService.class);
    public static final String API_VERSION_15 = "15";
    private static final String RADIO_REFERENCE_API_URL = "http://api.radioreference.com/soap2/";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String XML_CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_RRAPI = "io.github.dsheirer.rrapi";
    private HttpClient mHttpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private AuthorizationInformation mAuthorizationInformation;
    private Map<Integer, Flavor> mFlavorMap;
    private Map<Integer, Metro> mMetroMap;
    private Map<Integer, List<County>> mMetroCountiesMap;
    private Map<Integer, Mode> mModeMap;
    private Map<Integer, Tag> mTagMap;
    private Map<Integer, Type> mTypeMap;
    private Map<Integer, Voice> mVoiceMap;

    public RadioReferenceService(AuthorizationInformation authorizationInformation) throws RadioReferenceException {
        if (authorizationInformation == null) {
            throw new RadioReferenceException("Authorization information cannot be null");
        }
        this.mAuthorizationInformation = authorizationInformation;
    }

    public UserInfo getUserInfo() throws RadioReferenceException {
        RequestEnvelope request = GetUserData.create(this.mAuthorizationInformation);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetUserDataResponse) {
            return ((GetUserDataResponse)response.getResponseBody()).getUserInfo();
        }
        return null;
    }

    public List<UserFeedBroadcast> getUserFeeds() throws RadioReferenceException {
        RequestEnvelope request = GetUserFeedBroadcasts.create(this.mAuthorizationInformation);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetUserFeedBroadcastsResponse) {
            return ((GetUserFeedBroadcastsResponse)response.getResponseBody()).getUserFeedBroadcasts();
        }
        return Collections.emptyList();
    }

    public List<Country> getCountries() throws RadioReferenceException {
        RequestEnvelope request = GetCountryList.create(this.mAuthorizationInformation);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetCountryListResponse) {
            return ((GetCountryListResponse)response.getResponseBody()).getCountries();
        }
        return Collections.emptyList();
    }

    public CountryInfo getCountryInfo(Country country) throws RadioReferenceException {
        return this.getCountryInfo(country.getCountryId());
    }

    public CountryInfo getCountryInfo(int countryId) throws RadioReferenceException {
        RequestEnvelope request = GetCountryInfo.create(this.mAuthorizationInformation, countryId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetCountryInfoResponse) {
            return ((GetCountryInfoResponse)response.getResponseBody()).getCountryInfo();
        }
        return null;
    }

    public AgencyInfo getAgencyInfo(Agency agency) throws RadioReferenceException {
        return this.getAgencyInfo(agency.getAgencyId());
    }

    public AgencyInfo getAgencyInfo(int agencyId) throws RadioReferenceException {
        RequestEnvelope request = GetAgencyInfo.create(this.mAuthorizationInformation, agencyId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetAgencyInfoResponse) {
            return ((GetAgencyInfoResponse)response.getResponseBody()).getAgencyInfo();
        }
        return null;
    }

    public State getState(int stateId) throws RadioReferenceException {
        List<State> states;
        RequestEnvelope request = GetStatesByList.create(this.mAuthorizationInformation, stateId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetStatesByListResponse && (states = ((GetStatesByListResponse)response.getResponseBody()).getStates()).size() == 1) {
            return states.get(0);
        }
        return null;
    }

    public StateInfo getStateInfo(int stateId) throws RadioReferenceException {
        RequestEnvelope request = GetStateInfo.create(this.mAuthorizationInformation, stateId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetStateInfoResponse) {
            return ((GetStateInfoResponse)response.getResponseBody()).getStateInfo();
        }
        return null;
    }

    public List<State> getStates(List<Integer> stateIds) throws RadioReferenceException {
        RequestEnvelope request = GetStatesByList.create(this.mAuthorizationInformation, stateIds);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetStatesByListResponse) {
            return ((GetStatesByListResponse)response.getResponseBody()).getStates();
        }
        return Collections.emptyList();
    }

    public CountyInfo getCountyInfo(int countyId) throws RadioReferenceException {
        RequestEnvelope request = GetCountyInfo.create(this.mAuthorizationInformation, countyId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetCountyInfoResponse) {
            return ((GetCountyInfoResponse)response.getResponseBody()).getCountyInfo();
        }
        return null;
    }

    public List<Frequency> getCountyFrequenciesByTag(int countyId, int tagId) throws RadioReferenceException {
        RequestEnvelope request = GetCountyFrequenciesByTag.create(this.mAuthorizationInformation, countyId, tagId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FrequenciesResponse) {
            return ((FrequenciesResponse)response.getResponseBody()).getFrequencies();
        }
        return Collections.emptyList();
    }

    public List<Frequency> getAgencyFrequenciesByTag(int agencyId, int tagId) throws RadioReferenceException {
        RequestEnvelope request = GetCountyFrequenciesByTag.create(this.mAuthorizationInformation, agencyId, tagId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FrequenciesResponse) {
            return ((FrequenciesResponse)response.getResponseBody()).getFrequencies();
        }
        return Collections.emptyList();
    }

    public SystemInformation getSystemInformation(int systemId) throws RadioReferenceException {
        RequestEnvelope request = GetSystemInformation.create(this.mAuthorizationInformation, systemId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetSystemInformationResponse) {
            return ((GetSystemInformationResponse)response.getResponseBody()).getSystemInformation();
        }
        return null;
    }

    public List<System> getApco25Systems(String systemId) throws RadioReferenceException {
        RequestEnvelope request = GetApco25Systems.create(this.mAuthorizationInformation, systemId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetApco25SystemsResponse) {
            return ((GetApco25SystemsResponse)response.getResponseBody()).getSystems();
        }
        return null;
    }

    public List<Site> getSites(int systemId) throws RadioReferenceException {
        RequestEnvelope request = GetSites.create(this.mAuthorizationInformation, systemId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetSitesResponse) {
            return ((GetSitesResponse)response.getResponseBody()).getSites();
        }
        return null;
    }

    public List<Talkgroup> getTalkgroups(int systemId) throws RadioReferenceException {
        RequestEnvelope request = GetTalkgroups.create(this.mAuthorizationInformation, systemId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetTalkgroupsResponse) {
            return ((GetTalkgroupsResponse)response.getResponseBody()).getTalkgroups();
        }
        return null;
    }

    public List<Talkgroup> getTalkgroups(TalkgroupRequestFilter filter) throws RadioReferenceException {
        RequestEnvelope request = GetTalkgroups.create(this.mAuthorizationInformation, filter);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetTalkgroupsResponse) {
            return ((GetTalkgroupsResponse)response.getResponseBody()).getTalkgroups();
        }
        return null;
    }

    public List<TalkgroupCategory> getTalkgroupCategories(int systemId) throws RadioReferenceException {
        RequestEnvelope request = GetTalkgroupCategories.create(this.mAuthorizationInformation, systemId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetTalkgroupCategoriesResponse) {
            return ((GetTalkgroupCategoriesResponse)response.getResponseBody()).getTalkgroupCategories();
        }
        return null;
    }

    public Flavor getFlavor(int flavorId) throws RadioReferenceException {
        this.getFlavorsMap();
        if (this.mFlavorMap != null) {
            return this.mFlavorMap.get(flavorId);
        }
        return null;
    }

    public Map<Integer, Flavor> getFlavorsMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mFlavorMap == null && (response = this.submitSync(request = GetFlavors.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetFlavorsResponse) {
            List<Flavor> flavors = ((GetFlavorsResponse)response.getResponseBody()).getFlavors();
            this.mFlavorMap = new TreeMap<Integer, Flavor>();
            for (Flavor flavor : flavors) {
                this.mFlavorMap.put(flavor.getFlavorId(), flavor);
            }
        }
        return this.mFlavorMap;
    }

    public Mode getMode(int modeId) throws RadioReferenceException {
        this.getModesMap();
        if (this.mModeMap != null) {
            return this.mModeMap.get(modeId);
        }
        return null;
    }

    public Map<Integer, Mode> getModesMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mModeMap == null && (response = this.submitSync(request = GetModes.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetModesResponse) {
            List<Mode> modes = ((GetModesResponse)response.getResponseBody()).getModes();
            this.mModeMap = new TreeMap<Integer, Mode>();
            for (Mode mode : modes) {
                this.mModeMap.put(mode.getModeId(), mode);
            }
        }
        return this.mModeMap;
    }

    public Metro getMetro(int metroId) throws RadioReferenceException {
        this.getMetrosMap();
        if (this.mMetroMap != null) {
            return this.mMetroMap.get(metroId);
        }
        return null;
    }

    public Map<Integer, Metro> getMetrosMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mMetroMap == null && (response = this.submitSync(request = GetMetros.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetMetrosResponse) {
            List<Metro> metros = ((GetMetrosResponse)response.getResponseBody()).getMetros();
            this.mMetroMap = new TreeMap<Integer, Metro>();
            for (Metro metro : metros) {
                this.mMetroMap.put(metro.getMetroId(), metro);
            }
        }
        return this.mMetroMap;
    }

    public Map<Integer, List<County>> getMetroCountiesMap() throws RadioReferenceException {
        Map<Integer, Metro> metrosMap;
        if (this.mMetroCountiesMap == null && (metrosMap = this.getMetrosMap()) != null) {
            this.mMetroCountiesMap = new TreeMap<Integer, List<County>>();
            for (Metro metro : metrosMap.values()) {
                RequestEnvelope request = GetMetroInfo.create(this.mAuthorizationInformation, metro.getMetroId());
                ResponseEnvelope response = this.submitSync(request);
                if (response == null || !(response.getResponseBody() instanceof GetMetroInfoResponse)) continue;
                List<County> counties = ((GetMetroInfoResponse)response.getResponseBody()).getCounties();
                this.mMetroCountiesMap.put(metro.getMetroId(), counties);
            }
        }
        return this.mMetroCountiesMap;
    }

    public List<County> getMetroCounties(int metroId) throws RadioReferenceException {
        RequestEnvelope request = GetMetroInfo.create(this.mAuthorizationInformation, metroId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetMetroInfoResponse) {
            return ((GetMetroInfoResponse)response.getResponseBody()).getCounties();
        }
        return Collections.emptyList();
    }

    public List<Metro> getMetrosByState(int stateId) throws RadioReferenceException {
        ArrayList<Metro> metros = new ArrayList<Metro>();
        StateInfo stateInfo = this.getStateInfo(stateId);
        Map<Integer, List<County>> metroMap = this.getMetroCountiesMap();
        if (metroMap != null) {
            for (County county : stateInfo.getCounties()) {
                for (Map.Entry<Integer, List<County>> entry : metroMap.entrySet()) {
                    for (County metroCounty : entry.getValue()) {
                        Metro metro;
                        if (county.getCountyId() != metroCounty.getCountyId() || metros.contains(metro = this.getMetro(entry.getKey()))) continue;
                        metros.add(metro);
                    }
                }
            }
        }
        return metros;
    }

    public Map<Integer, Tag> getTagsMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mTagMap == null && (response = this.submitSync(request = GetTags.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetTagsResponse) {
            this.mTagMap = new TreeMap<Integer, Tag>();
            List<Tag> tags = ((GetTagsResponse)response.getResponseBody()).getTags();
            for (Tag tag : tags) {
                try {
                    this.mTagMap.put(tag.getTagId(), tag);
                }
                catch (Exception e) {
                    mLog.error("Error while parsing tags response into tags map");
                    try {
                        mLog.info("Get Tags Response Message:\n" + response.toXmlString());
                    }
                    catch (Exception e2) {
                        mLog.error("Error serializing message to xml (again)", (Throwable)e2);
                    }
                }
            }
        }
        return this.mTagMap;
    }

    public void clearTagMap() {
        this.mTagMap = null;
    }

    public Tag getTag(int tagId) throws RadioReferenceException {
        this.getTagsMap();
        if (this.mTagMap != null) {
            return this.mTagMap.get(tagId);
        }
        return null;
    }

    public Type getType(int typeId) throws RadioReferenceException {
        this.getTypesMap();
        if (this.mTypeMap != null) {
            return this.mTypeMap.get(typeId);
        }
        return null;
    }

    public Map<Integer, Type> getTypesMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mTypeMap == null && (response = this.submitSync(request = GetTypes.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetTypesResponse) {
            this.mTypeMap = new TreeMap<Integer, Type>();
            List<Type> types = ((GetTypesResponse)response.getResponseBody()).getTypes();
            for (Type type : types) {
                this.mTypeMap.put(type.getTypeId(), type);
            }
        }
        return this.mTypeMap;
    }

    public Map<Integer, Voice> getVoicesMap() throws RadioReferenceException {
        RequestEnvelope request;
        ResponseEnvelope response;
        if (this.mVoiceMap == null && (response = this.submitSync(request = GetVoices.create(this.mAuthorizationInformation))) != null && response.getResponseBody() instanceof GetVoicesResponse) {
            this.mVoiceMap = new TreeMap<Integer, Voice>();
            List<Voice> voices = ((GetVoicesResponse)response.getResponseBody()).getVoices();
            for (Voice voice : voices) {
                this.mVoiceMap.put(voice.getVoiceId(), voice);
            }
        }
        return this.mVoiceMap;
    }

    public Voice getVoice(int voiceId) throws RadioReferenceException {
        this.getVoicesMap();
        if (this.mVoiceMap != null) {
            return this.mVoiceMap.get(voiceId);
        }
        return null;
    }

    public ZipInfo getZipcodeInfo(int zipcode) throws RadioReferenceException {
        RequestEnvelope request = GetZipcodeInfo.create(this.mAuthorizationInformation, zipcode);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetZipcodeInfoResponse) {
            return ((GetZipcodeInfoResponse)response.getResponseBody()).getZipcodeInfo();
        }
        return null;
    }

    public List<Frequency> getSubCategoryFrequencies(int subCategoryId) throws RadioReferenceException {
        RequestEnvelope request = GetSubCategoryFrequenciesRequest.create(this.mAuthorizationInformation, subCategoryId);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof GetSubCategoryFrequenciesResponse) {
            return ((GetSubCategoryFrequenciesResponse)response.getResponseBody()).getFrequencies();
        }
        return Collections.emptyList();
    }

    public List<SearchFrequencyResult> searchCountyFrequencies(int countyId, double frequency) throws RadioReferenceException {
        return this.searchCountyFrequencies(countyId, frequency, null);
    }

    public List<SearchFrequencyResult> searchCountyFrequencies(int countyId, double frequency, String tone) throws RadioReferenceException {
        RequestEnvelope request = SearchCountyFrequency.create(this.mAuthorizationInformation, countyId, frequency, tone);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof SearchFrequencyResponse) {
            return ((SearchFrequencyResponse)response.getResponseBody()).getResults();
        }
        return Collections.emptyList();
    }

    public List<SearchFrequencyResult> searchStateFrequencies(int stateId, double frequency) throws RadioReferenceException {
        return this.searchStateFrequencies(stateId, frequency, null);
    }

    public List<SearchFrequencyResult> searchStateFrequencies(int stateId, double frequency, String tone) throws RadioReferenceException {
        RequestEnvelope request = SearchStateFrequency.create(this.mAuthorizationInformation, stateId, frequency, tone);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof SearchFrequencyResponse) {
            return ((SearchFrequencyResponse)response.getResponseBody()).getResults();
        }
        return Collections.emptyList();
    }

    public List<SearchFrequencyResult> searchMetroFrequencies(int metroId, double frequency) throws RadioReferenceException {
        return this.searchMetroFrequencies(metroId, frequency, null);
    }

    public List<SearchFrequencyResult> searchMetroFrequencies(int metroId, double frequency, String tone) throws RadioReferenceException {
        RequestEnvelope request = SearchMetroFrequency.create(this.mAuthorizationInformation, metroId, frequency, tone);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof SearchFrequencyResponse) {
            return ((SearchFrequencyResponse)response.getResponseBody()).getResults();
        }
        return Collections.emptyList();
    }

    public FccCallsignDetails getFccCallsignDetails(String callsign) throws RadioReferenceException {
        RequestEnvelope request = FccGetCallsign.create(this.mAuthorizationInformation, callsign);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FccGetCallsignResponse) {
            return ((FccGetCallsignResponse)response.getResponseBody()).getFccCallsignDetails();
        }
        return null;
    }

    public List<FccRadioServiceCode> getFccRadioServiceCodes() throws RadioReferenceException {
        RequestEnvelope request = FccGetRadioServiceCode.create(this.mAuthorizationInformation);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FccGetRadioServiceCodeResponse) {
            return ((FccGetRadioServiceCodeResponse)response.getResponseBody()).getFccRadioServiceCodes();
        }
        return Collections.emptyList();
    }

    public FccRadioServiceCode getFccRadioServiceCode(String code) throws RadioReferenceException {
        List<FccRadioServiceCode> codes;
        RequestEnvelope request = FccGetRadioServiceCode.create(this.mAuthorizationInformation, code);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FccGetRadioServiceCodeResponse && (codes = ((FccGetRadioServiceCodeResponse)response.getResponseBody()).getFccRadioServiceCodes()) != null && !codes.isEmpty()) {
            return codes.get(0);
        }
        return null;
    }

    public List<ProximityCallsignResult> getFccCallsignsNearLocation(double latitude, double longitude, double range) throws RadioReferenceException {
        RequestEnvelope request = FccGetProximityCallsigns.create(this.mAuthorizationInformation, latitude, longitude, range);
        ResponseEnvelope response = this.submitSync(request);
        if (response != null && response.getResponseBody() instanceof FccGetProximityCallsignResponse) {
            return ((FccGetProximityCallsignResponse)response.getResponseBody()).getProximityCallsignResults();
        }
        return Collections.emptyList();
    }

    private ResponseEnvelope submitSync(RequestEnvelope requestEnvelope) throws RadioReferenceException {
        String xml;
        try {
            xml = requestEnvelope.toXmlString();
        }
        catch (JsonProcessingException jpe) {
            throw new RadioReferenceException("Error serializing request envelope to XML", jpe);
        }
        if (xml != null) {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(RADIO_REFERENCE_API_URL)).header(CONTENT_TYPE, XML_CONTENT_TYPE).header(USER_AGENT, USER_AGENT_RRAPI).POST(HttpRequest.BodyPublishers.ofString(xml)).build();
            HttpResponse<String> response = null;
            try {
                response = this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException ioe) {
                throw new RadioReferenceException("Error submitting HTML SOAP request to web service", ioe);
            }
            catch (InterruptedException ie) {
                throw new RadioReferenceException("Interrupted while submitting HTML SOAP request to web service", ie);
            }
            if (response != null) {
                try {
                    if (response.statusCode() == 200) {
                        return RadioReferenceService.deserialize(response.body());
                    }
                    ResponseEnvelope responseEnvelope = RadioReferenceService.deserialize(response.body());
                    if (responseEnvelope.getResponseBody() instanceof Fault) {
                        throw new RadioReferenceException("Error", response.statusCode(), (Fault)responseEnvelope.getResponseBody());
                    }
                }
                catch (IOException ioe) {
                    mLog.error("Error parsing response: " + response.body());
                    throw new RadioReferenceException("Error deserializing XML response: " + response.body(), ioe);
                }
            }
        }
        return null;
    }

    private static ResponseEnvelope deserialize(String xml) throws IOException {
        if (xml != null) {
            XmlMapper mapper = new XmlMapper();
            return (ResponseEnvelope)mapper.readValue(xml, ResponseEnvelope.class);
        }
        return null;
    }
}

