/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mpg;

import net.sourceforge.lame.mpg.Common;
import net.sourceforge.lame.mpg.Frame;
import net.sourceforge.lame.mpg.Interface;
import net.sourceforge.lame.mpg.L2Tables;
import net.sourceforge.lame.mpg.MPGLib;

public class Layer2 {
    private static final double[] mulmul = new double[]{0.0, -0.6666666666666666, 0.6666666666666666, 0.2857142857142857, 0.13333333333333333, 0.06451612903225806, 0.031746031746031744, 0.015748031496062992, 0.00784313725490196, 0.003913894324853229, 0.0019550342130987292, 9.770395701025891E-4, 4.884004884004884E-4, 2.4417043096081065E-4, 1.2207776353537203E-4, 6.103701895199438E-5, 3.0518043793392844E-5, -0.8, -0.4, 0.4, 0.8, -0.8888888888888888, -0.4444444444444444, -0.2222222222222222, 0.2222222222222222, 0.4444444444444444, 0.8888888888888888};
    private static final int[][][] translate = new int[][][]{new int[][]{{0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 0}, {0, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}}, new int[][]{{0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}}};
    private final int[] grp_3tab = new int[96];
    private final int[] grp_5tab = new int[384];
    private final int[] grp_9tab = new int[3072];
    private final int[][] tables = new int[][]{this.grp_3tab, this.grp_5tab, this.grp_9tab};
    private final int[][] table = new int[][]{null, null, null, this.grp_3tab, null, this.grp_5tab, null, null, null, this.grp_9tab};
    private final int[][] base = new int[][]{{1, 0, 2}, {17, 18, 0, 19, 20}, {21, 1, 22, 23, 0, 24, 25, 2, 26}};
    private final int[] tablen = new int[]{3, 5, 9};
    private final L2Tables.al_table2[][] tables2 = new L2Tables.al_table2[][]{L2Tables.alloc_0, L2Tables.alloc_1, L2Tables.alloc_2, L2Tables.alloc_3, L2Tables.alloc_4};
    private final int[] sblims = new int[]{27, 30, 8, 12, 30};
    private Common common;
    private int itable;
    private int[] scfsi_buf = new int[64];

    public Layer2(Common c) {
        this.common = c;
    }

    public void init_layer2() {
        int k;
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            this.itable = 0;
            int len = this.tablen[i];
            for (j = 0; j < len; ++j) {
                for (k = 0; k < len; ++k) {
                    for (int l = 0; l < len; ++l) {
                        this.tables[i][this.itable++] = this.base[i][l];
                        this.tables[i][this.itable++] = this.base[i][k];
                        this.tables[i][this.itable++] = this.base[i][j];
                    }
                }
            }
        }
        for (k = 0; k < 27; ++k) {
            double m = mulmul[k];
            float[] table = this.common.muls[k];
            int tablePos = 0;
            j = 3;
            i = 0;
            while (i < 63) {
                table[tablePos++] = (float)(m * Math.pow(2.0, (double)j / 3.0));
                ++i;
                --j;
            }
            table[tablePos++] = 0.0f;
        }
    }

    private void II_step_one(MPGLib.mpstr_tag mp, int[] bit_alloc, int[] scale, Frame fr) {
        int scfsi;
        short step;
        int i;
        int scalePos = 0;
        int stereo = fr.stereo - 1;
        int sblimit = fr.II_sblimit;
        int jsbound = fr.jsbound;
        int sblimit2 = fr.II_sblimit << stereo;
        int alloc1 = 0;
        int bita = 0;
        if (stereo != 0) {
            i = jsbound;
            while (i != 0) {
                int n = bita++;
                step = fr.alloc[alloc1].bits;
                bit_alloc[n] = (char)this.common.getbits(mp, step);
                bit_alloc[bita++] = (char)this.common.getbits(mp, step);
                --i;
                alloc1 += 1 << step;
            }
            i = sblimit - jsbound;
            while (i != 0) {
                step = fr.alloc[alloc1].bits;
                bit_alloc[bita + 0] = (char)this.common.getbits(mp, step);
                bit_alloc[bita + 1] = bit_alloc[bita + 0];
                bita += 2;
                --i;
                alloc1 += 1 << step;
            }
            bita = 0;
            scfsi = 0;
            for (i = sblimit2; i != 0; --i) {
                if (bit_alloc[bita++] == 0) continue;
                this.scfsi_buf[scfsi++] = (char)this.common.getbits_fast(mp, 2);
            }
        } else {
            i = sblimit;
            while (i != 0) {
                int n = bita++;
                step = fr.alloc[alloc1].bits;
                bit_alloc[n] = (char)this.common.getbits(mp, step);
                --i;
                alloc1 += 1 << step;
            }
            bita = 0;
            scfsi = 0;
            for (i = sblimit; i != 0; --i) {
                if (bit_alloc[bita++] == 0) continue;
                this.scfsi_buf[scfsi++] = (char)this.common.getbits_fast(mp, 2);
            }
        }
        bita = 0;
        scfsi = 0;
        block10: for (i = sblimit2; i != 0; --i) {
            if (bit_alloc[bita++] == 0) continue;
            switch (this.scfsi_buf[scfsi++]) {
                case 0: {
                    scale[scalePos++] = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = this.common.getbits_fast(mp, 6);
                    continue block10;
                }
                case 1: {
                    int sc;
                    scale[scalePos++] = sc = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = sc;
                    scale[scalePos++] = this.common.getbits_fast(mp, 6);
                    continue block10;
                }
                case 2: {
                    int sc;
                    scale[scalePos++] = sc = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = sc;
                    scale[scalePos++] = sc;
                    continue block10;
                }
                default: {
                    int sc;
                    scale[scalePos++] = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = sc = this.common.getbits_fast(mp, 6);
                    scale[scalePos++] = sc;
                }
            }
        }
    }

    private void II_step_two(MPGLib.mpstr_tag mp, int[] bit_alloc, float[][][] fraction, int[] scale, Frame fr, int x1) {
        int tab;
        short d1;
        short k;
        int alloc2;
        int ba;
        int j;
        short step;
        int scalePos = 0;
        int stereo = fr.stereo;
        int sblimit = fr.II_sblimit;
        int jsbound = fr.jsbound;
        int alloc1 = 0;
        int bita = 0;
        int i = 0;
        while (i < jsbound) {
            step = fr.alloc[alloc1].bits;
            for (j = 0; j < stereo; ++j) {
                if ((ba = bit_alloc[bita++]) != 0) {
                    alloc2 = alloc1 + ba;
                    k = fr.alloc[alloc2].bits;
                    d1 = fr.alloc[alloc2].d;
                    if (d1 < 0) {
                        float cm = this.common.muls[k][scale[scalePos + x1]];
                        fraction[j][0][i] = (float)(this.common.getbits(mp, k) + d1) * cm;
                        fraction[j][1][i] = (float)(this.common.getbits(mp, k) + d1) * cm;
                        fraction[j][2][i] = (float)(this.common.getbits(mp, k) + d1) * cm;
                    } else {
                        int m = scale[scalePos + x1];
                        int idx = this.common.getbits(mp, k);
                        tab = idx + idx + idx;
                        fraction[j][0][i] = this.common.muls[this.table[d1][tab++]][m];
                        fraction[j][1][i] = this.common.muls[this.table[d1][tab++]][m];
                        fraction[j][2][i] = this.common.muls[this.table[d1][tab]][m];
                    }
                    scalePos += 3;
                    continue;
                }
                fraction[j][2][i] = 0.0f;
                fraction[j][1][i] = 0.0f;
                fraction[j][0][i] = 0.0f;
            }
            ++i;
            alloc1 += 1 << step;
        }
        i = jsbound;
        while (i < sblimit) {
            step = fr.alloc[alloc1].bits;
            int n = ++bita;
            ++bita;
            ba = bit_alloc[n];
            if (ba != 0) {
                alloc2 = alloc1 + ba;
                k = fr.alloc[alloc2].bits;
                d1 = fr.alloc[alloc2].d;
                if (d1 < 0) {
                    float cm = this.common.muls[k][scale[scalePos + x1 + 3]];
                    float f = this.common.getbits(mp, k) + d1;
                    fraction[0][0][i] = f;
                    fraction[1][0][i] = f * cm;
                    float f2 = this.common.getbits(mp, k) + d1;
                    fraction[0][1][i] = f2;
                    fraction[1][1][i] = f2 * cm;
                    float f3 = this.common.getbits(mp, k) + d1;
                    fraction[0][2][i] = f3;
                    fraction[1][2][i] = f3 * cm;
                    cm = this.common.muls[k][scale[scalePos + x1]];
                    float[] fArray = fraction[0][0];
                    int n2 = i;
                    fArray[n2] = fArray[n2] * cm;
                    float[] fArray2 = fraction[0][1];
                    int n3 = i;
                    fArray2[n3] = fArray2[n3] * cm;
                    float[] fArray3 = fraction[0][2];
                    int n4 = i;
                    fArray3[n4] = fArray3[n4] * cm;
                } else {
                    int m1 = scale[scalePos + x1];
                    int m2 = scale[scalePos + x1 + 3];
                    int idx = this.common.getbits(mp, k);
                    tab = idx + idx + idx;
                    fraction[0][0][i] = this.common.muls[this.table[d1][tab]][m1];
                    fraction[1][0][i] = this.common.muls[this.table[d1][tab++]][m2];
                    fraction[0][1][i] = this.common.muls[this.table[d1][tab]][m1];
                    fraction[1][1][i] = this.common.muls[this.table[d1][tab++]][m2];
                    fraction[0][2][i] = this.common.muls[this.table[d1][tab]][m1];
                    fraction[1][2][i] = this.common.muls[this.table[d1][tab]][m2];
                }
                scalePos += 6;
            } else {
                fraction[1][2][i] = 0.0f;
                fraction[1][1][i] = 0.0f;
                fraction[1][0][i] = 0.0f;
                fraction[0][2][i] = 0.0f;
                fraction[0][1][i] = 0.0f;
                fraction[0][0][i] = 0.0f;
            }
            ++i;
            alloc1 += 1 << step;
        }
        for (i = sblimit; i < 32; ++i) {
            for (j = 0; j < stereo; ++j) {
                fraction[j][2][i] = 0.0f;
                fraction[j][1][i] = 0.0f;
                fraction[j][0][i] = 0.0f;
            }
        }
    }

    private void II_select_table(Frame fr) {
        int table = fr.lsf != 0 ? 4 : translate[fr.sampling_frequency][2 - fr.stereo][fr.bitrate_index];
        int sblim = this.sblims[table];
        fr.alloc = this.tables2[table];
        fr.II_sblimit = sblim;
    }

    public <T> int do_layer2(MPGLib.mpstr_tag mp, float[] pcm_sample, MPGLib.ProcessedBytes pcm_point, Interface.ISynth synth) {
        int clip = 0;
        float[][][] fraction = new float[2][4][32];
        int[] bit_alloc = new int[64];
        int[] scale = new int[192];
        Frame fr = mp.fr;
        int stereo = fr.stereo;
        int single = fr.single;
        this.II_select_table(fr);
        int n = fr.jsbound = fr.mode == 1 ? (fr.mode_ext << 2) + 4 : fr.II_sblimit;
        if (stereo == 1 || single == 3) {
            single = 0;
        }
        this.II_step_one(mp, bit_alloc, scale, fr);
        for (int i = 0; i < 12; ++i) {
            this.II_step_two(mp, bit_alloc, fraction, scale, fr, i >> 2);
            for (int j = 0; j < 3; ++j) {
                if (single >= 0) {
                    clip += synth.synth_1to1_mono_ptr(mp, fraction[single][j], 0, pcm_sample, pcm_point);
                    continue;
                }
                MPGLib.ProcessedBytes p1 = new MPGLib.ProcessedBytes();
                p1.pb = pcm_point.pb;
                clip += synth.synth_1to1_ptr(mp, fraction[0][j], 0, 0, pcm_sample, p1);
                clip += synth.synth_1to1_ptr(mp, fraction[1][j], 0, 1, pcm_sample, pcm_point);
            }
        }
        return clip;
    }
}

