/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mpg;

import java.util.ArrayList;
import net.sourceforge.lame.mp3.VBRTag;
import net.sourceforge.lame.mp3.VBRTagData;
import net.sourceforge.lame.mpg.Common;
import net.sourceforge.lame.mpg.Decode;
import net.sourceforge.lame.mpg.Frame;
import net.sourceforge.lame.mpg.Layer1;
import net.sourceforge.lame.mpg.Layer2;
import net.sourceforge.lame.mpg.Layer3;
import net.sourceforge.lame.mpg.MPGLib;

public class Interface {
    public static final int XING_HEADER_SIZE = 194;
    protected Decode decode = new Decode();
    private VBRTag vbr;
    private Common common = new Common();
    private Layer1 layer1 = new Layer1(this.common, this.decode);
    private Layer2 layer2 = new Layer2(this.common);
    private Layer3 layer3 = new Layer3(this.common);

    public void setModules(VBRTag v) {
        this.vbr = v;
    }

    MPGLib.mpstr_tag InitMP3() {
        MPGLib.mpstr_tag mp = new MPGLib.mpstr_tag();
        mp.framesize = 0;
        mp.num_frames = 0;
        mp.enc_delay = -1;
        mp.enc_padding = -1;
        mp.vbr_header = false;
        mp.header_parsed = false;
        mp.side_parsed = false;
        mp.data_parsed = false;
        mp.free_format = false;
        mp.old_free_format = false;
        mp.ssize = 0;
        mp.dsize = 0;
        mp.fsizeold = -1;
        mp.bsize = 0;
        mp.list = new ArrayList<MPGLib.buf>();
        mp.fr.single = -1;
        mp.bsnum = 0;
        mp.wordpointer = mp.bsspace[mp.bsnum];
        mp.wordpointerPos = 512;
        mp.bitindex = 0;
        mp.synth_bo = 1;
        mp.sync_bitstream = true;
        this.layer3.init_layer3(32);
        this.layer2.init_layer2();
        return mp;
    }

    void ExitMP3(MPGLib.mpstr_tag mp) {
        mp.list.clear();
    }

    MPGLib.buf addbuf(MPGLib.mpstr_tag mp, byte[] buf2, int bufPos, int size) {
        MPGLib.buf nbuf = new MPGLib.buf();
        nbuf.pnt = new byte[size];
        nbuf.size = size;
        System.arraycopy(buf2, bufPos, nbuf.pnt, 0, size);
        nbuf.pos = 0;
        mp.list.add(nbuf);
        mp.bsize += size;
        return nbuf;
    }

    void remove_buf(MPGLib.mpstr_tag mp) {
        mp.list.remove(0);
    }

    int read_buf_byte(MPGLib.mpstr_tag mp) {
        int pos = mp.list.get((int)0).pos;
        while (pos >= mp.list.get((int)0).size) {
            this.remove_buf(mp);
            if (null == mp.list.get(0)) {
                throw new RuntimeException("hip: Fatal error! tried to read past mp buffer");
            }
            pos = mp.list.get((int)0).pos;
        }
        int b = mp.list.get((int)0).pnt[pos] & 0xFF;
        --mp.bsize;
        ++mp.list.get((int)0).pos;
        return b;
    }

    void read_head(MPGLib.mpstr_tag mp) {
        long head = this.read_buf_byte(mp);
        head <<= 8;
        head |= (long)this.read_buf_byte(mp);
        head <<= 8;
        head |= (long)this.read_buf_byte(mp);
        head <<= 8;
        mp.header = head |= (long)this.read_buf_byte(mp);
    }

    void copy_mp(MPGLib.mpstr_tag mp, int size, byte[] ptr, int ptrPos) {
        int len = 0;
        while (len < size && mp.list.get(0) != null) {
            int blen = mp.list.get((int)0).size - mp.list.get((int)0).pos;
            int nlen = size - len <= blen ? size - len : blen;
            System.arraycopy(mp.list.get((int)0).pnt, mp.list.get((int)0).pos, ptr, ptrPos + len, nlen);
            len += nlen;
            mp.list.get((int)0).pos += nlen;
            mp.bsize -= nlen;
            if (mp.list.get((int)0).pos != mp.list.get((int)0).size) continue;
            this.remove_buf(mp);
        }
    }

    int check_vbr_header(MPGLib.mpstr_tag mp, int bytes) {
        int i;
        int l = 0;
        MPGLib.buf buf2 = mp.list.get(l);
        byte[] xing = new byte[194];
        int pos = buf2.pos;
        for (i = 0; i < bytes; ++i) {
            while (pos >= buf2.size) {
                if (++l == mp.list.size()) {
                    return -1;
                }
                buf2 = mp.list.get(l);
                pos = buf2.pos;
            }
            ++pos;
        }
        for (i = 0; i < 194; ++i) {
            while (pos >= buf2.size) {
                if (++l == mp.list.size()) {
                    return -1;
                }
                buf2 = mp.list.get(l);
                pos = buf2.pos;
            }
            xing[i] = buf2.pnt[pos];
            ++pos;
        }
        VBRTagData pTagData = this.vbr.getVbrTag(xing);
        boolean bl = mp.vbr_header = pTagData != null;
        if (mp.vbr_header) {
            mp.num_frames = pTagData.frames;
            mp.enc_delay = pTagData.encDelay;
            mp.enc_padding = pTagData.encPadding;
            if (pTagData.headersize < 1) {
                return 1;
            }
            return pTagData.headersize;
        }
        return 0;
    }

    int sync_buffer(MPGLib.mpstr_tag mp, boolean free_match) {
        int[] b = new int[]{0, 0, 0, 0};
        int l = 0;
        if (mp.list.size() == 0) {
            return -1;
        }
        MPGLib.buf buf2 = mp.list.get(l);
        int pos = buf2.pos;
        for (int i = 0; i < mp.bsize; ++i) {
            b[0] = b[1];
            b[1] = b[2];
            b[2] = b[3];
            while (pos >= buf2.size) {
                buf2 = mp.list.get(++l);
                pos = buf2.pos;
            }
            b[3] = buf2.pnt[pos] & 0xFF;
            ++pos;
            if (i < 3) continue;
            Frame fr = mp.fr;
            long head = b[0];
            head <<= 8;
            head |= (long)b[1];
            head <<= 8;
            head |= (long)b[2];
            head <<= 8;
            boolean h = this.common.head_check(head |= (long)b[3], fr.lay);
            if (h && free_match) {
                boolean mpeg25;
                int lsf;
                if ((head & 0x100000L) != 0L) {
                    lsf = (head & 0x80000L) != 0L ? 0 : 1;
                    mpeg25 = false;
                } else {
                    lsf = 1;
                    mpeg25 = true;
                }
                int mode = (int)(head >> 6 & 3L);
                int stereo = mode == 3 ? 1 : 2;
                int sampling_frequency = mpeg25 ? (int)(6L + (head >> 10 & 3L)) : (int)((head >> 10 & 3L) + (long)(lsf * 3));
                boolean bl = h = stereo == fr.stereo && lsf == fr.lsf && mpeg25 == fr.mpeg25 && sampling_frequency == fr.sampling_frequency;
            }
            if (!h) continue;
            return i - 3;
        }
        return -1;
    }

    int audiodata_precedesframes(MPGLib.mpstr_tag mp) {
        if (mp.fr.lay == 3) {
            return this.layer3.layer3_audiodata_precedesframes(mp);
        }
        return 0;
    }

    int decodeMP3_clipchoice(MPGLib.mpstr_tag mp, byte[] in, int inPos, int isize, float[] out, MPGLib.ProcessedBytes done, ISynth synth) {
        int size;
        int bytes;
        if (in != null && isize != 0 && this.addbuf(mp, in, inPos, isize) == null) {
            return -1;
        }
        if (!mp.header_parsed) {
            if (mp.fsizeold == -1 || mp.sync_bitstream) {
                mp.sync_bitstream = false;
                bytes = this.sync_buffer(mp, false);
                if (mp.bsize < bytes + 194) {
                    return 1;
                }
                int vbrbytes = this.check_vbr_header(mp, bytes);
                if (mp.vbr_header) {
                    if (bytes + vbrbytes > mp.bsize) {
                        return 1;
                    }
                    for (int i = 0; i < vbrbytes + bytes; ++i) {
                        this.read_buf_byte(mp);
                    }
                    return 1;
                }
            } else {
                bytes = this.sync_buffer(mp, true);
            }
            if (bytes < 0) {
                return 1;
            }
            if (bytes > 0) {
                System.err.printf("hip: bitstream problem, resyncing skipping %d bytes...\n", bytes);
                mp.old_free_format = false;
                mp.sync_bitstream = true;
                size = mp.wordpointerPos - 512;
                if (size > 2880) {
                    System.err.printf("hip: wordpointer trashed.  size=%i (%i)  bytes=%i \n", size, 2880, bytes);
                    size = 0;
                    mp.wordpointer = mp.bsspace[mp.bsnum];
                    mp.wordpointerPos = 512;
                }
                for (int i = size + bytes - 2880; i > 0; --i) {
                    --bytes;
                    this.read_buf_byte(mp);
                }
                this.copy_mp(mp, bytes, mp.wordpointer, mp.wordpointerPos);
                mp.fsizeold += bytes;
            }
            this.read_head(mp);
            this.common.decode_header(mp.fr, mp.header);
            mp.header_parsed = true;
            mp.framesize = mp.fr.framesize;
            boolean bl = mp.free_format = mp.framesize == 0;
            if (mp.fr.lsf != 0) {
                mp.ssize = mp.fr.stereo == 1 ? 9 : 17;
            } else {
                int n = mp.ssize = mp.fr.stereo == 1 ? 17 : 32;
            }
            if (mp.fr.error_protection) {
                mp.ssize += 2;
            }
            mp.bsnum = 1 - mp.bsnum;
            mp.wordpointer = mp.bsspace[mp.bsnum];
            mp.wordpointerPos = 512;
            mp.bitindex = 0;
            if (mp.fsizeold == -1) {
                return 1;
            }
        }
        if (!mp.side_parsed) {
            if (mp.fr.lay == 3) {
                int bits;
                if (mp.bsize < mp.ssize) {
                    return 1;
                }
                this.copy_mp(mp, mp.ssize, mp.wordpointer, mp.wordpointerPos);
                if (mp.fr.error_protection) {
                    this.common.getbits(mp, 16);
                }
                if ((bits = this.layer3.do_layer3_sideinfo(mp)) < 0) {
                    bits = 0;
                }
                mp.dsize = (bits + 7) / 8;
            } else {
                if (mp.fr.framesize > mp.bsize) {
                    return 1;
                }
                mp.dsize = mp.fr.framesize;
                mp.ssize = 0;
            }
            mp.side_parsed = true;
        }
        int iret = 1;
        if (!mp.data_parsed) {
            if (mp.dsize > mp.bsize) {
                return 1;
            }
            this.copy_mp(mp, mp.dsize, mp.wordpointer, mp.wordpointerPos);
            done.pb = 0;
            switch (mp.fr.lay) {
                case 1: {
                    if (mp.fr.error_protection) {
                        this.common.getbits(mp, 16);
                    }
                    this.layer1.do_layer1(mp, out, done);
                    break;
                }
                case 2: {
                    if (mp.fr.error_protection) {
                        this.common.getbits(mp, 16);
                    }
                    this.layer2.do_layer2(mp, out, done, synth);
                    break;
                }
                case 3: {
                    this.layer3.do_layer3(mp, out, done, synth);
                    break;
                }
                default: {
                    System.err.printf("hip: invalid layer %d\n", mp.fr.lay);
                }
            }
            mp.wordpointer = mp.bsspace[mp.bsnum];
            mp.wordpointerPos = 512 + mp.ssize + mp.dsize;
            mp.data_parsed = true;
            iret = 0;
        }
        if (mp.free_format) {
            if (mp.old_free_format) {
                mp.framesize = mp.fsizeold_nopadding + mp.fr.padding;
            } else {
                bytes = this.sync_buffer(mp, true);
                if (bytes < 0) {
                    return iret;
                }
                mp.framesize = bytes + mp.ssize + mp.dsize;
                mp.fsizeold_nopadding = mp.framesize - mp.fr.padding;
            }
        }
        if ((bytes = mp.framesize - (mp.ssize + mp.dsize)) > mp.bsize) {
            return iret;
        }
        if (bytes > 0) {
            this.copy_mp(mp, bytes, mp.wordpointer, mp.wordpointerPos);
            mp.wordpointerPos += bytes;
            size = mp.wordpointerPos - 512;
            if (size > 2880) {
                System.err.printf("hip: fatal error.  MAXFRAMESIZE not large enough.\n", new Object[0]);
            }
        }
        mp.fsizeold = mp.framesize;
        mp.old_free_format = mp.free_format;
        mp.framesize = 0;
        mp.header_parsed = false;
        mp.side_parsed = false;
        mp.data_parsed = false;
        return iret;
    }

    int decodeMP3(MPGLib.mpstr_tag mp, byte[] in, int bufferPos, int isize, float[] out, int osize, MPGLib.ProcessedBytes done) {
        if (osize < 2304) {
            System.err.printf("hip: Insufficient memory for decoding buffer %d\n", osize);
            return -1;
        }
        ISynth synth = new ISynth(){

            @Override
            public int synth_1to1_mono_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, float[] out, MPGLib.ProcessedBytes p) {
                return Interface.this.decode.synth1to1mono(mp, in, inPos, out, p);
            }

            @Override
            public int synth_1to1_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, int i, float[] out, MPGLib.ProcessedBytes p) {
                return Interface.this.decode.synth_1to1(mp, in, inPos, i, out, p);
            }
        };
        return this.decodeMP3_clipchoice(mp, in, bufferPos, isize, out, done, synth);
    }

    int decodeMP3_unclipped(MPGLib.mpstr_tag mp, byte[] in, int bufferPos, int isize, float[] out, int osize, MPGLib.ProcessedBytes done) {
        if (osize < 2304) {
            System.err.printf("hip: out space too small for unclipped mode\n", new Object[0]);
            return -1;
        }
        ISynth synth = new ISynth(){

            @Override
            public int synth_1to1_mono_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, float[] out, MPGLib.ProcessedBytes p) {
                Interface.this.decode.synth1to1monoUnclipped(mp, in, inPos, out, p);
                return 0;
            }

            @Override
            public int synth_1to1_ptr(MPGLib.mpstr_tag mp, float[] in, int inPos, int i, float[] out, MPGLib.ProcessedBytes p) {
                Interface.this.decode.synth_1to1_unclipped(mp, in, inPos, i, out, p);
                return 0;
            }
        };
        return this.decodeMP3_clipchoice(mp, in, bufferPos, isize, out, done, synth);
    }

    static interface ISynth {
        public int synth_1to1_mono_ptr(MPGLib.mpstr_tag var1, float[] var2, int var3, float[] var4, MPGLib.ProcessedBytes var5);

        public int synth_1to1_ptr(MPGLib.mpstr_tag var1, float[] var2, int var3, int var4, float[] var5, MPGLib.ProcessedBytes var6);
    }
}

