/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import java.util.Arrays;
import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.LongBlockConstrain;
import net.sourceforge.lame.mp3.QuantizePVT;
import net.sourceforge.lame.mp3.ShortBlockConstrain;
import net.sourceforge.lame.mp3.Takehiro;

public class VBRQuantize {
    protected static final int[] max_range_short = new int[]{15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 0, 0};
    protected static final int[] max_range_long = new int[]{15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0};
    protected static final int[] max_range_long_lsf_pretab = new int[]{7, 7, 7, 7, 7, 7, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    QuantizePVT qupvt;
    Takehiro tak;

    public final void setModules(QuantizePVT qupvt, Takehiro tk) {
        this.qupvt = qupvt;
        this.tak = tk;
    }

    private float max_x34(float[] xr34, int x34Pos, int bw) {
        float xfsf = 0.0f;
        int j = bw >> 1;
        int remaining = j & 1;
        j >>= 1;
        while (j > 0) {
            if (xfsf < xr34[x34Pos + 0]) {
                xfsf = xr34[x34Pos + 0];
            }
            if (xfsf < xr34[x34Pos + 1]) {
                xfsf = xr34[x34Pos + 1];
            }
            if (xfsf < xr34[x34Pos + 2]) {
                xfsf = xr34[x34Pos + 2];
            }
            if (xfsf < xr34[x34Pos + 3]) {
                xfsf = xr34[x34Pos + 3];
            }
            x34Pos += 4;
            --j;
        }
        if (remaining != 0) {
            if (xfsf < xr34[x34Pos + 0]) {
                xfsf = xr34[x34Pos + 0];
            }
            if (xfsf < xr34[x34Pos + 1]) {
                xfsf = xr34[x34Pos + 1];
            }
        }
        return xfsf;
    }

    private int findLowestScalefac(float xr34) {
        int sfOk = 255;
        int sf = 128;
        int delsf = 64;
        for (int i = 0; i < 8; ++i) {
            float xfsf = this.qupvt.ipow20[sf] * xr34;
            if (xfsf <= 8206.0f) {
                sfOk = sf;
                sf -= delsf;
            } else {
                sf += delsf;
            }
            delsf >>= 1;
        }
        return sfOk;
    }

    private int belowNoiseFloor(float[] xr, int xrPos, float l3xmin, int bw) {
        float sum = 0.0f;
        int i = 0;
        for (int j = bw; j > 0; --j) {
            float x = xr[xrPos + i];
            sum += x * x;
            ++i;
        }
        return (double)(l3xmin - sum) >= -1.0E-20 ? 1 : 0;
    }

    private void k_34_4(double[] x, int[] l3, int l3Pos) {
        assert (x[0] <= 8206.0 && x[1] <= 8206.0 && x[2] <= 8206.0 && x[3] <= 8206.0);
        l3[l3Pos + 0] = (int)x[0];
        l3[l3Pos + 1] = (int)x[1];
        l3[l3Pos + 2] = (int)x[2];
        l3[l3Pos + 3] = (int)x[3];
        x[0] = x[0] + (double)this.qupvt.adj43[l3[l3Pos + 0]];
        x[1] = x[1] + (double)this.qupvt.adj43[l3[l3Pos + 1]];
        x[2] = x[2] + (double)this.qupvt.adj43[l3[l3Pos + 2]];
        x[3] = x[3] + (double)this.qupvt.adj43[l3[l3Pos + 3]];
        l3[l3Pos + 0] = (int)x[0];
        l3[l3Pos + 1] = (int)x[1];
        l3[l3Pos + 2] = (int)x[2];
        l3[l3Pos + 3] = (int)x[3];
    }

    private void k_34_2(double[] x, int[] l3, int l3Pos) {
        assert (x[0] <= 8206.0 && x[1] <= 8206.0);
        l3[l3Pos + 0] = (int)x[0];
        l3[l3Pos + 1] = (int)x[1];
        x[0] = x[0] + (double)this.qupvt.adj43[l3[l3Pos + 0]];
        x[1] = x[1] + (double)this.qupvt.adj43[l3[l3Pos + 1]];
        l3[l3Pos + 0] = (int)x[0];
        l3[l3Pos + 1] = (int)x[1];
    }

    private float calc_sfb_noise_x34(float[] xr, float[] xr34, int xrPos, int bw, int sf) {
        double[] x = new double[4];
        int[] l3 = new int[4];
        float sfpow = this.qupvt.pow20[sf + 116];
        float sfpow34 = this.qupvt.ipow20[sf];
        float xfsf = 0.0f;
        int j = bw >> 1;
        int remaining = j & 1;
        j >>= 1;
        while (j > 0) {
            x[0] = sfpow34 * xr34[xrPos + 0];
            x[1] = sfpow34 * xr34[xrPos + 1];
            x[2] = sfpow34 * xr34[xrPos + 2];
            x[3] = sfpow34 * xr34[xrPos + 3];
            this.k_34_4(x, l3, 0);
            x[0] = Math.abs(xr[xrPos + 0]) - sfpow * this.qupvt.pow43[l3[0]];
            x[1] = Math.abs(xr[xrPos + 1]) - sfpow * this.qupvt.pow43[l3[1]];
            x[2] = Math.abs(xr[xrPos + 2]) - sfpow * this.qupvt.pow43[l3[2]];
            x[3] = Math.abs(xr[xrPos + 3]) - sfpow * this.qupvt.pow43[l3[3]];
            xfsf = (float)((double)xfsf + (x[0] * x[0] + x[1] * x[1] + (x[2] * x[2] + x[3] * x[3])));
            xrPos += 4;
            --j;
        }
        if (remaining != 0) {
            x[0] = sfpow34 * xr34[xrPos + 0];
            x[1] = sfpow34 * xr34[xrPos + 1];
            this.k_34_2(x, l3, 0);
            x[0] = Math.abs(xr[xrPos + 0]) - sfpow * this.qupvt.pow43[l3[0]];
            x[1] = Math.abs(xr[xrPos + 1]) - sfpow * this.qupvt.pow43[l3[1]];
            xfsf = (float)((double)xfsf + (x[0] * x[0] + x[1] * x[1]));
        }
        return xfsf;
    }

    private boolean tri_calc_sfb_noise_x34(float[] xr, float[] xr34, int xrPos, float l3_xmin, int bw, int sf, CalcNoiseCache[] did_it) {
        int sf_x;
        if (did_it[sf].valid == 0) {
            did_it[sf].valid = 1;
            did_it[sf].value = this.calc_sfb_noise_x34(xr, xr34, xrPos, bw, sf);
        }
        if (l3_xmin < did_it[sf].value) {
            return true;
        }
        if (sf < 255) {
            sf_x = sf + 1;
            if (did_it[sf_x].valid == 0) {
                did_it[sf_x].valid = 1;
                did_it[sf_x].value = this.calc_sfb_noise_x34(xr, xr34, xrPos, bw, sf_x);
            }
            if (l3_xmin < did_it[sf_x].value) {
                return true;
            }
        }
        if (sf > 0) {
            sf_x = sf - 1;
            if (did_it[sf_x].valid == 0) {
                did_it[sf_x].valid = 1;
                did_it[sf_x].value = this.calc_sfb_noise_x34(xr, xr34, xrPos, bw, sf_x);
            }
            if (l3_xmin < did_it[sf_x].value) {
                return true;
            }
        }
        return false;
    }

    private int find_scalefac_x34(float[] xr, float[] xr34, int xrPos, float l3_xmin, int bw, int sf_min) {
        CalcNoiseCache[] did_it = new CalcNoiseCache[256];
        int sf = 128;
        int sf_ok = 255;
        int delsf = 128;
        int seen_good_one = 0;
        for (int j = 0; j < did_it.length; ++j) {
            did_it[j] = new CalcNoiseCache();
        }
        for (int i = 0; i < 8; ++i) {
            delsf >>= 1;
            if (sf <= sf_min) {
                sf += delsf;
                continue;
            }
            boolean bad = this.tri_calc_sfb_noise_x34(xr, xr34, xrPos, l3_xmin, bw, sf, did_it);
            if (bad) {
                sf -= delsf;
                continue;
            }
            sf_ok = sf;
            sf += delsf;
            seen_good_one = 1;
        }
        if (seen_good_one > 0) {
            return sf_ok;
        }
        if (sf <= sf_min) {
            return sf_min;
        }
        return sf;
    }

    private int block_sf(algo_t that, float[] l3_xmin, int[] vbrsf, int[] vbrsfmin) {
        int w;
        float[] xr = that.cod_info.xr;
        float[] xr34_orig = that.xr34orig;
        int[] width = that.cod_info.width;
        int max_nonzero_coeff = that.cod_info.max_nonzero_coeff;
        int maxsf = 0;
        int sfb = 0;
        int i = 0;
        int psymax = that.cod_info.psymax;
        assert (that.cod_info.max_nonzero_coeff >= 0);
        that.mingain_l = 0;
        that.mingain_s[0] = 0;
        that.mingain_s[1] = 0;
        that.mingain_s[2] = 0;
        for (int j = 0; j <= max_nonzero_coeff; j += w) {
            int m2;
            int m1;
            w = width[sfb];
            int l = w;
            int m = max_nonzero_coeff - j + 1;
            if (l > m) {
                l = m;
            }
            float max_xr34 = this.max_x34(xr34_orig, j, l);
            vbrsfmin[sfb] = m1 = this.findLowestScalefac(max_xr34);
            if (that.mingain_l < m1) {
                that.mingain_l = m1;
            }
            if (that.mingain_s[i] < m1) {
                that.mingain_s[i] = m1;
            }
            if (++i > 2) {
                i = 0;
            }
            if (sfb < psymax) {
                if (this.belowNoiseFloor(xr, j, l3_xmin[sfb], l) == 0) {
                    m2 = this.find_scalefac_x34(xr, xr34_orig, j, l3_xmin[sfb], l, m1);
                    if (maxsf < m2) {
                        maxsf = m2;
                    }
                } else {
                    m2 = 255;
                    maxsf = 255;
                }
            } else {
                if (maxsf < m1) {
                    maxsf = m1;
                }
                m2 = maxsf;
            }
            vbrsf[sfb] = m2;
            ++sfb;
        }
        while (sfb < 39) {
            vbrsf[sfb] = maxsf;
            vbrsfmin[sfb] = 0;
            ++sfb;
        }
        return maxsf;
    }

    private final void quantize_x34(algo_t that) {
        double[] x = new double[4];
        int xr34_orig = 0;
        GrInfo cod_info = that.cod_info;
        int ifqstep = cod_info.scalefac_scale == 0 ? 2 : 4;
        int l3 = 0;
        int j = 0;
        int sfb = 0;
        int max_nonzero_coeff = cod_info.max_nonzero_coeff;
        assert (cod_info.max_nonzero_coeff >= 0);
        assert (cod_info.max_nonzero_coeff < 576);
        while (j <= max_nonzero_coeff) {
            int s = (cod_info.scalefac[sfb] + (cod_info.preflag != 0 ? this.qupvt.pretab[sfb] : 0)) * ifqstep + cod_info.subblock_gain[cod_info.window[sfb]] * 8;
            int sfac = cod_info.global_gain - s;
            float sfpow34 = this.qupvt.ipow20[sfac];
            int w = cod_info.width[sfb];
            int m = max_nonzero_coeff - j + 1;
            int l = w;
            assert (cod_info.global_gain - s >= 0);
            assert (cod_info.width[sfb] >= 0);
            if (l > m) {
                l = m;
            }
            j += w;
            ++sfb;
            int remaining = (l >>= 1) & 1;
            l >>= 1;
            while (l > 0) {
                x[0] = sfpow34 * that.xr34orig[xr34_orig + 0];
                x[1] = sfpow34 * that.xr34orig[xr34_orig + 1];
                x[2] = sfpow34 * that.xr34orig[xr34_orig + 2];
                x[3] = sfpow34 * that.xr34orig[xr34_orig + 3];
                this.k_34_4(x, cod_info.l3_enc, l3);
                l3 += 4;
                xr34_orig += 4;
                --l;
            }
            if (remaining == 0) continue;
            x[0] = sfpow34 * that.xr34orig[xr34_orig + 0];
            x[1] = sfpow34 * that.xr34orig[xr34_orig + 1];
            this.k_34_2(x, cod_info.l3_enc, l3);
            l3 += 2;
            xr34_orig += 2;
        }
    }

    protected void set_subblock_gain(GrInfo cod_info, int[] mingain_s, int[] sf) {
        int sfb;
        int i;
        int maxrange1 = 15;
        int maxrange2 = 7;
        int ifqstepShift = cod_info.scalefac_scale == 0 ? 1 : 2;
        int[] sbg = cod_info.subblock_gain;
        int psymax = cod_info.psymax;
        int psydiv = 18;
        int min_sbg = 7;
        if (psydiv > psymax) {
            psydiv = psymax;
        }
        for (i = 0; i < 3; ++i) {
            int v;
            int maxsf1 = 0;
            int maxsf2 = 0;
            int minsf = 1000;
            for (sfb = i; sfb < psydiv; sfb += 3) {
                v = -sf[sfb];
                if (maxsf1 < v) {
                    maxsf1 = v;
                }
                if (minsf <= v) continue;
                minsf = v;
            }
            while (sfb < 39) {
                v = -sf[sfb];
                if (maxsf2 < v) {
                    maxsf2 = v;
                }
                if (minsf > v) {
                    minsf = v;
                }
                sfb += 3;
            }
            int m1 = maxsf1 - (15 << ifqstepShift);
            int m2 = maxsf2 - (7 << ifqstepShift);
            maxsf1 = Math.max(m1, m2);
            sbg[i] = minsf > 0 ? minsf >> 3 : 0;
            if (maxsf1 > 0) {
                m1 = sbg[i];
                m2 = maxsf1 + 7 >> 3;
                sbg[i] = Math.max(m1, m2);
            }
            if (sbg[i] > 0 && mingain_s[i] > cod_info.global_gain - sbg[i] * 8) {
                sbg[i] = cod_info.global_gain - mingain_s[i] >> 3;
            }
            if (sbg[i] > 7) {
                sbg[i] = 7;
            }
            if (min_sbg <= sbg[i]) continue;
            min_sbg = sbg[i];
        }
        int sbg0 = sbg[0] * 8;
        int sbg1 = sbg[1] * 8;
        int sbg2 = sbg[2] * 8;
        for (sfb = 0; sfb < 39; sfb += 3) {
            int n = sfb + 0;
            sf[n] = sf[n] + sbg0;
            int n2 = sfb + 1;
            sf[n2] = sf[n2] + sbg1;
            int n3 = sfb + 2;
            sf[n3] = sf[n3] + sbg2;
        }
        if (min_sbg > 0) {
            i = 0;
            while (i < 3) {
                int n = i++;
                sbg[n] = sbg[n] - min_sbg;
            }
            cod_info.global_gain -= min_sbg * 8;
        }
    }

    protected void set_scalefacs(GrInfo cod_info, int[] vbrsfmin, int[] sf, int[] max_range) {
        int sfb;
        int ifqstep = cod_info.scalefac_scale == 0 ? 2 : 4;
        int ifqstepShift = cod_info.scalefac_scale == 0 ? 1 : 2;
        int[] scalefac = cod_info.scalefac;
        int sfbmax = cod_info.sfbmax;
        int[] sbg = cod_info.subblock_gain;
        int[] window = cod_info.window;
        int preflag = cod_info.preflag;
        if (preflag != 0) {
            for (sfb = 11; sfb < sfbmax; ++sfb) {
                int n = sfb;
                sf[n] = sf[n] + this.qupvt.pretab[sfb] * ifqstep;
            }
        }
        for (sfb = 0; sfb < sfbmax; ++sfb) {
            int gain = cod_info.global_gain - sbg[window[sfb]] * 8 - (preflag != 0 ? this.qupvt.pretab[sfb] : 0) * ifqstep;
            if (sf[sfb] < 0) {
                int m = gain - vbrsfmin[sfb];
                scalefac[sfb] = ifqstep - 1 - sf[sfb] >> ifqstepShift;
                if (scalefac[sfb] > max_range[sfb]) {
                    scalefac[sfb] = max_range[sfb];
                }
                if (scalefac[sfb] <= 0 || scalefac[sfb] << ifqstepShift <= m) continue;
                scalefac[sfb] = m >> ifqstepShift;
                continue;
            }
            scalefac[sfb] = 0;
        }
        for (sfb = sfbmax; sfb < 39; ++sfb) {
            scalefac[sfb] = 0;
        }
    }

    protected boolean checkScalefactor(GrInfo cod_info, int[] vbrsfmin) {
        int ifqstep = cod_info.scalefac_scale == 0 ? 2 : 4;
        for (int sfb = 0; sfb < cod_info.psymax; ++sfb) {
            int s = (cod_info.scalefac[sfb] + (cod_info.preflag != 0 ? this.qupvt.pretab[sfb] : 0)) * ifqstep + cod_info.subblock_gain[cod_info.window[sfb]] * 8;
            if (cod_info.global_gain - s >= vbrsfmin[sfb]) continue;
            return false;
        }
        return true;
    }

    private void bitcount(algo_t that) {
        boolean rc = that.gfc.mode_gr == 2 ? this.tak.scale_bitcount(that.cod_info) : this.tak.scale_bitcount_lsf(that.gfc, that.cod_info);
        if (!rc) {
            return;
        }
        throw new RuntimeException("INTERNAL ERROR IN VBR NEW CODE (986), please send bug report");
    }

    private int quantizeAndCountBits(algo_t that) {
        this.quantize_x34(that);
        that.cod_info.part2_3_length = this.tak.noquant_count_bits(that.gfc, that.cod_info, null);
        return that.cod_info.part2_3_length;
    }

    private int tryGlobalStepsize(algo_t that, int[] sfwork, int[] vbrsfmin, int delta) {
        float xrpow_max = that.cod_info.xrpow_max;
        int[] sftemp = new int[39];
        int vbrmax = 0;
        for (int i = 0; i < 39; ++i) {
            int gain = sfwork[i] + delta;
            if (gain < vbrsfmin[i]) {
                gain = vbrsfmin[i];
            }
            if (gain > 255) {
                gain = 255;
            }
            if (vbrmax < gain) {
                vbrmax = gain;
            }
            sftemp[i] = gain;
        }
        that.alloc.alloc(that, sftemp, vbrsfmin, vbrmax);
        this.bitcount(that);
        int nbits = this.quantizeAndCountBits(that);
        that.cod_info.xrpow_max = xrpow_max;
        return nbits;
    }

    private void searchGlobalStepsizeMax(algo_t that, int[] sfwork, int[] vbrsfmin, int target) {
        int gain;
        GrInfo cod_info = that.cod_info;
        int curr = gain = cod_info.global_gain;
        int gain_ok = 1024;
        int nbits = 100000;
        int l = gain;
        int r = 512;
        assert (gain >= 0);
        while (l <= r) {
            curr = l + r >> 1;
            nbits = this.tryGlobalStepsize(that, sfwork, vbrsfmin, curr - gain);
            if (nbits == 0 || nbits + cod_info.part2_length < target) {
                r = curr - 1;
                gain_ok = curr;
                continue;
            }
            l = curr + 1;
            if (gain_ok != 1024) continue;
            gain_ok = curr;
        }
        if (gain_ok != curr) {
            curr = gain_ok;
            nbits = this.tryGlobalStepsize(that, sfwork, vbrsfmin, curr - gain);
        }
    }

    private int sfDepth(int[] sfwork) {
        int m = 0;
        int j = 39;
        int i = 0;
        while (j > 0) {
            int di = 255 - sfwork[i];
            if (m < di) {
                m = di;
            }
            assert (sfwork[i] >= 0);
            assert (sfwork[i] <= 255);
            --j;
            ++i;
        }
        assert (m >= 0);
        assert (m <= 255);
        return m;
    }

    private void cutDistribution(int[] sfwork, int[] sf_out, int cut) {
        int j = 39;
        int i = 0;
        while (j > 0) {
            int x = sfwork[i];
            sf_out[i] = x < cut ? x : cut;
            --j;
            ++i;
        }
    }

    private int flattenDistribution(int[] sfwork, int[] sf_out, int dm, int k, int p) {
        int sfmax = 0;
        if (dm > 0) {
            int j = 39;
            int i = 0;
            while (j > 0) {
                int di = p - sfwork[i];
                int x = sfwork[i] + k * di / dm;
                if (x < 0) {
                    x = 0;
                } else if (x > 255) {
                    x = 255;
                }
                sf_out[i] = x;
                if (sfmax < x) {
                    sfmax = x;
                }
                --j;
                ++i;
            }
        } else {
            int j = 39;
            int i = 0;
            while (j > 0) {
                int x;
                sf_out[i] = x = sfwork[i];
                if (sfmax < x) {
                    sfmax = x;
                }
                --j;
                ++i;
            }
        }
        return sfmax;
    }

    private int tryThatOne(algo_t that, int[] sftemp, int[] vbrsfmin, int vbrmax) {
        float xrpow_max = that.cod_info.xrpow_max;
        int nbits = 100000;
        that.alloc.alloc(that, sftemp, vbrsfmin, vbrmax);
        this.bitcount(that);
        nbits = this.quantizeAndCountBits(that);
        that.cod_info.xrpow_max = xrpow_max;
        return nbits += that.cod_info.part2_length;
    }

    private void outOfBitsStrategy(algo_t that, int[] sfwork, int[] vbrsfmin, int target) {
        int sfmax;
        int nbits;
        int[] wrk = new int[39];
        int dm = this.sfDepth(sfwork);
        int p = that.cod_info.global_gain;
        int bi = dm / 2;
        int bi_ok = -1;
        int bu = 0;
        int bo = dm;
        while (true) {
            if ((nbits = this.tryThatOne(that, wrk, vbrsfmin, sfmax = this.flattenDistribution(sfwork, wrk, dm, bi, p))) <= target) {
                bi_ok = bi;
                bo = bi - 1;
            } else {
                bu = bi + 1;
            }
            if (bu > bo) break;
            bi = (bu + bo) / 2;
        }
        if (bi_ok >= 0) {
            if (bi != bi_ok) {
                sfmax = this.flattenDistribution(sfwork, wrk, dm, bi_ok, p);
                this.tryThatOne(that, wrk, vbrsfmin, sfmax);
            }
            return;
        }
        bi = (255 + p) / 2;
        bi_ok = -1;
        bu = p;
        bo = 255;
        while (true) {
            if ((nbits = this.tryThatOne(that, wrk, vbrsfmin, sfmax = this.flattenDistribution(sfwork, wrk, dm, dm, bi))) <= target) {
                bi_ok = bi;
                bo = bi - 1;
            } else {
                bu = bi + 1;
            }
            if (bu > bo) break;
            bi = (bu + bo) / 2;
        }
        if (bi_ok >= 0) {
            if (bi != bi_ok) {
                sfmax = this.flattenDistribution(sfwork, wrk, dm, dm, bi_ok);
                this.tryThatOne(that, wrk, vbrsfmin, sfmax);
            }
            return;
        }
        this.searchGlobalStepsizeMax(that, wrk, vbrsfmin, target);
    }

    private int reduce_bit_usage(LameInternalFlags gfc, int gr, int ch) {
        GrInfo cod_info = gfc.l3_side.tt[gr][ch];
        this.tak.best_scalefac_store(gfc, gr, ch, gfc.l3_side);
        if (gfc.use_best_huffman == 1) {
            this.tak.best_huffman_divide(gfc, cod_info);
        }
        return cod_info.part2_3_length + cod_info.part2_length;
    }

    public int VBR_encode_frame(LameInternalFlags gfc, float[][][] xr34orig, float[][][] l3_xmin, int[][] max_bits) {
        int ch;
        int gr;
        boolean ok;
        algo_t that;
        int ch2;
        int gr2;
        int[][][] sfwork_ = new int[2][2][39];
        int[][][] vbrsfmin_ = new int[2][2][39];
        algo_t[][] that_ = new algo_t[2][2];
        int ngr = gfc.mode_gr;
        int nch = gfc.channels_out;
        int[][] max_nbits_ch = new int[2][2];
        int[] max_nbits_gr = new int[2];
        int max_nbits_fr = 0;
        int[][] use_nbits_ch = new int[2][2];
        int[] use_nbits_gr = new int[2];
        int use_nbits_fr = 0;
        for (gr2 = 0; gr2 < ngr; ++gr2) {
            max_nbits_gr[gr2] = 0;
            for (ch2 = 0; ch2 < nch; ++ch2) {
                max_nbits_ch[gr2][ch2] = max_bits[gr2][ch2];
                use_nbits_ch[gr2][ch2] = 0;
                int n = gr2;
                max_nbits_gr[n] = max_nbits_gr[n] + max_bits[gr2][ch2];
                max_nbits_fr += max_bits[gr2][ch2];
                that_[gr2][ch2] = new algo_t();
                that_[gr2][ch2].gfc = gfc;
                that_[gr2][ch2].cod_info = gfc.l3_side.tt[gr2][ch2];
                that_[gr2][ch2].xr34orig = xr34orig[gr2][ch2];
                that_[gr2][ch2].alloc = that_[gr2][ch2].cod_info.block_type == 2 ? new ShortBlockConstrain(this) : new LongBlockConstrain(this);
            }
        }
        for (gr2 = 0; gr2 < ngr; ++gr2) {
            for (ch2 = 0; ch2 < nch; ++ch2) {
                if (max_bits[gr2][ch2] <= 0) continue;
                that = that_[gr2][ch2];
                int[] sfwork = sfwork_[gr2][ch2];
                int[] vbrsfmin = vbrsfmin_[gr2][ch2];
                int vbrmax = this.block_sf(that, l3_xmin[gr2][ch2], sfwork, vbrsfmin);
                that.alloc.alloc(that, sfwork, vbrsfmin, vbrmax);
                this.bitcount(that);
            }
        }
        use_nbits_fr = 0;
        for (gr2 = 0; gr2 < ngr; ++gr2) {
            use_nbits_gr[gr2] = 0;
            for (ch2 = 0; ch2 < nch; ++ch2) {
                that = that_[gr2][ch2];
                if (max_bits[gr2][ch2] > 0) {
                    int max_nonzero_coeff = that.cod_info.max_nonzero_coeff;
                    assert (max_nonzero_coeff < 576);
                    Arrays.fill(that.cod_info.l3_enc, max_nonzero_coeff, 576, 0);
                    this.quantizeAndCountBits(that);
                }
                use_nbits_ch[gr2][ch2] = this.reduce_bit_usage(gfc, gr2, ch2);
                int n = gr2;
                use_nbits_gr[n] = use_nbits_gr[n] + use_nbits_ch[gr2][ch2];
            }
            use_nbits_fr += use_nbits_gr[gr2];
        }
        if (use_nbits_fr <= max_nbits_fr) {
            ok = true;
            for (int gr3 = 0; gr3 < ngr; ++gr3) {
                if (use_nbits_gr[gr3] > 7680) {
                    ok = false;
                }
                for (int ch3 = 0; ch3 < nch; ++ch3) {
                    if (use_nbits_ch[gr3][ch3] <= 4095) continue;
                    ok = false;
                }
            }
            if (ok) {
                return use_nbits_fr;
            }
        }
        ok = true;
        int sum_fr = 0;
        for (gr = 0; gr < ngr; ++gr) {
            max_nbits_gr[gr] = 0;
            for (int ch4 = 0; ch4 < nch; ++ch4) {
                max_nbits_ch[gr][ch4] = use_nbits_ch[gr][ch4] > 4095 ? 4095 : use_nbits_ch[gr][ch4];
                int n = gr;
                max_nbits_gr[n] = max_nbits_gr[n] + max_nbits_ch[gr][ch4];
            }
            if (max_nbits_gr[gr] > 7680) {
                float[] f = new float[2];
                float s = 0.0f;
                for (ch = 0; ch < nch; ++ch) {
                    if (max_nbits_ch[gr][ch] > 0) {
                        f[ch] = (float)Math.sqrt(Math.sqrt(max_nbits_ch[gr][ch]));
                        s += f[ch];
                        continue;
                    }
                    f[ch] = 0.0f;
                }
                for (ch = 0; ch < nch; ++ch) {
                    max_nbits_ch[gr][ch] = s > 0.0f ? (int)(7680.0f * f[ch] / s) : 0;
                }
                if (nch > 1) {
                    if (max_nbits_ch[gr][0] > use_nbits_ch[gr][0] + 32) {
                        int[] nArray = max_nbits_ch[gr];
                        nArray[1] = nArray[1] + max_nbits_ch[gr][0];
                        int[] nArray2 = max_nbits_ch[gr];
                        nArray2[1] = nArray2[1] - (use_nbits_ch[gr][0] + 32);
                        max_nbits_ch[gr][0] = use_nbits_ch[gr][0] + 32;
                    }
                    if (max_nbits_ch[gr][1] > use_nbits_ch[gr][1] + 32) {
                        int[] nArray = max_nbits_ch[gr];
                        nArray[0] = nArray[0] + max_nbits_ch[gr][1];
                        int[] nArray3 = max_nbits_ch[gr];
                        nArray3[0] = nArray3[0] - (use_nbits_ch[gr][1] + 32);
                        max_nbits_ch[gr][1] = use_nbits_ch[gr][1] + 32;
                    }
                    if (max_nbits_ch[gr][0] > 4095) {
                        max_nbits_ch[gr][0] = 4095;
                    }
                    if (max_nbits_ch[gr][1] > 4095) {
                        max_nbits_ch[gr][1] = 4095;
                    }
                }
                max_nbits_gr[gr] = 0;
                for (ch = 0; ch < nch; ++ch) {
                    int n = gr;
                    max_nbits_gr[n] = max_nbits_gr[n] + max_nbits_ch[gr][ch];
                }
            }
            sum_fr += max_nbits_gr[gr];
        }
        if (sum_fr > max_nbits_fr) {
            int gr4;
            float[] f = new float[2];
            float s = 0.0f;
            for (gr4 = 0; gr4 < ngr; ++gr4) {
                if (max_nbits_gr[gr4] > 0) {
                    f[gr4] = (float)Math.sqrt(max_nbits_gr[gr4]);
                    s += f[gr4];
                    continue;
                }
                f[gr4] = 0.0f;
            }
            for (gr4 = 0; gr4 < ngr; ++gr4) {
                max_nbits_gr[gr4] = s > 0.0f ? (int)((float)max_nbits_fr * f[gr4] / s) : 0;
            }
            if (ngr > 1) {
                if (max_nbits_gr[0] > use_nbits_gr[0] + 125) {
                    max_nbits_gr[1] = max_nbits_gr[1] + max_nbits_gr[0];
                    max_nbits_gr[1] = max_nbits_gr[1] - (use_nbits_gr[0] + 125);
                    max_nbits_gr[0] = use_nbits_gr[0] + 125;
                }
                if (max_nbits_gr[1] > use_nbits_gr[1] + 125) {
                    max_nbits_gr[0] = max_nbits_gr[0] + max_nbits_gr[1];
                    max_nbits_gr[0] = max_nbits_gr[0] - (use_nbits_gr[1] + 125);
                    max_nbits_gr[1] = use_nbits_gr[1] + 125;
                }
                for (int gr5 = 0; gr5 < ngr; ++gr5) {
                    if (max_nbits_gr[gr5] <= 7680) continue;
                    max_nbits_gr[gr5] = 7680;
                }
            }
            for (gr = 0; gr < ngr; ++gr) {
                float[] f2 = new float[2];
                float s2 = 0.0f;
                for (ch = 0; ch < nch; ++ch) {
                    if (max_nbits_ch[gr][ch] > 0) {
                        f2[ch] = (float)Math.sqrt(max_nbits_ch[gr][ch]);
                        s2 += f2[ch];
                        continue;
                    }
                    f2[ch] = 0.0f;
                }
                for (ch = 0; ch < nch; ++ch) {
                    max_nbits_ch[gr][ch] = s2 > 0.0f ? (int)((float)max_nbits_gr[gr] * f2[ch] / s2) : 0;
                }
                if (nch <= 1) continue;
                if (max_nbits_ch[gr][0] > use_nbits_ch[gr][0] + 32) {
                    int[] nArray = max_nbits_ch[gr];
                    nArray[1] = nArray[1] + max_nbits_ch[gr][0];
                    int[] nArray4 = max_nbits_ch[gr];
                    nArray4[1] = nArray4[1] - (use_nbits_ch[gr][0] + 32);
                    max_nbits_ch[gr][0] = use_nbits_ch[gr][0] + 32;
                }
                if (max_nbits_ch[gr][1] > use_nbits_ch[gr][1] + 32) {
                    int[] nArray = max_nbits_ch[gr];
                    nArray[0] = nArray[0] + max_nbits_ch[gr][1];
                    int[] nArray5 = max_nbits_ch[gr];
                    nArray5[0] = nArray5[0] - (use_nbits_ch[gr][1] + 32);
                    max_nbits_ch[gr][1] = use_nbits_ch[gr][1] + 32;
                }
                for (ch = 0; ch < nch; ++ch) {
                    if (max_nbits_ch[gr][ch] <= 4095) continue;
                    max_nbits_ch[gr][ch] = 4095;
                }
            }
        }
        sum_fr = 0;
        for (gr = 0; gr < ngr; ++gr) {
            int sum_gr = 0;
            for (int ch5 = 0; ch5 < nch; ++ch5) {
                sum_gr += max_nbits_ch[gr][ch5];
                if (max_nbits_ch[gr][ch5] <= 4095) continue;
                ok = false;
            }
            sum_fr += sum_gr;
            if (sum_gr <= 7680) continue;
            ok = false;
        }
        if (sum_fr > max_nbits_fr) {
            ok = false;
        }
        if (!ok) {
            for (gr = 0; gr < ngr; ++gr) {
                for (int ch6 = 0; ch6 < nch; ++ch6) {
                    max_nbits_ch[gr][ch6] = max_bits[gr][ch6];
                }
            }
        }
        for (int ch7 = 0; ch7 < nch; ++ch7) {
            gfc.l3_side.scfsi[ch7][0] = 0;
            gfc.l3_side.scfsi[ch7][1] = 0;
            gfc.l3_side.scfsi[ch7][2] = 0;
            gfc.l3_side.scfsi[ch7][3] = 0;
        }
        for (gr2 = 0; gr2 < ngr; ++gr2) {
            for (ch2 = 0; ch2 < nch; ++ch2) {
                gfc.l3_side.tt[gr2][ch2].scalefac_compress = 0;
            }
        }
        use_nbits_fr = 0;
        for (gr2 = 0; gr2 < ngr; ++gr2) {
            use_nbits_gr[gr2] = 0;
            for (ch2 = 0; ch2 < nch; ++ch2) {
                algo_t that2 = that_[gr2][ch2];
                use_nbits_ch[gr2][ch2] = 0;
                if (max_bits[gr2][ch2] > 0) {
                    int[] sfwork = sfwork_[gr2][ch2];
                    int[] vbrsfmin = vbrsfmin_[gr2][ch2];
                    this.cutDistribution(sfwork, sfwork, that2.cod_info.global_gain);
                    this.outOfBitsStrategy(that2, sfwork, vbrsfmin, max_nbits_ch[gr2][ch2]);
                }
                use_nbits_ch[gr2][ch2] = this.reduce_bit_usage(gfc, gr2, ch2);
                assert (use_nbits_ch[gr2][ch2] <= max_nbits_ch[gr2][ch2]);
                int n = gr2;
                use_nbits_gr[n] = use_nbits_gr[n] + use_nbits_ch[gr2][ch2];
            }
            use_nbits_fr += use_nbits_gr[gr2];
        }
        if (use_nbits_fr <= max_nbits_fr) {
            return use_nbits_fr;
        }
        throw new RuntimeException(String.format("INTERNAL ERROR IN VBR NEW CODE (1313), please send bug report\nmaxbits=%d usedbits=%d\n", max_nbits_fr, use_nbits_fr));
    }

    protected static class CalcNoiseCache {
        int valid;
        float value;

        protected CalcNoiseCache() {
        }
    }

    protected static class algo_t {
        alloc_sf_f alloc;
        float[] xr34orig;
        LameInternalFlags gfc;
        GrInfo cod_info;
        int mingain_l;
        int[] mingain_s = new int[3];

        protected algo_t() {
        }
    }

    static interface alloc_sf_f {
        public void alloc(algo_t var1, int[] var2, int[] var3, int var4);
    }
}

