/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Scanner;
import net.sourceforge.lame.mp3.GenreListHandler;
import net.sourceforge.lame.mp3.GetAudio;
import net.sourceforge.lame.mp3.ID3Tag;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.MP3Data;
import net.sourceforge.lame.mp3.MPEGMode;
import net.sourceforge.lame.mp3.Presets;
import net.sourceforge.lame.mp3.ShortBlock;
import net.sourceforge.lame.mp3.Usage;
import net.sourceforge.lame.mp3.VbrMode;
import net.sourceforge.lame.mp3.Version;

public class Parse {
    private static boolean INTERNAL_OPTS = false;
    public boolean swapbytes = false;
    public int silent;
    public boolean embedded;
    public boolean brhist;
    public float update_interval;
    public int mp3_delay;
    public boolean mp3_delay_set;
    public boolean disable_wav_header;
    public boolean print_clipping_info;
    public boolean in_signed = true;
    public ByteOrder in_endian = ByteOrder.LITTLE_ENDIAN;
    public int in_bitwidth = 16;
    ID3Tag id3;
    Presets pre;
    private Usage usage = new Usage();
    private Version version = new Version();
    private GetAudio.SoundFileFormat inputFormat;
    private boolean ignore_tag_errors;
    private MP3Data mp3InputData = new MP3Data();

    public final void setModules(ID3Tag id32, Presets pre2) {
        this.id3 = id32;
        this.pre = pre2;
    }

    public GetAudio.SoundFileFormat getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(GetAudio.SoundFileFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    public MP3Data getMp3InputData() {
        return this.mp3InputData;
    }

    public void setMp3InputData(MP3Data mp3InputData) {
        this.mp3InputData = mp3InputData;
    }

    private boolean set_id3tag(LameGlobalFlags gfp, int type, String str) {
        switch (type) {
            case 97: {
                this.id3.id3tag_set_artist(gfp, str);
                return false;
            }
            case 116: {
                this.id3.id3tag_set_title(gfp, str);
                return false;
            }
            case 108: {
                this.id3.id3tag_set_album(gfp, str);
                return false;
            }
            case 103: {
                this.id3.id3tag_set_genre(gfp, str);
                return false;
            }
            case 99: {
                this.id3.id3tag_set_comment(gfp, str);
                return false;
            }
            case 110: {
                this.id3.id3tag_set_track(gfp, str);
                return false;
            }
            case 121: {
                this.id3.id3tag_set_year(gfp, str);
                return false;
            }
            case 118: {
                this.id3.id3tag_set_fieldvalue(gfp, str);
                return false;
            }
        }
        return false;
    }

    private boolean set_id3v2tag(LameGlobalFlags gfp, int type, String str) {
        switch (type) {
            case 97: {
                this.id3.id3tag_set_textinfo_ucs2(gfp, "TPE1", str);
                return false;
            }
            case 116: {
                this.id3.id3tag_set_textinfo_ucs2(gfp, "TIT2", str);
                return false;
            }
            case 108: {
                this.id3.id3tag_set_textinfo_ucs2(gfp, "TALB", str);
                return false;
            }
            case 103: {
                this.id3.id3tag_set_textinfo_ucs2(gfp, "TCON", str);
                return false;
            }
            case 99: {
                this.id3.id3tag_set_comment(gfp, null, null, str, 0);
                return false;
            }
            case 110: {
                this.id3.id3tag_set_textinfo_ucs2(gfp, "TRCK", str);
                return false;
            }
        }
        return false;
    }

    private boolean id3_tag(LameGlobalFlags gfp, int type, TextEncoding enc, String str) {
        boolean result;
        String x = null;
        switch (enc) {
            default: {
                x = str;
                break;
            }
            case TENC_LATIN1: {
                x = str;
                break;
            }
            case TENC_UCS2: {
                x = str;
            }
        }
        switch (enc) {
            default: {
                result = this.set_id3tag(gfp, type, x);
                break;
            }
            case TENC_UCS2: {
                result = this.set_id3v2tag(gfp, type, x);
            }
        }
        return result;
    }

    private int presets_set(LameGlobalFlags gfp, int fast, int cbr, String preset_name, String ProgramName) {
        boolean mono = false;
        if (preset_name.equals("help") && fast < 1 && cbr < 1) {
            System.out.println(this.version.getVersion());
            System.out.println();
            this.usage.printPresets(System.out);
            return -1;
        }
        if (preset_name.equals("phone")) {
            preset_name = "16";
            mono = true;
        }
        if (preset_name.equals("phon+") || preset_name.equals("lw") || preset_name.equals("mw-eu") || preset_name.equals("sw")) {
            preset_name = "24";
            mono = true;
        }
        if (preset_name.equals("mw-us")) {
            preset_name = "40";
            mono = true;
        }
        if (preset_name.equals("voice")) {
            preset_name = "56";
            mono = true;
        }
        if (preset_name.equals("fm")) {
            preset_name = "112";
        }
        if (preset_name.equals("radio") || preset_name.equals("tape")) {
            preset_name = "112";
        }
        if (preset_name.equals("hifi")) {
            preset_name = "160";
        }
        if (preset_name.equals("cd")) {
            preset_name = "192";
        }
        if (preset_name.equals("studio")) {
            preset_name = "256";
        }
        if (preset_name.equals("medium")) {
            this.pre.lame_set_VBR_q(gfp, 4);
            if (fast > 0) {
                gfp.setVBR(VbrMode.vbr_mtrh);
            } else {
                gfp.setVBR(VbrMode.vbr_rh);
            }
            return 0;
        }
        if (preset_name.equals("standard")) {
            this.pre.lame_set_VBR_q(gfp, 2);
            if (fast > 0) {
                gfp.setVBR(VbrMode.vbr_mtrh);
            } else {
                gfp.setVBR(VbrMode.vbr_rh);
            }
            return 0;
        }
        if (preset_name.equals("extreme")) {
            this.pre.lame_set_VBR_q(gfp, 0);
            if (fast > 0) {
                gfp.setVBR(VbrMode.vbr_mtrh);
            } else {
                gfp.setVBR(VbrMode.vbr_rh);
            }
            return 0;
        }
        if (preset_name.equals("insane") && fast < 1) {
            gfp.preset = 1003;
            this.pre.apply_preset(gfp, 1003, 1);
            return 0;
        }
        if (Integer.valueOf(preset_name) > 0 && fast < 1) {
            if (Integer.valueOf(preset_name) >= 8 && Integer.valueOf(preset_name) <= 320) {
                gfp.preset = Integer.valueOf(preset_name);
                this.pre.apply_preset(gfp, Integer.valueOf(preset_name), 1);
                if (cbr == 1) {
                    gfp.setVBR(VbrMode.vbr_off);
                }
                if (mono) {
                    gfp.setMode(MPEGMode.MONO);
                }
                return 0;
            }
            System.err.println(this.version.getVersion());
            System.err.println();
            System.err.printf("Error: The bitrate specified is out of the valid range for this preset\n\nWhen using this mode you must enter a value between \"32\" and \"320\"\n\nFor further information try: \"%s --preset help\"\n", ProgramName);
            return -1;
        }
        System.err.println(this.version.getVersion());
        System.err.println();
        System.err.printf("Error: You did not enter a valid profile and/or options with --preset\n\nAvailable profiles are:\n\n   <fast>        medium\n   <fast>        standard\n   <fast>        extreme\n                 insane\n          <cbr> (ABR Mode) - The ABR Mode is implied. To use it,\n                             simply specify a bitrate. For example:\n                             \"--preset 185\" activates this\n                             preset and uses 185 as an average kbps.\n\n", new Object[0]);
        System.err.printf("    Some examples:\n\n or \"%s --preset fast standard <input file> <output file>\"\n or \"%s --preset cbr 192 <input file> <output file>\"\n or \"%s --preset 172 <input file> <output file>\"\n or \"%s --preset extreme <input file> <output file>\"\n\nFor further information try: \"%s --preset help\"\n", ProgramName, ProgramName, ProgramName, ProgramName, ProgramName);
        return -1;
    }

    private GetAudio.SoundFileFormat filename_to_type(String FileName) {
        int len = FileName.length();
        if (len < 4) {
            return GetAudio.SoundFileFormat.sf_unknown;
        }
        if ((FileName = FileName.substring(len - 4)).equalsIgnoreCase(".mpg")) {
            return GetAudio.SoundFileFormat.sf_mp123;
        }
        if (FileName.equalsIgnoreCase(".mp1")) {
            return GetAudio.SoundFileFormat.sf_mp123;
        }
        if (FileName.equalsIgnoreCase(".mp2")) {
            return GetAudio.SoundFileFormat.sf_mp123;
        }
        if (FileName.equalsIgnoreCase(".mp3")) {
            return GetAudio.SoundFileFormat.sf_mp123;
        }
        if (FileName.equalsIgnoreCase(".wav")) {
            return GetAudio.SoundFileFormat.sf_wave;
        }
        if (FileName.equalsIgnoreCase(".aif")) {
            return GetAudio.SoundFileFormat.sf_aiff;
        }
        if (FileName.equalsIgnoreCase(".raw")) {
            return GetAudio.SoundFileFormat.sf_raw;
        }
        if (FileName.equalsIgnoreCase(".ogg")) {
            return GetAudio.SoundFileFormat.sf_ogg;
        }
        return GetAudio.SoundFileFormat.sf_unknown;
    }

    private int resample_rate(double freq) {
        if (freq >= 1000.0) {
            freq *= 0.001;
        }
        switch ((int)freq) {
            case 8: {
                return 8000;
            }
            case 11: {
                return 11025;
            }
            case 12: {
                return 12000;
            }
            case 16: {
                return 16000;
            }
            case 22: {
                return 22050;
            }
            case 24: {
                return 24000;
            }
            case 32: {
                return 32000;
            }
            case 44: {
                return 44100;
            }
            case 48: {
                return 48000;
            }
        }
        System.err.printf("Illegal resample frequency: %.3f kHz\n", freq);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int set_id3_albumart(LameGlobalFlags gfp, String file_name) {
        int ret = -1;
        RandomAccessFile fpi = null;
        if (file_name == null) {
            return 0;
        }
        try {
            fpi = new RandomAccessFile(file_name, "r");
            try {
                int size = (int)(fpi.length() & Integer.MAX_VALUE);
                byte[] albumart = new byte[size];
                fpi.readFully(albumart);
                ret = this.id3.id3tag_set_albumart(gfp, albumart, size) ? 0 : 4;
            }
            catch (IOException e) {
                ret = 3;
            }
            finally {
                try {
                    fpi.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e1) {
            ret = 1;
        }
        switch (ret) {
            case 1: {
                System.err.printf("Could not find: '%s'.\n", file_name);
                break;
            }
            case 2: {
                System.err.printf("Insufficient memory for reading the albumart.\n", new Object[0]);
                break;
            }
            case 3: {
                System.err.printf("Read error: '%s'.\n", file_name);
                break;
            }
            case 4: {
                System.err.printf("Unsupported image: '%s'.\nSpecify JPEG/PNG/GIF image (128KB maximum)\n", file_name);
                break;
            }
        }
        return ret;
    }

    public int parse_args(LameGlobalFlags gfp, ArrayList<String> argv, StringBuilder inPath, StringBuilder outPath, String[] nogap_inPath, NoGap ng) {
        boolean input_file = false;
        boolean autoconvert = false;
        boolean nogap = false;
        boolean nogap_tags = false;
        String ProgramName = "lame";
        int count_nogap = 0;
        boolean noreplaygain = false;
        ID3TAG_MODE id3tag_mode = ID3TAG_MODE.ID3TAG_MODE_DEFAULT;
        inPath.setLength(0);
        outPath.setLength(0);
        this.silent = 0;
        this.embedded = false;
        this.ignore_tag_errors = false;
        this.brhist = true;
        this.mp3_delay = 0;
        this.mp3_delay_set = false;
        this.print_clipping_info = false;
        this.disable_wav_header = false;
        this.id3.init(gfp);
        for (int i = 0; i < argv.size(); ++i) {
            block328: {
                Throwable throwable;
                double val;
                String nextArg;
                int tokenPos = 0;
                String token = argv.get(i);
                if (token.charAt(tokenPos++) != '-') break block328;
                int argUsed = 0;
                String string = nextArg = i + 1 < argv.size() ? argv.get(i + 1) : "";
                if (token.length() - tokenPos == 0) {
                    input_file = true;
                    if (inPath.length() == 0) {
                        inPath.setLength(0);
                        inPath.append(argv.get(i));
                    } else if (outPath.length() == 0) {
                        outPath.setLength(0);
                        outPath.append(argv.get(i));
                    }
                }
                if (token.charAt(tokenPos) == '-') {
                    if (token.substring(++tokenPos).equalsIgnoreCase("resample")) {
                        argUsed = 1;
                        gfp.setOutSampleRate(this.resample_rate(Double.parseDouble(nextArg)));
                    } else if (token.substring(tokenPos).equalsIgnoreCase("vbr-old")) {
                        gfp.setVBR(VbrMode.vbr_rh);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("vbr-new")) {
                        gfp.setVBR(VbrMode.vbr_mtrh);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("vbr-mtrh")) {
                        gfp.setVBR(VbrMode.vbr_mtrh);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("cbr")) {
                        gfp.setVBR(VbrMode.vbr_off);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("abr")) {
                        argUsed = 1;
                        gfp.setVBR(VbrMode.vbr_abr);
                        gfp.VBR_mean_bitrate_kbps = Integer.valueOf(nextArg);
                        if (gfp.VBR_mean_bitrate_kbps >= 8000) {
                            gfp.VBR_mean_bitrate_kbps = (gfp.VBR_mean_bitrate_kbps + 500) / 1000;
                        }
                        gfp.VBR_mean_bitrate_kbps = Math.min(gfp.VBR_mean_bitrate_kbps, 320);
                        gfp.VBR_mean_bitrate_kbps = Math.max(gfp.VBR_mean_bitrate_kbps, 8);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("r3mix")) {
                        gfp.preset = 1000;
                        this.pre.apply_preset(gfp, 1000, 1);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("bitwidth")) {
                        argUsed = 1;
                        this.in_bitwidth = Integer.valueOf(nextArg);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("signed")) {
                        this.in_signed = true;
                    } else if (token.substring(tokenPos).equalsIgnoreCase("unsigned")) {
                        this.in_signed = false;
                    } else if (token.substring(tokenPos).equalsIgnoreCase("little-endian")) {
                        this.in_endian = ByteOrder.LITTLE_ENDIAN;
                    } else if (token.substring(tokenPos).equalsIgnoreCase("big-endian")) {
                        this.in_endian = ByteOrder.BIG_ENDIAN;
                    } else if (token.substring(tokenPos).equalsIgnoreCase("mp1input")) {
                        this.setInputFormat(GetAudio.SoundFileFormat.sf_mp1);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("mp2input")) {
                        this.setInputFormat(GetAudio.SoundFileFormat.sf_mp2);
                    } else if (token.substring(tokenPos).equalsIgnoreCase("mp3input")) {
                        this.setInputFormat(GetAudio.SoundFileFormat.sf_mp3);
                    } else {
                        if (token.substring(tokenPos).equalsIgnoreCase("ogginput")) {
                            System.err.printf("sorry, vorbis support in LAME is deprecated.\n", new Object[0]);
                            return -1;
                        }
                        if (token.substring(tokenPos).equalsIgnoreCase("phone")) {
                            if (this.presets_set(gfp, 0, 0, token, "lame") < 0) {
                                return -1;
                            }
                            System.err.printf("Warning: --phone is deprecated, use --preset phone instead!", new Object[0]);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("voice")) {
                            if (this.presets_set(gfp, 0, 0, token, "lame") < 0) {
                                return -1;
                            }
                            System.err.printf("Warning: --voice is deprecated, use --preset voice instead!", new Object[0]);
                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("noshort")) {
                            gfp.short_blocks = ShortBlock.short_block_dispensed;
                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("short")) {
                            gfp.short_blocks = ShortBlock.short_block_allowed;
                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("allshort")) {
                            gfp.short_blocks = ShortBlock.short_block_forced;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("decode")) {
                            gfp.decode_only = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("decode-mp3delay")) {
                            this.mp3_delay = Integer.valueOf(nextArg);
                            this.mp3_delay_set = true;
                            argUsed = 1;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("nores")) {
                            gfp.disable_reservoir = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("strictly-enforce-ISO")) {
                            gfp.strict_ISO = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("scale")) {
                            argUsed = 1;
                            gfp.scale = (float)Double.parseDouble(nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("scale-l")) {
                            argUsed = 1;
                            gfp.scale_left = (float)Double.parseDouble(nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("scale-r")) {
                            argUsed = 1;
                            gfp.scale_right = (float)Double.parseDouble(nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("freeformat")) {
                            gfp.free_format = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("replaygain-fast")) {
                            gfp.setFindReplayGain(true);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("replaygain-accurate")) {
                            gfp.decode_on_the_fly = true;
                            gfp.setFindReplayGain(true);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("noreplaygain")) {
                            noreplaygain = true;
                            gfp.setFindReplayGain(false);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("clipdetect")) {
                            this.print_clipping_info = true;
                            gfp.decode_on_the_fly = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("nohist")) {
                            this.brhist = false;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tt")) {
                            argUsed = 1;
                            this.id3_tag(gfp, 116, TextEncoding.TENC_RAW, nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("ta")) {
                            argUsed = 1;
                            this.id3_tag(gfp, 97, TextEncoding.TENC_RAW, nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tl")) {
                            argUsed = 1;
                            this.id3_tag(gfp, 108, TextEncoding.TENC_RAW, nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("ty")) {
                            argUsed = 1;
                            this.id3_tag(gfp, 121, TextEncoding.TENC_RAW, nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tc")) {
                            argUsed = 1;
                            this.id3_tag(gfp, 99, TextEncoding.TENC_RAW, nextArg);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tn")) {
                            boolean ret = this.id3_tag(gfp, 110, TextEncoding.TENC_RAW, nextArg);
                            argUsed = 1;
                            if (ret && !this.ignore_tag_errors) {
                                if (id3tag_mode == ID3TAG_MODE.ID3TAG_MODE_V1_ONLY) {
                                    System.err.printf("The track number has to be between 1 and 255 for ID3v1.\n", new Object[0]);
                                    return -1;
                                }
                                if (id3tag_mode != ID3TAG_MODE.ID3TAG_MODE_V2_ONLY && this.silent < 10) {
                                    System.err.printf("The track number has to be between 1 and 255 for ID3v1, ignored for ID3v1.\n", new Object[0]);
                                }
                            }
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tg")) {
                            this.id3_tag(gfp, 103, TextEncoding.TENC_RAW, nextArg);
                            argUsed = 1;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("tv")) {
                            argUsed = 1;
                            if (this.id3_tag(gfp, 118, TextEncoding.TENC_RAW, nextArg) && this.silent < 10) {
                                System.err.printf("Invalid field value: '%s'. Ignored\n", nextArg);
                            }
                        } else if (token.substring(tokenPos).equalsIgnoreCase("ti")) {
                            argUsed = 1;
                            if (this.set_id3_albumart(gfp, nextArg) != 0 && !this.ignore_tag_errors) {
                                return -1;
                            }
                        } else if (token.substring(tokenPos).equalsIgnoreCase("ignore-tag-errors")) {
                            this.ignore_tag_errors = true;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("add-id3v2")) {
                            this.id3.id3tag_add_v2(gfp);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("id3v1-only")) {
                            this.id3.id3tag_v1_only(gfp);
                            id3tag_mode = ID3TAG_MODE.ID3TAG_MODE_V1_ONLY;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("id3v2-only")) {
                            this.id3.id3tag_v2_only(gfp);
                            id3tag_mode = ID3TAG_MODE.ID3TAG_MODE_V2_ONLY;
                        } else if (token.substring(tokenPos).equalsIgnoreCase("space-id3v1")) {
                            this.id3.id3tag_space_v1(gfp);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("pad-id3v2")) {
                            this.id3.id3tag_pad_v2(gfp);
                        } else if (token.substring(tokenPos).equalsIgnoreCase("pad-id3v2-size")) {
                            int n = Integer.valueOf(nextArg);
                            n = n <= 128000 ? n : 128000;
                            n = n >= 0 ? n : 0;
                            this.id3.id3tag_set_pad(gfp, n);
                            argUsed = 1;
                        } else {
                            int k;
                            if (token.substring(tokenPos).equalsIgnoreCase("genre-list")) {
                                this.id3.id3tag_genre_list(new GenreListHandler(){

                                    @Override
                                    public void genre_list_handler(int num, String name) {
                                        System.out.printf("%3d %s\n", num, name);
                                    }
                                });
                                return -2;
                            }
                            if (token.substring(tokenPos).equalsIgnoreCase("lowpass")) {
                                val = Double.parseDouble(nextArg);
                                argUsed = 1;
                                if (val < 0.0) {
                                    gfp.lowpassfreq = -1;
                                } else {
                                    if (val < 0.001 || val > 50000.0) {
                                        System.err.printf("Must specify lowpass with --lowpass freq, freq >= 0.001 kHz\n", new Object[0]);
                                        return -1;
                                    }
                                    gfp.lowpassfreq = (int)(val * (val < 50.0 ? 1000.0 : 1.0) + 0.5);
                                }
                            } else if (token.substring(tokenPos).equalsIgnoreCase("lowpass-width")) {
                                val = Double.parseDouble(nextArg);
                                argUsed = 1;
                                if (val < 0.001 || val > 50000.0) {
                                    System.err.printf("Must specify lowpass width with --lowpass-width freq, freq >= 0.001 kHz\n", new Object[0]);
                                    return -1;
                                }
                                gfp.lowpassfreq = (int)(val * (val < 16.0 ? 1000.0 : 1.0) + 0.5);
                            } else if (token.substring(tokenPos).equalsIgnoreCase("highpass")) {
                                val = Double.parseDouble(nextArg);
                                argUsed = 1;
                                if (val < 0.0) {
                                    gfp.highpassfreq = -1;
                                } else {
                                    if (val < 0.001 || val > 50000.0) {
                                        System.err.printf("Must specify highpass with --highpass freq, freq >= 0.001 kHz\n", new Object[0]);
                                        return -1;
                                    }
                                    gfp.highpassfreq = (int)(val * (val < 16.0 ? 1000.0 : 1.0) + 0.5);
                                }
                            } else if (token.substring(tokenPos).equalsIgnoreCase("highpass-width")) {
                                val = Double.parseDouble(nextArg);
                                argUsed = 1;
                                if (val < 0.001 || val > 50000.0) {
                                    System.err.printf("Must specify highpass width with --highpass-width freq, freq >= 0.001 kHz\n", new Object[0]);
                                    return -1;
                                }
                                gfp.highpasswidth = (int)val;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("comp")) {
                                argUsed = 1;
                                val = Double.parseDouble(nextArg);
                                if (val < 1.0) {
                                    System.err.printf("Must specify compression ratio >= 1.0\n", new Object[0]);
                                    return -1;
                                }
                                gfp.compression_ratio = (float)val;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("notemp")) {
                                gfp.useTemporal = false;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("interch")) {
                                argUsed = 1;
                                gfp.interChRatio = (float)Double.parseDouble(nextArg);
                            } else if (token.substring(tokenPos).equalsIgnoreCase("temporal-masking")) {
                                argUsed = 1;
                                gfp.useTemporal = Integer.valueOf(nextArg) != 0;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("nssafejoint")) {
                                gfp.exp_nspsytune |= 2;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("nsmsfix")) {
                                argUsed = 1;
                                gfp.msfix = (float)Double.parseDouble(nextArg);
                            } else if (token.substring(tokenPos).equalsIgnoreCase("ns-bass")) {
                                argUsed = 1;
                                double d = Double.parseDouble(nextArg);
                                k = (int)(d * 4.0);
                                if (k < -32) {
                                    k = -32;
                                }
                                if (k > 31) {
                                    k = 31;
                                }
                                if (k < 0) {
                                    k += 64;
                                }
                                gfp.exp_nspsytune |= k << 2;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("ns-alto")) {
                                argUsed = 1;
                                double d = Double.parseDouble(nextArg);
                                k = (int)(d * 4.0);
                                if (k < -32) {
                                    k = -32;
                                }
                                if (k > 31) {
                                    k = 31;
                                }
                                if (k < 0) {
                                    k += 64;
                                }
                                gfp.exp_nspsytune |= k << 8;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("ns-treble")) {
                                argUsed = 1;
                                double d = Double.parseDouble(nextArg);
                                k = (int)(d * 4.0);
                                if (k < -32) {
                                    k = -32;
                                }
                                if (k > 31) {
                                    k = 31;
                                }
                                if (k < 0) {
                                    k += 64;
                                }
                                gfp.exp_nspsytune |= k << 14;
                            } else if (token.substring(tokenPos).equalsIgnoreCase("ns-sfb21")) {
                                argUsed = 1;
                                double d = Double.parseDouble(nextArg);
                                k = (int)(d * 4.0);
                                if (k < -32) {
                                    k = -32;
                                }
                                if (k > 31) {
                                    k = 31;
                                }
                                if (k < 0) {
                                    k += 64;
                                }
                                gfp.exp_nspsytune |= k << 20;
                            } else if (!token.substring(tokenPos).equalsIgnoreCase("nspsytune2")) {
                                if (token.substring(tokenPos).equalsIgnoreCase("quiet") || token.substring(tokenPos).equalsIgnoreCase("silent")) {
                                    this.silent = 10;
                                } else if (token.substring(tokenPos).equalsIgnoreCase("brief")) {
                                    this.silent = -5;
                                } else if (token.substring(tokenPos).equalsIgnoreCase("embedded")) {
                                    this.embedded = true;
                                } else if (token.substring(tokenPos).equalsIgnoreCase("verbose")) {
                                    this.silent = -10;
                                } else {
                                    if (token.substring(tokenPos).equalsIgnoreCase("version") || token.substring(tokenPos).equalsIgnoreCase("license")) {
                                        System.out.println(this.version.getVersion());
                                        System.out.println();
                                        this.usage.printLicense(System.out);
                                        return -2;
                                    }
                                    if (token.substring(tokenPos).equalsIgnoreCase("help") || token.substring(tokenPos).equalsIgnoreCase("usage")) {
                                        System.out.println(this.version.getVersion());
                                        System.out.println();
                                        this.usage.printShort(gfp, System.out);
                                        return -2;
                                    }
                                    if (token.substring(tokenPos).equalsIgnoreCase("longhelp")) {
                                        System.out.println(this.version.getVersion());
                                        System.out.println();
                                        this.usage.printLong(gfp, System.out);
                                        this.usage.printBitrates(System.out);
                                        return -2;
                                    }
                                    if (token.substring(tokenPos).equalsIgnoreCase("?")) {
                                        System.out.println(this.version.getVersion());
                                        System.out.println();
                                        this.usage.printLong(gfp, System.out);
                                        this.usage.printBitrates(System.out);
                                        return -2;
                                    }
                                    if (token.substring(tokenPos).equalsIgnoreCase("preset") || token.substring(tokenPos).equalsIgnoreCase("alt-preset")) {
                                        argUsed = 1;
                                        int fast = 0;
                                        int cbr = 0;
                                        while (nextArg.equals("fast") || nextArg.equals("cbr")) {
                                            if (nextArg.equals("fast") && fast < 1) {
                                                fast = 1;
                                            }
                                            if (nextArg.equals("cbr") && cbr < 1) {
                                                cbr = 1;
                                            }
                                            nextArg = i + ++argUsed < argv.size() ? argv.get(i + argUsed) : "";
                                        }
                                        if (this.presets_set(gfp, fast, cbr, nextArg, "lame") < 0) {
                                            return -1;
                                        }
                                    } else if (token.substring(tokenPos).equalsIgnoreCase("disptime")) {
                                        argUsed = 1;
                                        this.update_interval = (float)Double.parseDouble(nextArg);
                                    } else if (token.substring(tokenPos).equalsIgnoreCase("nogaptags")) {
                                        nogap_tags = true;
                                    } else if (token.substring(tokenPos).equalsIgnoreCase("nogapout")) {
                                        outPath.setLength(0);
                                        outPath.append(nextArg);
                                        argUsed = 1;
                                    } else if (token.substring(tokenPos).equalsIgnoreCase("nogap")) {
                                        nogap = true;
                                    } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("tune")) {
                                        argUsed = 1;
                                        gfp.tune_value_a = (float)Double.parseDouble(nextArg);
                                        gfp.tune = true;
                                    } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("shortthreshold")) {
                                        float y;
                                        float x;
                                        throwable = null;
                                        try (Scanner sc = new Scanner(nextArg);){
                                            x = sc.nextFloat();
                                            if (!sc.hasNext()) {
                                                y = x;
                                            } else {
                                                sc.nextByte();
                                                y = sc.nextFloat();
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        argUsed = 1;
                                        gfp.internal_flags.nsPsy.attackthre = x;
                                        gfp.internal_flags.nsPsy.attackthre_s = y;
                                    } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("maskingadjust")) {
                                        argUsed = 1;
                                        gfp.maskingadjust = (float)Double.parseDouble(nextArg);
                                    } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("maskingadjustshort")) {
                                        argUsed = 1;
                                        gfp.maskingadjust_short = (float)Double.parseDouble(nextArg);
                                    } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athcurve")) {
                                        argUsed = 1;
                                        gfp.ATHcurve = (float)Double.parseDouble(nextArg);
                                    } else if (!INTERNAL_OPTS || !token.substring(tokenPos).equalsIgnoreCase("no-preset-tune")) {
                                        if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("substep")) {
                                            argUsed = 1;
                                            gfp.internal_flags.substep_shaping = Integer.valueOf(nextArg);
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("sbgain")) {
                                            argUsed = 1;
                                            gfp.internal_flags.subblock_gain = Integer.valueOf(nextArg);
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("sfscale")) {
                                            gfp.internal_flags.noise_shaping = 2;
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("noath")) {
                                            gfp.noATH = true;
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athonly")) {
                                            gfp.ATHonly = true;
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athshort")) {
                                            gfp.ATHshort = true;
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athlower")) {
                                            argUsed = 1;
                                            gfp.ATHlower = -((float)Double.parseDouble(nextArg)) / 10.0f;
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athtype")) {
                                            argUsed = 1;
                                            gfp.ATHtype = Integer.valueOf(nextArg);
                                        } else if (INTERNAL_OPTS && token.substring(tokenPos).equalsIgnoreCase("athaa-type")) {
                                            argUsed = 1;
                                            gfp.athaa_type = Integer.valueOf(nextArg);
                                        } else if (token.substring(tokenPos).equalsIgnoreCase("athaa-sensitivity")) {
                                            argUsed = 1;
                                            gfp.athaa_sensitivity = (float)Double.parseDouble(nextArg);
                                        } else {
                                            System.err.printf("%s: unrecognized option --%s\n", "lame", token);
                                            return -1;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    i += argUsed;
                    continue;
                }
                while (tokenPos < token.length()) {
                    char c = token.charAt(tokenPos++);
                    String arg = tokenPos < token.length() ? token : nextArg;
                    block12 : switch (c) {
                        case 'm': {
                            argUsed = 1;
                            switch (arg.charAt(0)) {
                                case 's': {
                                    gfp.setMode(MPEGMode.STEREO);
                                    break block12;
                                }
                                case 'd': {
                                    gfp.setMode(MPEGMode.DUAL_CHANNEL);
                                    break block12;
                                }
                                case 'f': {
                                    gfp.force_ms = true;
                                }
                                case 'j': {
                                    gfp.setMode(MPEGMode.JOINT_STEREO);
                                    break block12;
                                }
                                case 'm': {
                                    gfp.setMode(MPEGMode.MONO);
                                    break block12;
                                }
                                case 'a': {
                                    gfp.setMode(MPEGMode.JOINT_STEREO);
                                    break block12;
                                }
                            }
                            System.err.printf("%s: -m mode must be s/d/j/f/m not %s\n", "lame", arg);
                            return -1;
                        }
                        case 'V': {
                            argUsed = 1;
                            if (gfp.getVBR() == VbrMode.vbr_off) {
                                gfp.setVBRQuality(VbrMode.vbr_default.ordinal());
                                gfp.VBR_q_frac = 0.0f;
                            }
                            gfp.setVBRQuality((int)Double.parseDouble(arg));
                            gfp.VBR_q_frac = (float)Double.parseDouble(arg) - (float)gfp.getVBRQuality();
                            break;
                        }
                        case 'v': {
                            if (gfp.getVBR() != VbrMode.vbr_off) break;
                            gfp.setVBR(VbrMode.vbr_mtrh);
                            break;
                        }
                        case 'q': {
                            argUsed = 1;
                            int tmp_quality = Integer.valueOf(arg);
                            if (tmp_quality < 0) {
                                tmp_quality = 0;
                            }
                            if (tmp_quality > 9) {
                                tmp_quality = 9;
                            }
                            gfp.setQuality(tmp_quality);
                            break;
                        }
                        case 'f': {
                            gfp.setQuality(7);
                            break;
                        }
                        case 'h': {
                            gfp.setQuality(2);
                            break;
                        }
                        case 's': {
                            argUsed = 1;
                            val = Double.parseDouble(arg);
                            gfp.setInSampleRate((int)(val * (val <= 192.0 ? 1000.0 : 1.0) + 0.5));
                            break;
                        }
                        case 'b': {
                            argUsed = 1;
                            gfp.setBitRate(Integer.valueOf(arg));
                            if (gfp.getBitRate() > 320) {
                                gfp.disable_reservoir = true;
                            }
                            gfp.VBR_min_bitrate_kbps = gfp.getBitRate();
                            break;
                        }
                        case 'B': {
                            argUsed = 1;
                            gfp.VBR_max_bitrate_kbps = Integer.valueOf(arg);
                            break;
                        }
                        case 'F': {
                            gfp.VBR_hard_min = 1;
                            break;
                        }
                        case 't': {
                            gfp.bWriteVbrTag = false;
                            this.disable_wav_header = true;
                            break;
                        }
                        case 'T': {
                            gfp.bWriteVbrTag = true;
                            nogap_tags = true;
                            this.disable_wav_header = false;
                            break;
                        }
                        case 'r': {
                            this.setInputFormat(GetAudio.SoundFileFormat.sf_raw);
                            break;
                        }
                        case 'x': {
                            this.swapbytes = true;
                            break;
                        }
                        case 'p': {
                            gfp.error_protection = true;
                            break;
                        }
                        case 'a': {
                            autoconvert = true;
                            gfp.setMode(MPEGMode.MONO);
                            break;
                        }
                        case 'S': {
                            this.silent = 10;
                            break;
                        }
                        case 'X': {
                            int y;
                            int x;
                            throwable = null;
                            try (Scanner sc = new Scanner(arg);){
                                x = sc.nextInt();
                                if (!sc.hasNext()) {
                                    y = x;
                                } else {
                                    sc.nextByte();
                                    y = sc.nextInt();
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            argUsed = 1;
                            if (!INTERNAL_OPTS) break;
                            gfp.quant_comp = x;
                            gfp.quant_comp_short = y;
                            break;
                        }
                        case 'Y': {
                            gfp.experimentalY = true;
                            break;
                        }
                        case 'Z': {
                            int n = 1;
                            try (Scanner sc = new Scanner(arg);){
                                n = sc.nextInt();
                            }
                            if (!INTERNAL_OPTS) break;
                            gfp.experimentalZ = n;
                            break;
                        }
                        case 'e': {
                            argUsed = 1;
                            switch (arg.charAt(0)) {
                                case 'n': {
                                    gfp.emphasis = 0;
                                    break block12;
                                }
                                case '5': {
                                    gfp.emphasis = 1;
                                    break block12;
                                }
                                case 'c': {
                                    gfp.emphasis = 3;
                                    break block12;
                                }
                            }
                            System.err.printf("%s: -e emp must be n/5/c not %s\n", "lame", arg);
                            return -1;
                        }
                        case 'c': {
                            gfp.copyright = 1;
                            break;
                        }
                        case 'o': {
                            gfp.original = 0;
                            break;
                        }
                        case '?': {
                            System.out.println(this.version.getVersion());
                            System.out.println();
                            this.usage.printLong(gfp, System.out);
                            this.usage.printBitrates(System.out);
                            return -1;
                        }
                        default: {
                            System.err.printf("%s: unrecognized option -%c\n", "lame", Character.valueOf(c));
                            return -1;
                        }
                    }
                    if (argUsed == 0) continue;
                    if (arg == token) {
                        token = "";
                    } else {
                        ++i;
                    }
                    arg = "";
                    argUsed = 0;
                }
                continue;
            }
            if (nogap) {
                if (ng != null && count_nogap < ng.num_nogap) {
                    nogap_inPath[count_nogap++] = argv.get(i);
                    input_file = true;
                    continue;
                }
                System.err.printf("Error: 'nogap option'.  Calling program does not allow nogap option, or\nyou have exceeded maximum number of input files for the nogap option\n", new Object[0]);
                ng.num_nogap = -1;
                return -1;
            }
            if (inPath.length() == 0) {
                inPath.setLength(0);
                inPath.append(argv.get(i));
                input_file = true;
                continue;
            }
            if (outPath.length() == 0) {
                outPath.setLength(0);
                outPath.append(argv.get(i));
                continue;
            }
            System.err.printf("%s: excess arg %s\n", "lame", argv.get(i));
            return -1;
        }
        if (!input_file) {
            System.out.println(this.version.getVersion());
            System.out.println();
            this.usage.print(System.out);
            return -1;
        }
        if (inPath.toString().charAt(0) == '-') {
            int n = this.silent = this.silent <= 1 ? 1 : this.silent;
        }
        if (outPath.length() == 0 && count_nogap == 0) {
            outPath.setLength(0);
            outPath.append(inPath.substring(0, inPath.length() - 4));
            if (gfp.decode_only) {
                outPath.append(".mp3.wav");
            } else {
                outPath.append(".mp3");
            }
        }
        if (!noreplaygain) {
            gfp.setFindReplayGain(true);
        }
        if (nogap && gfp.bWriteVbrTag && !nogap_tags) {
            System.out.println("Note: Disabling VBR Xing/Info tag since it interferes with --nogap\n");
            gfp.bWriteVbrTag = false;
        }
        if (outPath.toString().charAt(0) == '-') {
            gfp.bWriteVbrTag = false;
        }
        if (this.getInputFormat() == GetAudio.SoundFileFormat.sf_unknown) {
            this.setInputFormat(this.filename_to_type(inPath.toString()));
        }
        if (this.getInputFormat() == GetAudio.SoundFileFormat.sf_ogg) {
            System.err.printf("sorry, vorbis support in LAME is deprecated.\n", new Object[0]);
            return -1;
        }
        if (autoconvert) {
            gfp.setInNumChannels(2);
        } else if (MPEGMode.MONO == gfp.getMode()) {
            gfp.setInNumChannels(1);
        } else {
            gfp.setInNumChannels(2);
        }
        if (gfp.free_format && (gfp.getBitRate() < 8 || gfp.getBitRate() > 640)) {
            System.err.printf("For free format, specify a bitrate between 8 and 640 kbps\n", new Object[0]);
            System.err.printf("with the -b <bitrate> option\n", new Object[0]);
            return -1;
        }
        if (ng != null) {
            ng.num_nogap = count_nogap;
        }
        return 0;
    }

    public static class NoGap {
        int num_nogap;
    }

    private static enum ID3TAG_MODE {
        ID3TAG_MODE_DEFAULT,
        ID3TAG_MODE_V1_ONLY,
        ID3TAG_MODE_V2_ONLY;

    }

    private static enum TextEncoding {
        TENC_RAW,
        TENC_LATIN1,
        TENC_UCS2;

    }
}

