# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-03-09 18:02
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('breach', '0006_sampleset_roundcardinality'),
    ]

    operations = [
        migrations.CreateModel(
            name='Round',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('index', models.IntegerField(default=1, help_text=('Which round of the attack this is. The first round has ', 'index 1.'))),
                ('roundcardinality', models.IntegerField(default=1, help_text="How many alphabet symbols are being tested in this round.This can be larger or equal to the current sampleset's candidatealphabet length, as other samplesets may not have the same candidatealphabet length. This discrepancy occurs when the target alphabet is not a perfect power of 2.")),
                ('amount', models.IntegerField(default=1, help_text='Number of samples contained in the sampleset')),
                ('knownsecret', models.CharField(default='', help_text='Known secret before the sample set was collected', max_length=255)),
                ('knownalphabet', models.CharField(help_text='The candidate alphabet for the next unknown character', max_length=255)),
            ],
        ),
        migrations.RemoveField(
            model_name='attackvectorelement',
            name='sampleset',
        ),
        migrations.RemoveField(
            model_name='sampleset',
            name='amount',
        ),
        migrations.RemoveField(
            model_name='sampleset',
            name='knownalphabet',
        ),
        migrations.RemoveField(
            model_name='sampleset',
            name='knownsecret',
        ),
        migrations.RemoveField(
            model_name='sampleset',
            name='roundcardinality',
        ),
        migrations.RemoveField(
            model_name='sampleset',
            name='victim',
        ),
        migrations.RemoveField(
            model_name='victim',
            name='round',
        ),
        migrations.AddField(
            model_name='target',
            name='secretlength',
            field=models.IntegerField(default=0, help_text='The length of the secret, if known. If the length of the secret is unknown, leave this as 0.'),
        ),
        migrations.AlterField(
            model_name='sampleset',
            name='round',
            field=models.ForeignKey(help_text='Which round this sampleset belongs to. Each round contains the collection of multiple samplesets pertaining to different candidate alphabets. To complete a round, enough samplesets must be completed to be able to make a decision for a state transition with a certain confidence.', on_delete=django.db.models.deletion.CASCADE, to='breach.Round'),
        ),
        migrations.DeleteModel(
            name='AttackVectorElement',
        ),
        migrations.AddField(
            model_name='round',
            name='victim',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='breach.Victim'),
        ),
        migrations.AlterUniqueTogether(
            name='round',
            unique_together=set([('victim', 'index')]),
        ),
    ]
