# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-02-27 11:55
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AttackVectorElement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('symbol', models.CharField(max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='SampleSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.IntegerField(default=1, help_text='Number of samples contained in the sampleset')),
                ('knownsecret', models.CharField(help_text='Known secret before the sample set was collected', max_length=255)),
                ('started', models.DateTimeField(default=django.utils.timezone.now, help_text='Date and time at which sample set collection was started')),
                ('completed', models.DateTimeField(help_text='When we stopped collecting samples for this sampleset, successfully or not')),
                ('success', models.BooleanField(help_text='Whether the samples in this sampleset were all collected successfully')),
            ],
        ),
        migrations.CreateModel(
            name='Target',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint', models.CharField(max_length=255)),
                ('prefix', models.CharField(max_length=255)),
                ('alphabet', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Victim',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='breach.Target')),
            ],
        ),
        migrations.AddField(
            model_name='sampleset',
            name='victim',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='breach.Victim'),
        ),
        migrations.AddField(
            model_name='attackvectorelement',
            name='sampleset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='breach.SampleSet'),
        ),
    ]
