/*
 * Copyright (c) BindView Development Corporation, 2001
 * See LICENSE file.
 * Author: Todd Sabin <tsabin@razor.bindview.com>
 */


#include <windows.h>
#include <winnt.h>

#include <stdio.h>

#include <rpc.h>
#include <rpcdce.h>

static int verbosity;

int
do_ifids (char *target, char *protseq, char *endpoint)
{
    RPC_STATUS rpcErr;
    RPC_BINDING_HANDLE hRpc = NULL;
    RPC_IF_ID_VECTOR *pVector = NULL;
    char *strBinding = NULL;
    unsigned int i;

    rpcErr = RpcStringBindingCompose (NULL, protseq, target, endpoint,
                                      NULL, &strBinding);
    if (rpcErr != RPC_S_OK) {
        fprintf (stderr, "RpcStringBindingCompose failed: %d\n", rpcErr);
        return -1;
    }

    rpcErr = RpcBindingFromStringBinding (strBinding, &hRpc);
    RpcStringFree (&strBinding);
    if (rpcErr != RPC_S_OK) {
        fprintf (stderr, "RpcBindingFromStringBinding failed: %d\n", rpcErr);
        return -1;
    }

    rpcErr = RpcMgmtInqIfIds (hRpc, &pVector);
    RpcBindingFree (hRpc);
    hRpc = NULL;
    if (rpcErr != RPC_S_OK) {
        fprintf (stderr, "RpcMgmtInqIfIds failed: %d\n", rpcErr);
        return -1;
    }

    printf ("Interfaces: %d\n", pVector->Count);
    for (i=0; i<pVector->Count; i++) {
        unsigned char *str = NULL;
        UuidToString (&pVector->IfId[i]->Uuid, &str);
        printf ("  %s v%d.%d\n", str ? str : "(null)",
                pVector->IfId[i]->VersMajor,
                pVector->IfId[i]->VersMinor);
        if (str)
            RpcStringFree (&str);
    }
    RpcIfIdVectorFree (&pVector);

    return 0;
}



void
Usage (char *app)
{
    printf ("Usage: %s [options] -e <endpoint> <target>\n", app);
    printf ("  options:\n");
    printf ("    -p protseq   -- use protocol sequence\n", app);
    printf ("    -e endpoint  -- talk to endpoint\n", app);
    exit (1);
}



int
main (int argc, char *argv[1])
{
    int i;
    char *target = NULL;
    char *protseq = "ncacn_ip_tcp";
    char *endpoint = NULL;

    for (i=1; i<argc; i++) {
        if (argv[i][0] == '-') {
            switch (argv[i][1]) {

            case 'v':
                verbosity++;
                break;

            case 'p':
                protseq = argv[++i];
                break;

            case 'e':
                endpoint = argv[++i];
                break;

            default:
                fprintf (stderr, "Unknown option: %s\n", argv[i]);
                exit (1);
                break;
            }
        } else {
            target = argv[i];
        }
    }

    if (!target || !endpoint) {
        Usage (argv[0]);
    }

    do_ifids (target, protseq, endpoint);

    return 0;
}

