/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

public final class BehaviorStack {
    private static final String BEHAVIOR_STACK = "org.richfaces.BehaviorStack";
    private LinkedList<BehaviorInfoImpl> behaviorStack = new LinkedList();

    public static BehaviorStack getBehaviorStack(FacesContext context, boolean createIfNull) {
        Map<Object, Object> attributes = context.getAttributes();
        BehaviorStack behaviorStack = (BehaviorStack)attributes.get(BEHAVIOR_STACK);
        if (behaviorStack == null && createIfNull) {
            behaviorStack = new BehaviorStack();
            attributes.put(BEHAVIOR_STACK, behaviorStack);
        }
        return behaviorStack;
    }

    public boolean isEmpty() {
        return this.behaviorStack.isEmpty();
    }

    public void addBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        for (BehaviorInfoImpl behaviorInfo : this.behaviorStack) {
            behaviorInfo.addBehavior(context, behaviorHolder);
        }
    }

    public void pushBehavior(FacesContext context, ClientBehavior clientBehavior, String behaviorId, String eventName) {
        Object behaviorState = ((StateHolder)((Object)clientBehavior)).saveState(context);
        this.behaviorStack.addFirst(new BehaviorInfoImpl(behaviorId, eventName, behaviorState));
    }

    public BehaviorInfo popBehavior() {
        if (!this.behaviorStack.isEmpty()) {
            return this.behaviorStack.removeFirst();
        }
        return null;
    }

    private static class BehaviorInfoImpl
    implements BehaviorInfo {
        private String behaviorId;
        private Object behaviorState;
        private String eventName;
        private List<ClientBehavior> behaviors;

        public BehaviorInfoImpl(String behaviorId, String eventName, Object behaviorState) {
            this.behaviorId = behaviorId;
            this.eventName = eventName;
            this.behaviorState = behaviorState;
        }

        private void addBehavior(FacesContext context, ClientBehaviorHolder behaviorHolder) {
            String eventName = this.eventName;
            if (eventName == null && (eventName = behaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(behaviorHolder, eventName)) {
                ClientBehavior behavior = this.createBehavior(context);
                behaviorHolder.addClientBehavior(eventName, behavior);
            }
        }

        @Override
        public List<ClientBehavior> getBehaviors() {
            return this.behaviors;
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder behaviorHolder, String eventName) {
            if (!behaviorHolder.getEventNames().contains(eventName)) {
                return false;
            }
            Map<String, List<ClientBehavior>> clientBehaviorsMap = behaviorHolder.getClientBehaviors();
            List<ClientBehavior> clientBehaviors = clientBehaviorsMap.get(eventName);
            if (clientBehaviors == null || clientBehaviors.isEmpty()) {
                return true;
            }
            for (ClientBehavior behavior : clientBehaviors) {
                Set<ClientBehaviorHint> hints = behavior.getHints();
                if (!hints.contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext context) {
            Application application = context.getApplication();
            ClientBehavior behavior = (ClientBehavior)application.createBehavior(this.behaviorId);
            ((StateHolder)((Object)behavior)).restoreState(context, this.behaviorState);
            if (this.behaviors == null) {
                this.behaviors = new ArrayList<ClientBehavior>();
            }
            this.behaviors.add(behavior);
            return behavior;
        }
    }

    public static interface BehaviorInfo {
        public List<ClientBehavior> getBehaviors();
    }
}

