/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

final class MavenLogErrorReporter
implements ErrorReporter {
    private String resourceName;
    private StringBuilder errorMessages = new StringBuilder();
    private StringBuilder warningMessages = new StringBuilder();

    public MavenLogErrorReporter(String resourceName) {
        this.resourceName = resourceName;
    }

    private String formatMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        String location = MessageFormat.format("{0} (line {1}, col {2})", Strings.isNullOrEmpty(sourceName) ? this.resourceName : sourceName, lineSource, lineOffset);
        return MessageFormat.format("{0}: {1}\n{2}", location, message, lineSource);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.warningMessages.append(this.formatMessage(message, sourceName, line, lineSource, lineOffset));
        this.warningMessages.append('\n');
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.errorMessages.append(this.formatMessage(message, sourceName, line, lineSource, lineOffset));
        this.errorMessages.append('\n');
    }

    public boolean hasErrors() {
        return this.errorMessages.length() > 0;
    }

    public String getErrorsLog() {
        return this.errorMessages.toString();
    }

    public boolean hasWarnings() {
        return this.warningMessages.length() > 0;
    }

    public String getWarningsLog() {
        return this.warningMessages.toString();
    }
}

