/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.strings.Constants;
import org.richfaces.resource.optimizer.vfs.VFSRoot;
import org.richfaces.resource.optimizer.vfs.VirtualFile;

public final class ResourceUtil {
    private static final String CLASSPATH_RESOURCES_LOCATION = "META-INF/resources";
    private static final String WEB_RESOURCES_LOCATION = "resources";
    private static final Pattern LIBRARY_VERSION_PATTERN = Pattern.compile("^(\\d+)(_\\d+)+");
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("^((?:\\d+)(?:_\\d+)+)[\\.]?(\\w+)?");

    private ResourceUtil() {
    }

    public static VirtualFile getLatestVersion(VirtualFile file, boolean library) {
        VersionKey latestVersionKey = null;
        Collection<VirtualFile> children = file.getChildren();
        for (VirtualFile child : children) {
            Matcher matcher;
            if (library && child.isDirectory()) {
                matcher = LIBRARY_VERSION_PATTERN.matcher(child.getName());
                if (!matcher.matches()) continue;
                latestVersionKey = VersionKey.ORDERING.max(latestVersionKey, new VersionKey(child.getName(), null));
                continue;
            }
            if (library || !child.isFile() || !(matcher = RESOURCE_VERSION_PATTERN.matcher(child.getName())).matches()) continue;
            latestVersionKey = VersionKey.ORDERING.max(latestVersionKey, new VersionKey(matcher.group(1), matcher.group(2)));
        }
        VirtualFile result = latestVersionKey != null ? file.getChild(latestVersionKey.toString()) : file;
        if (result != null && library ^ result.isFile()) {
            return result;
        }
        return null;
    }

    private static Collection<VirtualFile> getExistingChildren(Iterable<VFSRoot> files, String path) throws URISyntaxException, IOException {
        ArrayList<VirtualFile> result = Lists.newArrayList();
        for (VirtualFile virtualFile : files) {
            VirtualFile child = virtualFile.getChild(path, true);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public static Collection<VirtualFile> getResourceRoots(Iterable<VFSRoot> cpRoots, Iterable<VFSRoot> webRoots) throws URISyntaxException, IOException {
        ArrayList<VirtualFile> result = Lists.newArrayList();
        result.addAll(ResourceUtil.getExistingChildren(cpRoots, CLASSPATH_RESOURCES_LOCATION));
        result.addAll(ResourceUtil.getExistingChildren(webRoots, WEB_RESOURCES_LOCATION));
        return result;
    }

    public static String getResourceQualifier(Resource resource) {
        return Constants.COLON_JOINER.join(resource.getLibraryName(), resource.getResourceName(), new Object[0]);
    }

    public static String getResourceQualifier(ResourceKey resourceKey) {
        return Constants.COLON_JOINER.join(resourceKey.getLibraryName(), resourceKey.getResourceName(), new Object[0]);
    }

    public static boolean isSameResource(Resource resource, ResourceKey resourceKey) {
        return resourceKey.getLibraryName().equals(ResourceUtil.defaultString(resource.getLibraryName())) && resourceKey.getResourceName().equals(resource.getResourceName());
    }

    private static String defaultString(String string) {
        return string == null ? null : string;
    }

    public static final class VersionKey {
        static final Ordering<VersionKey> ORDERING = Ordering.from(new Comparator<VersionKey>(){

            @Override
            public int compare(VersionKey o1, VersionKey o2) {
                return Ints.lexicographicalComparator().compare(o1.versionVector, o2.versionVector);
            }
        }).nullsFirst();
        private String version;
        private int[] versionVector;
        private String extension;

        public VersionKey(String version, String extension) throws NumberFormatException {
            this.version = version;
            this.versionVector = VersionKey.parseVersionString(version);
            this.extension = extension;
        }

        private static int[] parseVersionString(String s) {
            String[] split = s.split("_");
            int[] result = new int[split.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.parseInt(split[i]);
            }
            return result;
        }

        public String toString() {
            return Constants.DOT_JOINER.join(this.version, this.extension, new Object[0]);
        }
    }
}

