/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.richfaces.application.Initializable;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceSkinUtils;
import org.richfaces.resource.mapping.PropertiesMappingConfiguration;
import org.richfaces.resource.mapping.ResourceAggregator;
import org.richfaces.resource.mapping.ResourceMapper;
import org.richfaces.resource.mapping.ResourceMapping;
import org.richfaces.resource.mapping.ResourcePath;
import org.richfaces.resource.mapping.ResourceServletMapping;
import org.richfaces.services.Prioritizable;
import org.richfaces.skin.SkinFactory;
import org.richfaces.util.PropertiesUtil;

public class PropertiesResourceMapper
implements ResourceMapper,
ResourceAggregator,
Initializable,
Prioritizable {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private Map<ResourceKey, ResourceMapping> mappings;

    @Override
    public void init() {
        HashMap<ResourceKey, ResourceMapping> result = Maps.newHashMap();
        List<String> mappingFiles = PropertiesMappingConfiguration.getMappingFiles();
        for (String mappingFile : mappingFiles) {
            if (this.classpathResourceExistsForLocation(mappingFile)) {
                for (Map.Entry<String, String> entry : PropertiesUtil.loadProperties(mappingFile).entrySet()) {
                    ResourceKey resourceKey = ResourceKey.create(entry.getKey());
                    ResourcePath resourceLocation = new ResourcePath(entry.getValue());
                    result.put(resourceKey, new LocationBasedResourceMapping(resourceLocation));
                }
                continue;
            }
            if (this.isDefaultStaticResourceMappingLocation(mappingFile)) continue;
            LOGGER.warn("Resource mapping is configured to load non-existent resource: '" + mappingFile + "'");
        }
        this.mappings = result;
    }

    @Override
    public void release() {
        this.mappings.clear();
        this.mappings = null;
    }

    @Override
    public ResourceMapping mapResource(ResourceKey resourceKey) {
        return this.mappings.get(resourceKey);
    }

    @Override
    public Set<ResourceKey> getAggregatedResources(ResourcePath resourcePath) {
        FacesContext context = FacesContext.getCurrentInstance();
        HashSet<ResourceKey> result = Sets.newHashSet();
        for (Map.Entry<ResourceKey, ResourceMapping> entry : this.mappings.entrySet()) {
            ResourceKey resourceKey = entry.getKey();
            ResourceMapping mapping = entry.getValue();
            if (!mapping.getResourcePath(context).equals(resourcePath)) continue;
            result.add(resourceKey);
        }
        return result;
    }

    private boolean classpathResourceExistsForLocation(String location) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader.getResource(location) != null;
    }

    private boolean isDefaultStaticResourceMappingLocation(String location) {
        return "META-INF/richfaces/static-resource-mappings.properties".equals(location);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private static class LocationBasedResourceMapping
    implements ResourceMapping {
        private ResourcePath resourcePath;

        public LocationBasedResourceMapping(ResourcePath resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Override
        public ResourcePath getResourcePath(FacesContext context) {
            if (this.resourcePath.isAbsoluteURL()) {
                return this.resourcePath;
            }
            return this.createRequestPathRelativeLocation();
        }

        private ResourcePath createRequestPathRelativeLocation() {
            FacesContext context = FacesContext.getCurrentInstance();
            ResourcePath location = this.resourcePath;
            if (ResourceSkinUtils.isSkinDependent(this.resourcePath.toExternalForm())) {
                SkinFactory skinFactory = SkinFactory.getInstance(context);
                String skinName = skinFactory.getSkin(context).getName();
                location = new ResourcePath(ResourceSkinUtils.evaluateSkinInPath(this.resourcePath.toExternalForm(), skinName));
            }
            return new ResourceServletMapping(location).getResourcePath(context);
        }
    }
}

