/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.resource.mapping.ResourceLoadingOptimizationConfiguration;

final class PropertiesMappingConfiguration {
    public static final String DEFAULT_STATIC_RESOURCE_MAPPING_LOCATION = "META-INF/richfaces/static-resource-mappings.properties";

    PropertiesMappingConfiguration() {
    }

    static String getLocation() {
        return PropertiesMappingConfiguration.getConfiguration(CoreConfiguration.Items.resourceMappingLocation);
    }

    static List<String> getMappingFiles() {
        LinkedList<String> mappingFiles = Lists.newLinkedList();
        if (ResourceLoadingOptimizationConfiguration.isEnabled()) {
            mappingFiles.add(ResourceLoadingOptimizationConfiguration.getResourceLoadingSpecificMappingFile());
        }
        mappingFiles.add(PropertiesMappingConfiguration.getDefaultMappingFile());
        mappingFiles.addAll(PropertiesMappingConfiguration.getUserConfiguredMappingFile());
        return mappingFiles;
    }

    private static String getDefaultMappingFile() {
        return DEFAULT_STATIC_RESOURCE_MAPPING_LOCATION;
    }

    private static List<String> getUserConfiguredMappingFile() {
        String configured = PropertiesMappingConfiguration.getConfiguration(CoreConfiguration.Items.resourceMappingFile);
        if (configured == null) {
            return Arrays.asList(new Object[0]);
        }
        return Arrays.asList(configured.split(","));
    }

    static String getConfiguration(CoreConfiguration.Items configurationItem) {
        return ConfigurationServiceHelper.getStringConfigurationValue(FacesContext.getCurrentInstance(), configurationItem);
    }
}

