/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Date;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractBaseResource;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.ResourceUtils;

public abstract class AbstractCacheableResource
extends AbstractBaseResource
implements CacheableResource {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private boolean cacheable = true;

    @Override
    public boolean isCacheable(FacesContext context) {
        return this.cacheable;
    }

    private static boolean isUserCopyActual(Date lastModified, Date modifiedCondition) {
        return lastModified.getTime() - modifiedCondition.getTime() <= 1000L;
    }

    @Deprecated
    protected Boolean isMatchesLastModified(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map<String, String> requestHeaderMap = externalContext.getRequestHeaderMap();
        String modifiedCondition = requestHeaderMap.get("If-Modified-Since");
        if (modifiedCondition == null) {
            return null;
        }
        return this.isMatchesLastModified(context, modifiedCondition);
    }

    protected boolean isMatchesLastModified(FacesContext context, String modifiedCondition) {
        Date lastModified = this.getLastModified(context);
        if (lastModified == null) {
            return false;
        }
        return AbstractCacheableResource.isUserCopyActual(lastModified, ResourceUtils.parseHttpDate(modifiedCondition));
    }

    @Deprecated
    protected Boolean isMatchesEntityTag(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map<String, String> requestHeaderMap = externalContext.getRequestHeaderMap();
        String matchHeaderValue = requestHeaderMap.get("If-None-Match");
        if (matchHeaderValue == null) {
            return null;
        }
        return this.isMatchesEntityTag(context, matchHeaderValue);
    }

    protected boolean isMatchesEntityTag(FacesContext context, String matchHeaderValue) {
        String resourceEntityTag = this.getEntityTag(context);
        if (resourceEntityTag == null) {
            return false;
        }
        return ResourceUtils.matchTag(resourceEntityTag, matchHeaderValue);
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (!this.isCacheable(context)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource is not cacheable");
            }
            return true;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map<String, String> requestHeaderMap = externalContext.getRequestHeaderMap();
        String modifiedCondition = requestHeaderMap.get("If-Modified-Since");
        String matchHeaderValue = requestHeaderMap.get("If-None-Match");
        if (modifiedCondition == null && matchHeaderValue == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: no cache information was provided in request");
            }
            return true;
        }
        if (matchHeaderValue != null && !this.isMatchesEntityTag(context, matchHeaderValue)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: entity tags don't match");
            }
            return true;
        }
        if (modifiedCondition != null && !this.isMatchesLastModified(context, modifiedCondition)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource was modified since the last request");
            }
            return true;
        }
        return false;
    }

    @Override
    public Date getExpires(FacesContext context) {
        return null;
    }

    @Override
    public int getTimeToLive(FacesContext context) {
        return 0;
    }

    @Override
    public String getEntityTag(FacesContext context) {
        int contentLength = this.getContentLength(context);
        Date lastModified = this.getLastModified(context);
        if (contentLength < 0 || lastModified == null) {
            return null;
        }
        return ResourceUtils.formatWeakTag(contentLength + "-" + lastModified.getTime());
    }

    @Override
    protected void addCacheControlResponseHeaders(FacesContext facesContext, Map<String, String> headers) {
        if (this.isCacheable(facesContext)) {
            String entityTag;
            String formattedExpireDate;
            long currentTime = this.getCurrentTime();
            long maxAge = this.getTimeToLive(facesContext);
            if (maxAge > 0L) {
                formattedExpireDate = ResourceUtils.formatHttpDate(currentTime + ResourceUtils.secondToMillis(maxAge));
            } else {
                Date expired = this.getExpires(facesContext);
                if (expired != null) {
                    formattedExpireDate = ResourceUtils.formatHttpDate(expired);
                    maxAge = ResourceUtils.millisToSecond(expired.getTime() - currentTime);
                } else {
                    maxAge = ConfigurationServiceHelper.getLongConfigurationValue(facesContext, CoreConfiguration.Items.resourcesTTL);
                    formattedExpireDate = ResourceUtils.formatHttpDate(currentTime + ResourceUtils.secondToMillis(maxAge));
                }
            }
            if (formattedExpireDate != null) {
                headers.put("Expires", formattedExpireDate);
            }
            if (maxAge > 0L) {
                headers.put("Cache-Control", "max-age=" + maxAge);
            }
            if ((entityTag = this.getEntityTag(facesContext)) != null) {
                headers.put("ETag", entityTag);
            }
        } else {
            this.addNoCacheResponseHeaders(facesContext, headers);
        }
    }
}

