/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class TreeLineImage
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(16, 16);
    protected Integer trimColorValue;

    public TreeLineImage() {
        this(DIMENSION);
    }

    protected TreeLineImage(Dimension dimension) {
        super(dimension);
    }

    @PostConstructResource
    public void init() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance(context).getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance(context).getDefaultSkin(context);
        this.trimColorValue = skin.getColorParameter(context, "trimColor");
        if (this.trimColorValue == null) {
            this.trimColorValue = defaultSkin.getColorParameter(context, "trimColor");
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        g2d.setColor(new Color(this.trimColorValue));
        g2d.drawLine(7, 0, 7, 15);
    }

    @Override
    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.trimColorValue);
    }

    @Override
    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.trimColorValue = dataInput.readInt();
    }

    @Override
    public boolean isTransient() {
        return false;
    }
}

