/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIToolBar;
import org.richfaces.component.UIToolBarGroup;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.renderkit.html.images.DotSeparatorImage;
import org.richfaces.renderkit.html.images.GridSeparatorImage;
import org.richfaces.renderkit.html.images.LineSeparatorImage;
import org.richfaces.renderkit.html.images.SquareSeparatorImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarRendererBase
extends HeaderResourcesRendererBase {
    private static final String[] ON_ITEM_EVENTS = new String[]{"onitemkeydown", "onitemkeypress", "onitemkeyup", "onitemclick", "onitemdblclick", "onitemmousedown", "onitemmousemove", "onitemmouseover", "onitemmouseout", "onitemmouseup"};

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        UIToolBar toolBar = (UIToolBar)component;
        List<UIComponent> children = toolBar.getChildren();
        String contentClass = (String)toolBar.getAttributes().get("contentClass");
        String contentStyle = (String)toolBar.getAttributes().get("contentStyle");
        if (null == contentClass) {
            contentClass = "";
        }
        if (null == contentStyle) {
            contentStyle = "";
        }
        if (children != null) {
            UIComponent child;
            LinkedList<UIComponent> childrenToTheLeft = new LinkedList<UIComponent>();
            LinkedList<UIComponent> childrenToTheRight = new LinkedList<UIComponent>();
            for (UIComponent child2 : children) {
                if (!child2.isRendered()) continue;
                if (child2 instanceof UIToolBarGroup) {
                    UIToolBarGroup group = (UIToolBarGroup)child2;
                    String location = group.getLocation();
                    if (location != null && location.equals("right")) {
                        childrenToTheRight.add(child2);
                        continue;
                    }
                    childrenToTheLeft.add(child2);
                    continue;
                }
                childrenToTheLeft.add(child2);
            }
            ResponseWriter writer = facesContext.getResponseWriter();
            Iterator it = childrenToTheLeft.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!(child instanceof UIToolBarGroup)) {
                    writer.startElement("td", component);
                    writer.writeAttribute("class", "rich-toolbar-item " + contentClass, null);
                    this.getUtils().writeAttribute(writer, "style", contentStyle);
                    this.encodeEventsAttributes(facesContext, toolBar, writer);
                }
                this.renderChild(facesContext, child);
                if (!(child instanceof UIToolBarGroup)) {
                    writer.endElement("td");
                }
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(facesContext, toolBar, writer);
            }
            writer.startElement("td", component);
            writer.writeAttribute("style", "width:100%", null);
            writer.endElement("td");
            it = childrenToTheRight.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                this.renderChild(facesContext, child);
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(facesContext, toolBar, writer);
            }
        }
    }

    protected void insertSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        boolean isSeparatorFacetRendered;
        UIComponent separatorFacet = component.getFacet("itemSeparator");
        boolean bl = isSeparatorFacetRendered = separatorFacet != null ? separatorFacet.isRendered() : false;
        if (isSeparatorFacetRendered) {
            writer.startElement("td", component);
            writer.writeAttribute("class", "rich-toolbar-separator", null);
            this.renderChild(context, separatorFacet);
            writer.endElement("td");
        } else {
            this.insertDefaultSeparatorIfNeed(context, component, writer);
        }
    }

    protected void insertDefaultSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String itemSeparator = (String)component.getAttributes().get("itemSeparator");
        if (itemSeparator != null && itemSeparator.length() != 0 && !itemSeparator.equalsIgnoreCase("none")) {
            String uri = null;
            uri = itemSeparator.equalsIgnoreCase("square") ? this.getResource(SquareSeparatorImage.class.getName()).getUri(context, component) : (itemSeparator.equalsIgnoreCase("disc") ? this.getResource(DotSeparatorImage.class.getName()).getUri(context, component) : (itemSeparator.equalsIgnoreCase("grid") ? this.getResource(GridSeparatorImage.class.getName()).getUri(context, component) : (itemSeparator.equalsIgnoreCase("line") ? this.getResource(LineSeparatorImage.class.getName()).getUri(context, component) : ViewUtil.getResourceURL(itemSeparator))));
            writer.startElement("td", component);
            writer.writeAttribute("align", "center", null);
            this.getUtils().writeAttribute(writer, "class", component.getAttributes().get("separatorClass"));
            writer.startElement("img", component);
            this.getUtils().writeAttribute(writer, "src", uri);
            this.getUtils().writeAttribute(writer, "alt", "");
            writer.endElement("img");
            writer.endElement("td");
        }
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIToolBar.class;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeEventsAttributes(FacesContext facesContext, UIComponent component, ResponseWriter writer) throws IOException {
        Map<String, Object> attributes = component.getAttributes();
        for (int i = 0; i < ON_ITEM_EVENTS.length; ++i) {
            String eventName = ON_ITEM_EVENTS[i];
            Object value = null;
            value = attributes.get(eventName);
            String attrvalue = "";
            if (null != value && !"".equals(value)) {
                attrvalue = attrvalue + value;
            }
            this.getUtils().writeAttribute(writer, eventName.replace("item", ""), attrvalue);
        }
    }

    public UIToolBar getParentToolBar(UIComponent component) {
        if (component instanceof UIToolBar) {
            return (UIToolBar)component;
        }
        if (component instanceof UIToolBarGroup) {
            return ((UIToolBarGroup)component).getToolBar();
        }
        UIComponent parent = component.getParent();
        if (!(parent instanceof UIToolBar)) {
            return null;
        }
        return (UIToolBar)parent;
    }
}

