/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.html.AjaxFunctionBuilder;
import org.richfaces.renderkit.html.ScrollableDataTableRendererState;

public class ScrollableDataTableOptions
extends ScriptOptions {
    public ScrollableDataTableOptions(UIScrollableDataTable grid) {
        super(grid);
        FacesContext context = FacesContext.getCurrentInstance();
        String id = grid.getBaseClientId(context);
        this.addOption("client_id", id);
        if (grid.getFacets().containsKey("splash")) {
            UIComponent splash = grid.getFacet("splash");
            String splash_id = splash.getClientId(context);
            this.addOption("splash_id", splash_id);
        }
        int columnCount = grid.getChildCount();
        this.addOption("columnsCount", new Integer(columnCount));
        this.addOption("rowsCount", new Integer(grid.getRows()));
        this.addEventHandler("onselectionchange");
        this.addOption("ids", ScrollableDataTableRendererState.getRendererState(context).getIds());
        this.addOption("hideWhenScrolling");
        JSFunctionDefinition functionDefinition = new JSFunctionDefinition(new Object[0]);
        JSReference sortEvent = new JSReference("event");
        functionDefinition.addParameter(sortEvent);
        functionDefinition.addToBody(this.onSortAjaxUpdate(context, grid));
        this.addOption("onSortAjaxUpdate", functionDefinition);
    }

    public String onSortAjaxUpdate(FacesContext context, UIScrollableDataTable grid) {
        JSReference sortColumn = new JSReference("event.column");
        JSReference sortOrder = new JSReference("event.order");
        JSReference sortStartRow = new JSReference("event.startRow");
        JSReference sortIndex = new JSReference("event.index");
        Map<String, Object> options = AjaxRendererUtils.buildEventOptions(context, (UIComponent)grid, true);
        Map parametersMap = (Map)options.get("parameters");
        String id = grid.getClientId(context);
        parametersMap.put(id + ":sortColumn", sortColumn);
        parametersMap.put(id + ":sortOrder", sortOrder);
        parametersMap.put(id + ":sortStartRow", sortStartRow);
        parametersMap.put(id + ":sortIndex", sortIndex);
        options.put("parameters", parametersMap);
        JSFunction function = AjaxRendererUtils.buildAjaxFunction(grid, context);
        options.put("oncomplete", AjaxFunctionBuilder.getOnComplete(context, grid, 0));
        function.addParameter(options);
        String completeFunction = function.toScript() + "; return false;";
        return completeFunction;
    }
}

