/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.CommonComponentsConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.component.QueueRegistry;
import org.richfaces.renderkit.RenderKitUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib")})
public class QueueResourceComponentRenderer
extends Renderer {
    static final String TYPE = "org.richfaces.QueueResourceComponentRenderer";
    private static final String FUNCTION_NAME = "RichFaces.queue.setQueueOptions";

    private void appendOptions(UIComponent queue, Map<String, Object> optionsHash) {
        Map<String, Object> attributes = queue.getAttributes();
        for (QueueOptions option : QueueOptions.values()) {
            String optionName = option.name();
            Object value = attributes.get(optionName);
            RenderKitUtils.addToScriptHash(optionsHash, optionName, value);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (!ConfigurationServiceHelper.getBooleanConfigurationValue(context, CommonComponentsConfiguration.Items.queueEnabled).booleanValue()) {
            return;
        }
        QueueRegistry registry = QueueRegistry.getInstance(context);
        if (registry != null && registry.hasQueuesToEncode()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("id", component.getClientId(context), null);
            writer.writeAttribute("type", "text/javascript", null);
            writer.writeText(FUNCTION_NAME, null);
            writer.writeText("({", null);
            LinkedHashMap<String, Object> queueOptionsMap = new LinkedHashMap<String, Object>();
            boolean isFirst = true;
            Map<String, UIComponent> registeredQueues = registry.getRegisteredQueues();
            for (Map.Entry<String, UIComponent> queueEntry : registeredQueues.entrySet()) {
                if (!queueEntry.getValue().isRendered()) break;
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.writeText(",", null);
                }
                queueOptionsMap.clear();
                String queueName = queueEntry.getKey();
                UIComponent queue = queueEntry.getValue();
                this.appendOptions(queue, queueOptionsMap);
                ScriptUtils.writeToStream(writer, queueName);
                writer.writeText(":", null);
                ScriptUtils.writeToStream(writer, queueOptionsMap);
            }
            writer.writeText("});", null);
            writer.endElement("script");
        }
    }

    private static enum QueueOptions {
        onbeforedomupdate,
        oncomplete,
        onerror,
        onrequestdequeue,
        onrequestqueue,
        onsubmit,
        requestDelay,
        queueId,
        ignoreDupResponses,
        requestGroupingId,
        status;

    }
}

