/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractProgressBar;
import org.richfaces.component.NumberUtils;
import org.richfaces.component.SwitchType;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.html.ProgressBarState;
import org.richfaces.renderkit.html.ProgressBarStateEncoder;
import org.richfaces.renderkit.util.AjaxRendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="progressBar.js"), @ResourceDependency(library="org.richfaces", name="progressBar.ecss")})
public class ProgressBarBaseRenderer
extends RendererBase
implements MetaComponentRenderer {
    private static final JSReference BEFORE_UPDATE_HANDLER = new JSReference("beforeUpdateHandler");
    private static final JSReference AFTER_UPDATE_HANDLER = new JSReference("afterUpdateHandler");
    private static final JSReference PARAMS = new JSReference("params");
    private static final ProgressBarStateEncoder FULL_ENCODER = new ProgressBarStateEncoder(false);
    private static final ProgressBarStateEncoder PARTIAL_ENCODER = new ProgressBarStateEncoder(true);
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        Map<String, String> params = context.getExternalContext().getRequestParameterMap();
        if (params.get(component.getClientId(context)) != null) {
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context) + '@' + "state");
        }
    }

    protected boolean isAjaxMode(UIComponent component) {
        if (this.isResourceMode(component)) {
            return false;
        }
        SwitchType mode = this.getModeOrDefault(component);
        if (mode == SwitchType.server) {
            throw new IllegalArgumentException("Progress bar doesn't support 'server' mode");
        }
        return SwitchType.ajax == mode;
    }

    protected boolean isResourceMode(UIComponent component) {
        return component.getAttributes().get("resource") != null;
    }

    protected ProgressBarState getCurrentState(FacesContext context, UIComponent component) {
        ProgressBarState result;
        if (this.isResourceMode(component)) {
            result = ProgressBarState.initialState;
        } else {
            Number minValue = NumberUtils.getNumber(this.getMinValueOrDefault(component));
            Number maxValue = NumberUtils.getNumber(this.getMaxValueOrDefault(component));
            Number value = NumberUtils.getNumber(this.getValueOrDefault(component));
            result = value.doubleValue() < minValue.doubleValue() ? ProgressBarState.initialState : (value.doubleValue() >= maxValue.doubleValue() ? ProgressBarState.finishState : ProgressBarState.progressState);
        }
        if (!(result != ProgressBarState.initialState && result != ProgressBarState.finishState || result.hasContent(context, component))) {
            result = ProgressBarState.progressState;
        }
        return result;
    }

    protected String getStateDisplayStyle(String currentState, String state) {
        if (currentState.equals(state)) {
            return null;
        }
        return "display: none";
    }

    protected String getSubmitFunction(FacesContext facesContext, UIComponent component) {
        if (!this.isAjaxMode(component)) {
            return null;
        }
        AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(facesContext, component);
        AjaxOptions options = ajaxFunction.getOptions();
        options.set("beforedomupdate", BEFORE_UPDATE_HANDLER);
        options.set("complete", AFTER_UPDATE_HANDLER);
        options.setClientParameters(PARAMS);
        return ajaxFunction.toScript();
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if (!"state".equals(metaComponentId)) {
            throw new IllegalArgumentException(metaComponentId);
        }
        ProgressBarState state = this.getCurrentState(context, component);
        ExtendedPartialViewContext partialContext = ExtendedPartialViewContext.getInstance(context);
        partialContext.getResponseComponentDataMap().put(component.getClientId(context), NumberUtils.getNumber(component.getAttributes().get("value")));
        PartialResponseWriter partialResponseWriter = context.getPartialViewContext().getPartialResponseWriter();
        partialResponseWriter.startUpdate(state.getStateClientId(context, component));
        state.encodeStateForMetaComponent(context, component, PARTIAL_ENCODER);
        partialResponseWriter.endUpdate();
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    protected ProgressBarStateEncoder getEncoder(FacesContext facesContext, UIComponent component) {
        return this.isAjaxMode(component) ? PARTIAL_ENCODER : FULL_ENCODER;
    }

    protected Object getMaxValueOrDefault(UIComponent component) {
        Object maxValue = ((AbstractProgressBar)component).getMaxValue();
        if (maxValue == null) {
            maxValue = 100;
        }
        return maxValue;
    }

    protected Object getMinValueOrDefault(UIComponent component) {
        Object maxValue = ((AbstractProgressBar)component).getMinValue();
        if (maxValue == null) {
            maxValue = 0;
        }
        return maxValue;
    }

    protected Object getValueOrDefault(UIComponent component) {
        Object value = ((AbstractProgressBar)component).getValue();
        if (value == null) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    protected SwitchType getModeOrDefault(UIComponent component) {
        SwitchType mode = ((AbstractProgressBar)component).getMode();
        if (mode == null) {
            mode = SwitchType.DEFAULT;
        }
        return mode;
    }
}

