/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.focus;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractFocus;
import org.richfaces.renderkit.focus.FocusRenderStrategy;
import org.richfaces.renderkit.util.RendererUtils;

public abstract class AbstractFocusRenderStrategy
implements FocusRenderStrategy {
    protected final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    protected String getFocusCandidatesAsString(FacesContext context, AbstractFocus component, UIForm form) {
        if (!component.isAjaxRendered() && context.getPartialViewContext().isAjaxRequest()) {
            return "";
        }
        Object[] focusCandidates = this.getFocusCandidates(context, component, form);
        if (focusCandidates.length == 0) {
            return form.getClientId(context);
        }
        String focusCandidatesAsString = Joiner.on(' ').join(focusCandidates);
        return focusCandidatesAsString;
    }

    private String[] getFocusCandidates(FacesContext context, AbstractFocus component, UIForm form) {
        UIComponent submittedFocus = this.getSubmittedFocus(context, component);
        if (component.isPreserve() && submittedFocus != null) {
            return new String[]{submittedFocus.getClientId(context)};
        }
        if (component.isValidationAware()) {
            return this.getClientIdsWithMessages(context, form);
        }
        return new String[]{form.getClientId(context)};
    }

    private String[] getClientIdsWithMessages(FacesContext context, UIForm form) {
        UnmodifiableIterator<String> clientIdsWithMessages = Iterators.filter(context.getClientIdsWithMessages(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return input != null;
            }
        });
        return Iterators.toArray(clientIdsWithMessages, String.class);
    }

    private UIComponent getSubmittedFocus(FacesContext context, AbstractFocus component) {
        String focusClientIds = this.getFocusClientIds(context, component);
        if (focusClientIds == null) {
            return null;
        }
        UIComponent focusedComponent = this.getFocusedComponent(context, component, focusClientIds);
        return focusedComponent;
    }

    private UIComponent getFocusedComponent(FacesContext context, AbstractFocus component, String focusClientIds) {
        Iterable<String> clientIds = Splitter.on(' ').split(focusClientIds);
        for (String clientId : clientIds) {
            UIComponent focusedComponent = this.RENDERER_UTILS.findComponentFor(component, clientId);
            if (!(focusedComponent instanceof EditableValueHolder)) continue;
            return focusedComponent;
        }
        return null;
    }

    private String getFocusClientIds(FacesContext context, AbstractFocus component) {
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String inputFocus = requestParameterMap.get("org.richfaces.focus");
        return inputFocus;
    }
}

