/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.webapp.tidy.TidyParser;
import org.ajax4jsf.webapp.tidy.TidyXMLFilter;
import org.richfaces.component.TemplateComponent;
import org.richfaces.renderkit.MacroDefinitionJSContentHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public abstract class TemplateEncoderRendererBase
extends HeaderResourcesRendererBase {
    private static TransformerFactory transformerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransformerFactory getTransformerFactory() {
        Class<TemplateEncoderRendererBase> clazz = TemplateEncoderRendererBase.class;
        synchronized (TemplateEncoderRendererBase.class) {
            if (transformerFactory == null) {
                transformerFactory = TransformerFactory.newInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return transformerFactory;
        }
    }

    public final boolean getRendersChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScriptBody(Writer writer, String string) throws IOException {
        if (string != null) {
            Properties tidyProperties = new Properties();
            InputStream propertiesStream = null;
            try {
                propertiesStream = URLToStreamHelper.urlToStreamSafe(TidyXMLFilter.class.getResource("tidy.properties"));
                tidyProperties.load(propertiesStream);
            }
            finally {
                if (propertiesStream != null) {
                    propertiesStream.close();
                }
            }
            TidyParser tidyParser = new TidyParser(tidyProperties);
            Document parsedHtml = tidyParser.parseHtmlByTidy(new StringReader(string), null);
            Element documentElement = null;
            if (parsedHtml != null) {
                documentElement = parsedHtml.getDocumentElement();
            }
            if (documentElement != null) {
                writer.write("[");
                NodeList nodeList = documentElement.getChildNodes();
                Node bodyNode = nodeList.item(nodeList.getLength() - 1);
                NodeList bodyChildren = bodyNode.getChildNodes();
                int bodyChildrenLength = bodyChildren.getLength();
                try {
                    Transformer transformer;
                    TransformerFactory factory;
                    TransformerFactory transformerFactory = factory = TemplateEncoderRendererBase.getTransformerFactory();
                    synchronized (transformerFactory) {
                        transformer = factory.newTransformer();
                    }
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    ContentHandler contentHandler = this.createContentHandler(writer);
                    SAXResult result = new SAXResult(contentHandler);
                    for (int i = 0; i < bodyChildrenLength; ++i) {
                        if (i != 0) {
                            writer.write(", ");
                        }
                        transformer.transform(new DOMSource(bodyChildren.item(i)), result);
                    }
                }
                catch (TransformerException e) {
                    throw new IOException(e.getMessage());
                }
                writer.write("]");
            } else {
                writer.write(ScriptUtils.toScript(JSReference.NULL));
            }
        } else {
            writer.write(ScriptUtils.toScript(JSReference.NULL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeScriptBody(FacesContext context, UIComponent component, boolean children) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringWriter dumpingWriter = new StringWriter();
        ResponseWriter clonedWriter = writer.cloneWithWriter(dumpingWriter);
        context.setResponseWriter(clonedWriter);
        TemplateComponent templateComponent = null;
        if (component instanceof TemplateComponent) {
            templateComponent = (TemplateComponent)((Object)component);
        }
        try {
            if (templateComponent != null) {
                templateComponent.startTemplateEncode();
            }
            if (children) {
                this.renderChildren(context, component);
            } else {
                this.renderChild(context, component);
            }
        }
        finally {
            if (templateComponent != null) {
                templateComponent.endTemplateEncode();
            }
            clonedWriter.flush();
            context.setResponseWriter(writer);
        }
        this.writeScriptBody(writer, dumpingWriter.toString());
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.write("var evaluator = ");
        this.writeScriptBody(context, component, true);
        writer.write(";\n new Insertion.Top($('" + component.getClientId(context) + "'), evaluator.invoke('getContent', window).join(''));");
        writer.endElement("script");
    }

    protected ContentHandler createContentHandler(Writer writer) {
        return new MacroDefinitionJSContentHandler(writer, "Richfaces.evalMacro(\"", "\", context)");
    }

    public static void main(String[] args) throws Exception {
        String s;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((s = reader.readLine()) != null) {
            buffer.append(s);
        }
        new TemplateEncoderRendererBase(){

            @Override
            protected Class<? extends UIComponent> getComponentClass() {
                return null;
            }
        }.writeScriptBody(new PrintWriter(System.out), buffer.toString());
    }
}

