/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.TabPanelRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabHeaderRendererBase
extends HeaderResourcesRendererBase {
    private static final String LABEL_SUFFIX = "_lbl";
    private static final String ONMOUSEOVER = "RichFaces.overTab(this);";
    private static final String ONMOUSEOUT = "RichFaces.outTab(this);";

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UITab.class;
    }

    public List encodeParams(FacesContext context, UITab component) throws IOException {
        UITab menuItem = component;
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        List<UIComponent> children = menuItem.getChildren();
        for (UIComponent child : children) {
            UIParameter param;
            String name;
            if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
            Object value = param.getValue();
            buff.append("_params[");
            buff.append(ScriptUtils.toScript(name));
            buff.append("] = ");
            buff.append(ScriptUtils.toScript(value));
            buff.append(";");
            params.add(buff.toString());
            buff.setLength(0);
        }
        return params;
    }

    public void encodeTabLabel(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = tab.isDisabled();
        UITabPanel pane = tab.getPane();
        String method = tab.getSwitchTypeOrDefault();
        boolean ajax = "ajax".equals(method);
        boolean clientSide = "client".equals(method);
        String label = tab.getLabel();
        if (label == null) {
            label = "";
        }
        String clientId = tab.getClientId(context);
        String defShift = tab.isActive() ? "position:relative; top:1px;" : "position:relative;";
        String componentStyle = (String)tab.getAttributes().get("style");
        String style = defShift + (componentStyle != null ? componentStyle : "");
        if (!disabled) {
            if (clientSide) {
                writer.writeAttribute("onclick", "if (RichFaces.onTabChange(event, '" + pane.getClientId(context) + "','" + clientId + "')) RichFaces.switchTab('" + pane.getClientId(context) + "','" + clientId + "','" + this.getUtils().formatValue(context, pane, tab.getName()) + "');", "switchScript");
            } else {
                String activeCheck = "if (RichFaces.isTabActive('" + clientId + LABEL_SUFFIX + "')) return false;";
                String eventCheck = " if (!RichFaces.onTabChange(event, '" + pane.getClientId(context) + "','" + clientId + "')) return false;";
                if (ajax) {
                    JSFunction function = AjaxRendererUtils.buildAjaxFunction(tab, context);
                    Map<String, Object> eventOptions = AjaxRendererUtils.buildEventOptions(context, (UIComponent)tab, true);
                    function.addParameter(eventOptions);
                    StringBuffer buffer = new StringBuffer();
                    function.appendScript(buffer);
                    buffer.append("; return false; this.onclick = null;");
                    String script = buffer.toString();
                    writer.writeAttribute("onclick", activeCheck + eventCheck + script, null);
                } else {
                    StringBuffer script = new StringBuffer("var _formName = A4J.findForm(this).id; var _paramName = '" + clientId + "_server_submit'; var _params = new Object(); _params[_paramName] = _paramName; ");
                    List params = this.encodeParams(context, tab);
                    Iterator iterator = params.iterator();
                    while (iterator.hasNext()) {
                        script.append(iterator.next());
                    }
                    script.append("_JSFFormSubmit('");
                    script.append(clientId);
                    script.append("', _formName, null, _params);");
                    script.append("this.onclick = null; _clearJSFFormParameters(_formName, null, [_paramName]);");
                    writer.writeAttribute("onclick", activeCheck + eventCheck + script.toString(), null);
                }
            }
        }
        String width = tab.getLabelWidth();
        style = style + ";height : 100%; ";
        if (width != null) {
            style = style + " width: " + this.getUtils().encodePctOrPx(width) + ";";
        }
        if (style != null) {
            writer.writeAttribute("style", style, "tabStyle");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeCellClasses(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = tab.isDisabled() ? "rich-tabhdr-cell-disabled" : (tab.isActive() ? "rich-tabhdr-cell-active" : "rich-tabhdr-cell-inactive");
        writer.writeAttribute("class", labelClass, null);
    }

    public void writeLabel(FacesContext context, UITab tab) throws IOException {
        UIComponent facet;
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = "";
        if (tab.isDisabled()) {
            labelClass = TabPanelRendererBase.getDisabledTabClass(tab);
        } else {
            labelClass = tab.isActive() ? TabPanelRendererBase.getActiveTabClass(tab) : TabPanelRendererBase.getInactiveTabClass(tab);
            writer.writeAttribute("onmouseover", ONMOUSEOVER, "tabOnMouseOver");
            writer.writeAttribute("onmouseout", ONMOUSEOUT, "tabOnMouseOut");
        }
        writer.writeAttribute("class", labelClass, "tabClass");
        String title = tab.getTitle();
        if (title != null && title.length() != 0) {
            writer.writeAttribute("title", title, null);
        }
        if ((facet = tab.getFacet("label")) != null && facet.isRendered()) {
            this.renderChild(context, facet);
        } else {
            String label = tab.getLabel();
            if (label == null || label.length() == 0) {
                label = "&#160;";
                writer.write(label);
            } else {
                writer.writeText(label, null);
            }
        }
    }

    protected String encodeTabLabelWidth(FacesContext context, UITab tab) {
        String labelWidth = tab.getLabelWidth();
        if (labelWidth == null || labelWidth.trim().length() == 0) {
            return "";
        }
        return "width: " + HtmlUtil.qualifySize((String)labelWidth) + ";";
    }

    public String encodeHeaderSpacing(FacesContext context, UITab tab) throws IOException {
        UITabPanel pane = tab.getPane();
        String headerSpacing = pane.getHeaderSpacing();
        return "width: " + HtmlUtil.qualifySize((String)headerSpacing) + "; ";
    }
}

