/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import javax.faces.component.UIComponent;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;

public class TabClassBuilder {
    public static final TabClassBuilder activeTabClassBuilder = new TabClassBuilder(){

        protected String getSpecificClassForAllTabs() {
            return "rich-tab-active";
        }

        protected String getSpecificTabClassFromPane(UITab tab, UITabPanel pane) {
            return TabClassBuilder.getStringAttributeOrEmptyString(pane, "activeTabClass");
        }
    };
    public static final TabClassBuilder disabledTabClassBuilder = new TabClassBuilder(){

        protected String getSpecificClassForAllTabs() {
            return "rich-tab-disabled";
        }

        protected String getSpecificTabClassFromPane(UITab tab, UITabPanel pane) {
            return TabClassBuilder.getStringAttributeOrEmptyString(pane, "disabledTabClass");
        }
    };
    public static final TabClassBuilder inactiveTabClassBuilder = new TabClassBuilder(){

        protected String getSpecificClassForAllTabs() {
            return "rich-tab-inactive";
        }

        protected String getSpecificTabClassFromPane(UITab tab, UITabPanel pane) {
            return TabClassBuilder.getStringAttributeOrEmptyString(pane, "inactiveTabClass");
        }
    };

    public static String getStringAttributeOrEmptyString(UIComponent component, String attributeName) {
        String attributeValue = (String)component.getAttributes().get(attributeName);
        if (null == attributeValue) {
            attributeValue = "";
        }
        return attributeValue;
    }

    public String buildTabClass(UITab tab) {
        UITabPanel pane = tab.getPane();
        StringBuffer labelClass = new StringBuffer();
        labelClass.append(this.getCommonClassForAllTabs()).append(" ").append(this.getSpecificClassForAllTabs()).append(" ").append(this.getCommonTabClassFromPane(pane)).append(" ").append(this.getSpecificTabClassFromPane(tab, pane)).append(" ").append(this.getSpecificClassFromTab(tab)).append(" ").append(this.getClassFromTab(tab));
        return labelClass.toString();
    }

    protected String getCommonClassForAllTabs() {
        return "rich-tab-header";
    }

    protected String getSpecificClassForAllTabs() {
        return "";
    }

    protected String getClassFromTab(UITab tab) {
        return TabClassBuilder.getStringAttributeOrEmptyString(tab, "styleClass");
    }

    protected String getSpecificClassFromTab(UITab tab) {
        return "";
    }

    protected String getCommonTabClassFromPane(UITabPanel pane) {
        return TabClassBuilder.getStringAttributeOrEmptyString(pane, "tabClass");
    }

    protected String getSpecificTabClassFromPane(UITab tab, UITabPanel pane) {
        return "";
    }
}

