/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl;

import java.util.Comparator;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.el.PropertyResolver;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;

public class PropertyResolverComparator
implements Comparator {
    private static SortField[] EMPTY = new SortField[0];
    private PropertyResolver resolver;
    private SortOrder sortOrder;

    public PropertyResolverComparator(SortOrder sortOrder) {
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        Application application = factory.getApplication();
        this.resolver = application.getPropertyResolver();
        this.sortOrder = sortOrder;
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        SortField[] fields = this.sortOrder == null ? EMPTY : this.sortOrder.getFields();
        for (int i = 0; i < fields.length && result == 0; ++i) {
            SortField field = fields[i];
            String name = field.getName();
            Boolean asc = field.getAscending();
            if (name == null || asc == null) continue;
            Object property1 = null;
            Object property2 = null;
            property1 = this.resolver.getValue(o1, name);
            property2 = this.resolver.getValue(o2, name);
            if (property1 instanceof Comparable && property2 instanceof Comparable) {
                result = ((Comparable)property1).compareTo(property2);
            }
            if (asc.booleanValue()) continue;
            result = -result;
        }
        return result;
    }
}

