/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.convert.Converter;
import javax.swing.tree.TreeNode;
import org.richfaces.convert.IntegerSequenceRowKeyConverter;
import org.richfaces.model.NodesTreeSequenceKeyModel;
import org.richfaces.model.SwingTreeNodeImpl;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.model.iterators.IterableDataTuplesIterator;

public class SwingTreeNodeDataModelImpl
extends NodesTreeSequenceKeyModel<TreeNode> {
    private static final Converter DEFAULT_CONVERTER = new IntegerSequenceRowKeyConverter();
    private boolean asksAllowsChildren = false;
    private Object wrappedData;

    private TreeNode createFakeRootNode(Object wrappedData) {
        ArrayList<TreeNode> nodes;
        if (wrappedData instanceof Collection) {
            nodes = (ArrayList<TreeNode>)wrappedData;
        } else if (wrappedData instanceof TreeNode) {
            nodes = Lists.newArrayList((TreeNode)wrappedData);
        } else if (wrappedData == null) {
            nodes = null;
        } else {
            throw new IllegalArgumentException(String.valueOf(wrappedData));
        }
        SwingTreeNodeImpl treeNodeImpl = new SwingTreeNodeImpl((Collection)nodes);
        treeNodeImpl.setAllowUpdateParents(false);
        return treeNodeImpl;
    }

    @Override
    public void setWrappedData(Object data) {
        this.wrappedData = data;
        this.setRootNode(this.createFakeRootNode(data));
    }

    @Override
    public Object getWrappedData() {
        return this.wrappedData;
    }

    protected TreeNode findChild(TreeNode parent, Integer simpleKey) {
        int childIdx = simpleKey;
        if (childIdx < parent.getChildCount()) {
            return parent.getChildAt(childIdx);
        }
        return null;
    }

    public Iterator<TreeDataModelTuple> children() {
        UnmodifiableIterator<? extends TreeNode> children = Iterators.forEnumeration(((TreeNode)this.getData()).children());
        return new IterableDataTuplesIterator(this.getRowKey(), children);
    }

    @Override
    public boolean isLeaf() {
        if (!this.asksAllowsChildren) {
            return ((TreeNode)this.getData()).isLeaf();
        }
        return !((TreeNode)this.getData()).getAllowsChildren();
    }

    @Override
    protected TreeNode setupChildContext(Object segment) {
        return this.findChild((TreeNode)this.getData(), (Integer)segment);
    }

    public Converter getRowKeyConverter() {
        return DEFAULT_CONVERTER;
    }
}

