/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.Collection;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.richfaces.model.NoRowAvailableException;

public class CollectionDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Collection<E> inner;
    private E[] arrayFromInner;

    public CollectionDataModel() {
        this(null);
    }

    public CollectionDataModel(Collection<E> collection) {
        this.setWrappedData(collection);
    }

    @Override
    public boolean isRowAvailable() {
        if (this.arrayFromInner == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.arrayFromInner.length;
    }

    @Override
    public int getRowCount() {
        if (this.arrayFromInner == null) {
            return -1;
        }
        return this.arrayFromInner.length;
    }

    @Override
    public E getRowData() {
        if (this.arrayFromInner == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.arrayFromInner[this.index];
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.arrayFromInner == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.inner;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.inner = null;
            this.arrayFromInner = null;
            this.setRowIndex(-1);
        } else {
            this.inner = (Collection)data;
            this.arrayFromInner = new Object[this.inner.size()];
            this.inner.toArray(this.arrayFromInner);
            this.setRowIndex(0);
        }
    }
}

