/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModelListener;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.richfaces.application.IterationComponentsConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.component.SortOrder;
import org.richfaces.model.Arrangeable;
import org.richfaces.model.ArrangeableState;
import org.richfaces.model.Filter;
import org.richfaces.model.FilterField;
import org.richfaces.model.SortField;

public class ArrangeableModel
extends ExtendedDataModel<Object>
implements Arrangeable {
    private ArrangeableState state;
    private List<Object> rowKeys;
    private ExtendedDataModel<?> originalModel;
    private String var;
    private String filterVar;
    private Comparator<? super String> stringComparator;

    public ArrangeableModel(ExtendedDataModel<?> originalModel, String var, String filterVar) {
        this.originalModel = originalModel;
        this.var = var;
        this.filterVar = filterVar;
    }

    @Override
    public void addDataModelListener(DataModelListener listener) {
        this.originalModel.addDataModelListener(listener);
    }

    @Override
    public void removeDataModelListener(DataModelListener listener) {
        this.originalModel.removeDataModelListener(listener);
    }

    @Override
    public DataModelListener[] getDataModelListeners() {
        return this.originalModel.getDataModelListeners();
    }

    @Override
    public Object getRowKey() {
        return this.originalModel.getRowKey();
    }

    @Override
    public void setRowKey(Object key) {
        this.originalModel.setRowKey(key);
    }

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) {
        SequenceRange seqRange = (SequenceRange)range;
        int rows = seqRange.getRows();
        int rowCount = this.getRowCount();
        int currentRow = seqRange.getFirstRow();
        if (rows > 0) {
            rows += currentRow;
            rows = Math.min(rows, rowCount);
        } else {
            rows = rowCount;
        }
        while (currentRow < rows) {
            visitor.process(context, this.rowKeys.get(currentRow), argument);
            ++currentRow;
        }
    }

    @Override
    public int getRowCount() {
        if (this.rowKeys == null) {
            return -1;
        }
        return this.rowKeys.size();
    }

    @Override
    public Object getRowData() {
        return this.originalModel.getRowData();
    }

    @Override
    public int getRowIndex() {
        return this.rowKeys.indexOf(this.originalModel.getRowKey());
    }

    @Override
    public Object getWrappedData() {
        return this.originalModel.getWrappedData();
    }

    @Override
    public boolean isRowAvailable() {
        return this.originalModel.isRowAvailable();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        Object originalKey = null;
        if (rowIndex >= 0 && rowIndex < this.rowKeys.size()) {
            originalKey = this.rowKeys.get(rowIndex);
        }
        this.originalModel.setRowKey(originalKey);
    }

    @Override
    public void setWrappedData(Object data) {
        this.originalModel.setWrappedData(data);
    }

    @Override
    public void arrange(FacesContext context, ArrangeableState state) {
        this.initializeRowKeys(context);
        if (state != null) {
            this.state = state;
            Map<String, Object> map = context.getExternalContext().getRequestMap();
            Object value = null;
            Object filterValue = null;
            if (this.var != null && this.var.length() > 0) {
                value = map.get(this.var);
            }
            if (this.filterVar != null && this.filterVar.length() > 0) {
                filterValue = map.get(this.filterVar);
            }
            this.filter(context);
            this.sort(context);
            if (this.var != null && this.var.length() > 0) {
                map.put(this.var, value);
            }
            if (this.filterVar != null && this.filterVar.length() > 0) {
                map.put(this.filterVar, filterValue);
            }
        }
    }

    private void initializeRowKeys(FacesContext context) {
        int rowCount = this.originalModel.getRowCount();
        this.rowKeys = rowCount > 0 ? new ArrayList<Object>(rowCount) : new ArrayList<Object>();
        Object rowKey = this.originalModel.getRowKey();
        this.originalModel.walk(context, new DataVisitor(){

            @Override
            public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                ArrangeableModel.this.originalModel.setRowKey(rowKey);
                if (ArrangeableModel.this.originalModel.isRowAvailable()) {
                    ArrangeableModel.this.rowKeys.add(rowKey);
                }
                return DataVisitResult.CONTINUE;
            }
        }, new SequenceRange(0, -1), null);
        this.originalModel.setRowKey(rowKey);
    }

    private void filter(FacesContext context) {
        List<FilterField> filterFields = this.state.getFilterFields();
        if (filterFields != null && !filterFields.isEmpty()) {
            ArrayList<Object> filteredCollection = new ArrayList<Object>();
            for (Object rowKey : this.rowKeys) {
                if (!this.accept(context, rowKey)) continue;
                filteredCollection.add(rowKey);
            }
            this.rowKeys = filteredCollection;
        }
    }

    private void sort(final FacesContext context) {
        List<SortField> sortFields = this.state.getSortFields();
        if (sortFields != null && !sortFields.isEmpty()) {
            Collections.sort(this.rowKeys, new Comparator<Object>(){

                @Override
                public int compare(Object rowKey1, Object rowKey2) {
                    return ArrangeableModel.this.compare(context, rowKey1, rowKey2);
                }
            });
        }
    }

    private boolean accept(FacesContext context, Object rowKey) {
        this.originalModel.setRowKey(rowKey);
        Object object = this.originalModel.getRowData();
        this.updateVar(context, this.var, object);
        for (FilterField filterField : this.state.getFilterFields()) {
            Filter filter = filterField.getFilter();
            if (filter != null && !filter.accept(object)) {
                return false;
            }
            ValueExpression filterExpression = filterField.getFilterExpression();
            if (filterExpression == null) continue;
            this.updateVar(context, this.filterVar, filterField.getFilterValue());
            if (!Boolean.FALSE.equals(filterExpression.getValue(context.getELContext()))) continue;
            return false;
        }
        return true;
    }

    private int compare(FacesContext context, Object rowKey1, Object rowKey2) {
        this.originalModel.setRowKey(rowKey1);
        Object object1 = this.originalModel.getRowData();
        this.originalModel.setRowKey(rowKey2);
        Object object2 = this.originalModel.getRowData();
        int result = 0;
        Iterator<SortField> iterator = this.state.getSortFields().iterator();
        while (iterator.hasNext() && result == 0) {
            SortField sortField = iterator.next();
            SortOrder sortOrder = sortField.getSortOrder();
            if (sortOrder == null || SortOrder.unsorted.equals((Object)sortOrder)) continue;
            Comparator comparator = sortField.getComparator();
            if (comparator != null) {
                result = comparator.compare(object1, object2);
            } else {
                ValueExpression sortBy = sortField.getSortBy();
                if (sortBy != null) {
                    this.updateVar(context, this.var, object1);
                    Object value1 = sortBy.getValue(context.getELContext());
                    this.updateVar(context, this.var, object2);
                    Object value2 = sortBy.getValue(context.getELContext());
                    result = this.compareSortByValues(context, value1, value2);
                }
            }
            if (!SortOrder.descending.equals((Object)sortOrder)) continue;
            result = -result;
        }
        return result;
    }

    private int compareSortByValues(FacesContext context, Object value1, Object value2) {
        int result = 0;
        if (value1 instanceof String && value2 instanceof String) {
            if (this.stringComparator == null) {
                this.stringComparator = this.createStringComparator(context);
            }
            result = this.stringComparator.compare(((String)value1).trim(), ((String)value2).trim());
        } else if (value1 == null && value2 != null) {
            result = -1;
        } else if (value2 == null && value1 != null) {
            result = 1;
        } else if (value1 instanceof Comparable) {
            result = ((Comparable)value1).compareTo(value2);
        }
        return result;
    }

    private Comparator<? super String> createStringComparator(FacesContext context) {
        Comparator<String> comparator = null;
        Locale locale = this.state.getLocale();
        comparator = locale != null && ConfigurationServiceHelper.getBooleanConfigurationValue(context, IterationComponentsConfiguration.Items.datatableUsesViewLocale) != false ? Collator.getInstance(locale) : new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
        return comparator;
    }

    private void updateVar(FacesContext context, String var, Object value) {
        if (var != null && var.length() > 0) {
            context.getExternalContext().getRequestMap().put(var, value);
        }
    }
}

